/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTCancel
implements BTMessage {
    private DirectByteBuffer buffer = null;
    private byte version;
    private String description = null;
    private final int piece_number;
    private final int piece_offset;
    private final int length;

    public BTCancel(int n, int n2, int n3, byte by) {
        this.piece_number = n;
        this.piece_offset = n2;
        this.length = n3;
        this.version = by;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getID() {
        return "BT_CANCEL";
    }

    public byte[] getIDBytes() {
        return BTMessage.ID_BT_CANCEL_BYTES;
    }

    public String getFeatureID() {
        return "BT1";
    }

    public int getFeatureSubID() {
        return 8;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_CANCEL piece #" + this.piece_number + ":" + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)15, 12);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.putInt((byte)11, this.piece_offset);
            this.buffer.putInt((byte)11, this.length);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (directByteBuffer.remaining((byte)11) != 12) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + directByteBuffer.remaining((byte)11) + "] != 12");
        }
        int n = directByteBuffer.getInt((byte)11);
        if (n < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: num < 0");
        }
        int n2 = directByteBuffer.getInt((byte)11);
        if (n2 < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: offset < 0");
        }
        int n3 = directByteBuffer.getInt((byte)11);
        if (n3 < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: lngth < 0");
        }
        directByteBuffer.returnToPool();
        return new BTCancel(n, n2, n3, by);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

