/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZHave
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int[] piece_numbers;

    public AZHave(int[] nArray, byte by) {
        this.piece_numbers = nArray;
        this.version = by;
    }

    public String getID() {
        return "AZ_HAVE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_HAVE_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 4;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.piece_numbers.length * 10);
        for (int i = 0; i < this.piece_numbers.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.piece_numbers[i]);
        }
        return this.getID() + " " + stringBuffer;
    }

    public int[] getPieceNumbers() {
        return this.piece_numbers;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap hashMap = new HashMap();
            ArrayList<Long> arrayList = new ArrayList<Long>(this.piece_numbers.length);
            for (int i = 0; i < this.piece_numbers.length; ++i) {
                arrayList.add(new Long(this.piece_numbers[i]));
            }
            hashMap.put("pieces", arrayList);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 1, this.getID());
        List list = (List)map.get("pieces");
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((Long)list.get(i)).intValue();
        }
        AZHave aZHave = new AZHave(nArray, by);
        return aZHave;
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

