/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessageFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class MessageManager {
    private static final MessageManager instance = new MessageManager();
    private final ByteArrayHashMap message_map = new ByteArrayHashMap();
    private final List messages = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("MessageManager");

    private MessageManager() {
    }

    public static MessageManager getSingleton() {
        return instance;
    }

    public void initialize() {
        AZMessageFactory.init();
        BTMessageFactory.init();
        LTMessageFactory.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageType(Message message) throws MessageException {
        try {
            this.this_mon.enter();
            byte[] byArray = message.getIDBytes();
            if (this.message_map.containsKey(byArray)) {
                throw new MessageException("message type [" + message.getID() + "] already registered!");
            }
            this.message_map.put(byArray, message);
            this.messages.add(message);
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMessageType(Message message) {
        try {
            this.this_mon.enter();
            this.message_map.remove(message.getIDBytes());
            this.messages.remove(message);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Message createMessage(byte[] byArray, DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        Message message = (Message)this.message_map.get(byArray);
        if (message == null) {
            throw new MessageException("message id[" + new String(byArray) + "] not registered");
        }
        return message.deserialize(directByteBuffer, by);
    }

    public Message lookupMessage(String string) {
        return (Message)this.message_map.get(string.getBytes());
    }

    public Message lookupMessage(byte[] byArray) {
        return (Message)this.message_map.get(byArray);
    }

    public Message[] getRegisteredMessages() {
        return this.messages.toArray(new Message[this.messages.size()]);
    }
}

