/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.aelitis.azureus.core.peermanager.control.impl.SpeedTokenDispenserBasic;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerControlSchedulerBasic
extends PeerControlSchedulerImpl
implements AzureusCoreStatsProvider {
    private Random random = new Random();
    private Map<PeerControlInstance, instanceWrapper> instance_map = new HashMap<PeerControlInstance, instanceWrapper>();
    private List<instanceWrapper> pending_registrations = new ArrayList<instanceWrapper>();
    private volatile boolean registrations_changed;
    protected AEMonitor this_mon = new AEMonitor("PeerControlSchedulerBasic");
    private final SpeedTokenDispenserBasic tokenDispenser = new SpeedTokenDispenserBasic();
    private long latest_time;
    private long last_lag_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        SystemTime.registerMonotonousConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(long l) {
                PeerControlSchedulerBasic peerControlSchedulerBasic = PeerControlSchedulerBasic.this;
                synchronized (peerControlSchedulerBasic) {
                    PeerControlSchedulerBasic.this.notify();
                }
            }
        });
        LinkedList<instanceWrapper> linkedList = new LinkedList<instanceWrapper>();
        long l = 0L;
        long l2 = SystemTime.getMonotonousTime();
        while (true) {
            if (this.registrations_changed) {
                try {
                    this.this_mon.enter();
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        if (!((instanceWrapper)iterator.next()).isUnregistered()) continue;
                        iterator.remove();
                    }
                    for (int i = 0; i < this.pending_registrations.size(); ++i) {
                        linkedList.add(this.pending_registrations.get(i));
                    }
                    this.pending_registrations.clear();
                    this.registrations_changed = false;
                    instanceWrapper instanceWrapper2 = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            this.latest_time = SystemTime.getMonotonousTime();
            long l3 = this.schedule_count;
            for (instanceWrapper instanceWrapper2 : linkedList) {
                long l4 = instanceWrapper2.getNextTick();
                long l5 = this.latest_time - l4;
                if (l5 < 0L) continue;
                ++l;
                instanceWrapper2.schedule(this.latest_time);
                ++this.schedule_count;
                long l6 = l4 + (long)SCHEDULE_PERIOD_MILLIS;
                if (l6 <= this.latest_time) {
                    l6 = this.latest_time + l4 % (long)SCHEDULE_PERIOD_MILLIS;
                }
                instanceWrapper2.setNextTick(l6);
            }
            PeerControlSchedulerBasic peerControlSchedulerBasic = this;
            synchronized (peerControlSchedulerBasic) {
                if (l3 == this.schedule_count) {
                    ++this.wait_count;
                    try {
                        long l7 = SystemTime.getHighPrecisionCounter();
                        this.wait(SCHEDULE_PERIOD_MILLIS);
                        long l8 = SystemTime.getHighPrecisionCounter() - l7;
                        this.total_wait_time += l8;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
            }
            long l9 = this.latest_time - l2;
            if (l9 <= 10000L) continue;
            l2 = this.latest_time;
            l = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerControlInstance peerControlInstance) {
        instanceWrapper instanceWrapper2 = new instanceWrapper(peerControlInstance);
        instanceWrapper2.setNextTick(this.latest_time + (long)this.random.nextInt(SCHEDULE_PERIOD_MILLIS));
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> hashMap = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            hashMap.put(peerControlInstance, instanceWrapper2);
            this.instance_map = hashMap;
            this.pending_registrations.add(instanceWrapper2);
            this.registrations_changed = true;
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerControlInstance peerControlInstance) {
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> hashMap = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            instanceWrapper instanceWrapper2 = (instanceWrapper)hashMap.remove(peerControlInstance);
            if (instanceWrapper2 == null) {
                Debug.out("instance wrapper not found");
                Object var5_4 = null;
                this.this_mon.exit();
                return;
            }
            instanceWrapper2.unregister();
            this.instance_map = hashMap;
            this.registrations_changed = true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var5_5 = null;
        this.this_mon.exit();
    }

    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    public void updateScheduleOrdering() {
    }

    protected class instanceWrapper {
        private PeerControlInstance instance;
        private boolean unregistered;
        private long next_tick;
        private long last_schedule;

        protected instanceWrapper(PeerControlInstance peerControlInstance) {
            this.instance = peerControlInstance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setNextTick(long l) {
            this.next_tick = l;
        }

        protected long getNextTick() {
            return this.next_tick;
        }

        protected String getName() {
            return this.instance.getName();
        }

        protected void schedule(long l) {
            if (l < 100000L) {
                Debug.out("eh?");
            }
            if (this.last_schedule > 0L && l - this.last_schedule > 1000L && l - PeerControlSchedulerBasic.this.last_lag_log > 1000L) {
                PeerControlSchedulerBasic.this.last_lag_log = l;
                System.out.println("Scheduling lagging: " + (l - this.last_schedule) + " - instances=" + PeerControlSchedulerBasic.this.instance_map.size());
            }
            this.last_schedule = l;
            try {
                this.instance.schedule();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }
}

