/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peer.cache.cachelogic;

import com.aelitis.azureus.core.peer.cache.CacheDiscoverer;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.peer.cache.CachePeer;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class CLCacheDiscovery
implements CacheDiscoverer {
    public static final String CDPDomainName = ".find-cache.com";
    public static final String CDPServerName = "cls.find-cache.com";
    public static final int CDPPort = 19523;
    public static final int CDPVersion = 0;
    public static final int CDPTimeout = 5000;
    static CDPResponse Response;

    private String byteArrayToHex(byte[] byArray, int n) {
        int n2 = byArray.length;
        if (n2 > n) {
            n2 = n;
        }
        String string = new String();
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i] & 0xFF;
            if (n3 < 16) {
                string = string + "0";
            }
            string = string + Integer.toHexString(n3);
        }
        return string;
    }

    private String lookupFarm() {
        if (Response != null) {
            if (Response.isStillValid()) {
                return Response.getFarmID();
            }
            Response = null;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(CDPServerName);
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(5000);
            CDPQuery cDPQuery = new CDPQuery("Azureus 4.5.0.4");
            byte[] byArray = cDPQuery.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 19523);
            datagramSocket.send(datagramPacket);
            byArray = new byte[262];
            datagramPacket.setData(byArray);
            datagramSocket.receive(datagramPacket);
            if (datagramPacket.getAddress() != inetAddress || datagramPacket.getPort() != 19523) {
                throw new Exception("CDP server address mismatch on response");
            }
            Response = new CDPResponse(datagramPacket.getData());
            return Response.getFarmID();
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof UnknownHostException)) {
                throwable.printStackTrace();
            }
            return "default";
        }
    }

    private String hashAnnounceURL(URL uRL) {
        byte[] byArray = new SHA1Hasher().calculateHash(uRL.getHost().getBytes());
        return this.byteArrayToHex(byArray, 16);
    }

    public InetAddress[] findCache(URL uRL, String string) {
        InetAddress[] inetAddressArray;
        String string2 = "bt-" + string.substring(0, 4) + ".bt-" + this.hashAnnounceURL(uRL) + "-" + this.lookupFarm() + CDPDomainName;
        try {
            inetAddressArray = InetAddress.getAllByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddressArray = new InetAddress[]{};
        }
        return inetAddressArray;
    }

    public InetAddress[] findCache(URL uRL, byte[] byArray) {
        return this.findCache(uRL, this.byteArrayToHex(byArray, 4));
    }

    public CachePeer[] lookup(TOTorrent tOTorrent) {
        try {
            InetAddress[] inetAddressArray = this.findCache(tOTorrent.getAnnounceURL(), tOTorrent.getHash());
            CachePeer[] cachePeerArray = new CachePeer[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                cachePeerArray[i] = new CacheDiscovery.CachePeerImpl(2, inetAddressArray[i], 6881);
            }
            return cachePeerArray;
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return new CachePeer[0];
        }
    }

    public CachePeer lookup(byte[] byArray, InetAddress inetAddress, int n) {
        if (PeerClassifier.getClientDescription(byArray).startsWith("CacheLogic")) {
            return new CacheDiscovery.CachePeerImpl(2, inetAddress, n);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedFile(new File("C:\\temp\\test.torrent"));
            CachePeer[] cachePeerArray = new CLCacheDiscovery().lookup(tOTorrent);
            System.out.println("peers=" + cachePeerArray.length);
            for (int i = 0; i < cachePeerArray.length; ++i) {
                System.out.println("    cache: " + cachePeerArray[i].getAddress() + ":" + cachePeerArray[i].getPort());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class CDPResponse {
        public static final int MinSize = 7;
        public static final int MaxSize = 262;
        String farmID;
        long validUntil;

        public CDPResponse(byte[] byArray) throws Exception {
            int n;
            if (byArray.length < 7 || 7 + byArray[6] > byArray.length) {
                throw new Exception("CDP response too short");
            }
            if (byArray[0] != 0) {
                throw new Exception("Unsupported CDP version");
            }
            this.farmID = new String();
            for (n = 0; n < byArray[6]; ++n) {
                this.farmID = this.farmID + (char)byArray[7 + n];
            }
            long l = 0L;
            for (n = 2; n < 6; ++n) {
                l = (l << 8) + (long)(byArray[n] & 0xFF);
            }
            this.validUntil = System.currentTimeMillis() + l * 1000L;
        }

        public String getFarmID() {
            return this.farmID;
        }

        public boolean isStillValid() {
            return System.currentTimeMillis() < this.validUntil;
        }
    }

    class CDPQuery {
        private String Client;

        public CDPQuery(String string) {
            this.Client = string;
        }

        byte[] getBytes() {
            String string = "@@@" + this.Client;
            byte[] byArray = string.getBytes();
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = (byte)this.Client.length();
            return byArray;
        }
    }
}

