/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPPacket;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class UDPConnectionSet {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final boolean DEBUG_SEQUENCES = false;
    private static final byte[] KEYA_IV = "UDPDriverKeyA".getBytes();
    private static final byte[] KEYB_IV = "UDPDriverKeyB".getBytes();
    private static final byte[] KEYC_IV = "UDPDriverKeyC".getBytes();
    private static final byte[] KEYD_IV = "UDPDriverKeyD".getBytes();
    private static final int MIN_MSS = 256;
    private static final int MAX_HEADER = 128;
    public static final int MIN_WRITE_PAYLOAD = 128;
    public static final int MAX_BUFFERED_PAYLOAD = 512;
    private UDPConnectionManager manager;
    private UDPSelector selector;
    private int local_port;
    private InetSocketAddress remote_address;
    private boolean outgoing;
    private String connection_key;
    private Random random;
    private UDPConnection lead_connection;
    private RC4Engine header_cipher_out;
    private RC4Engine header_cipher_in;
    private SequenceGenerator in_seq_generator;
    private SequenceGenerator out_seq_generator;
    private volatile boolean crypto_done;
    private volatile boolean failed;
    private Map connections = new HashMap();
    private LinkedList connection_writers = new LinkedList();
    private long total_tick_count;
    private static final int STATS_LOG_TIMER = 60000;
    private static final int STATS_LOG_TICKS = Math.max(1, 2400);
    private int stats_log_ticks = STATS_LOG_TICKS;
    private static final int IDLE_TIMER = 10000;
    private static final int IDLE_TICKS = Math.max(1, 400);
    private int idle_ticks = 0;
    private static final int TIMER_BASE_DEFAULT = 300;
    private static final int TIMER_BASE_MIN = 100;
    private static final int TIMER_BASE_MAX = 15000;
    private int current_timer_base;
    private int old_timer_base = this.current_timer_base = 300;
    private boolean timer_is_adjusting;
    private int stats_packets_unique_sent;
    private int stats_packets_resent_via_timer;
    private int stats_packets_unique_received;
    private int stats_packets_duplicates;
    private static final int STATS_RESET_TIMER = 30000;
    private long stats_reset_time = SystemTime.getCurrentTime();
    private int total_packets_sent = 0;
    private int total_data_sent = 0;
    private int total_data_resent = 0;
    private int total_protocol_sent = 0;
    private int total_protocol_resent = 0;
    private int total_packets_unique_sent = 0;
    private int total_packets_received = 0;
    private int total_packets_unique_received = 0;
    private int total_packets_duplicates = 0;
    private int total_packets_out_of_order = 0;
    private int total_packets_resent_via_timer = 0;
    private int total_packets_resent_via_ack = 0;
    private int retransmit_ticks = 0;
    private UDPPacket current_retransmit_target;
    private static final int RETRANSMIT_COUNT_LIMIT = 5;
    private static final int MIN_RETRANSMIT_TIMER = 100;
    private static final int MIN_RETRANSMIT_TICKS = Math.max(1, 4);
    private static final int MAX_RETRANSMIT_TIMER = 20000;
    private static final int MAX_RETRANSMIT_TICKS = Math.max(1, 800);
    private static final int MAX_TRANSMIT_UNACK_DATA_PACKETS = 10;
    private static final int MAX_TRANSMIT_UNACK_PACKETS = 14;
    private List transmit_unack_packets = new ArrayList();
    private static final int MAX_CONTIGUOUS_RETRANS_FOR_ACK = 3;
    private static final int MIN_KEEPALIVE_TIMER = 10000;
    private static final int MIN_KEEPALIVE_TICKS = Math.max(1, 400);
    private static final int MAX_KEEPALIVE_TIMER = 20000;
    private static final int MAX_KEEPALIVE_TICKS = Math.max(1, 800);
    private int keep_alive_ticks;
    private int receive_last_inorder_sequence = -1;
    private int receive_last_inorder_alt_sequence = -1;
    private int receive_their_last_inorder_sequence = -1;
    private static final int RECEIVE_UNACK_IN_SEQUENCE_LIMIT = 3;
    private long current_receive_unack_in_sequence_count = 0L;
    private long sent_receive_unack_in_sequence_count = 0L;
    private static final int RECEIVE_OUT_OF_ORDER_ACK_LIMIT = 3;
    private long current_receive_out_of_order_count = 0L;
    private long sent_receive_out_of_order_count = 0L;
    private static final int RECEIVE_DONE_SEQ_MAX = 128;
    private LinkedList receive_done_sequences = new LinkedList();
    private static final int RECEIVE_OUT_OF_ORDER_PACKETS_MAX = 64;
    private List receive_out_of_order_packets = new LinkedList();
    private int explicitack_ticks = 0;
    private static final int MAX_SEQ_MEMORY = Math.max(64, 14);

    protected UDPConnectionSet(UDPConnectionManager uDPConnectionManager, String string, UDPSelector uDPSelector, int n, InetSocketAddress inetSocketAddress) {
        this.manager = uDPConnectionManager;
        this.connection_key = string;
        this.selector = uDPSelector;
        this.local_port = n;
        this.remote_address = inetSocketAddress;
    }

    protected UDPSelector getSelector() {
        return this.selector;
    }

    protected InetSocketAddress getRemoteAddress() {
        return this.remote_address;
    }

    protected String getKey() {
        return this.connection_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(UDPConnection uDPConnection) throws IOException {
        UDPConnection uDPConnection2 = null;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            uDPConnection2 = this.connections.put(new Integer(uDPConnection.getID()), uDPConnection);
            if (this.connections.size() == 1 && this.lead_connection == null) {
                this.lead_connection = uDPConnection;
                this.outgoing = true;
            }
        }
        if (uDPConnection2 != null) {
            Debug.out("Duplicate connection");
            uDPConnection2.close("Duplication connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(UDPConnection uDPConnection) {
        Map map = this.connections;
        synchronized (map) {
            this.connections.remove(new Integer(uDPConnection.getID()));
            return this.connections.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        Map map = this.connections;
        synchronized (map) {
            Iterator iterator = this.connections.values().iterator();
            while (iterator.hasNext()) {
                ((UDPConnection)iterator.next()).poll();
            }
        }
    }

    protected void setSecret(UDPConnection uDPConnection, byte[] byArray) {
        try {
            if (uDPConnection == this.lead_connection) {
                if (this.manager.trace()) {
                    this.trace("crypto done");
                }
                SHA1Hasher sHA1Hasher = new SHA1Hasher();
                sHA1Hasher.update(KEYA_IV);
                sHA1Hasher.update(byArray);
                byte[] byArray2 = sHA1Hasher.getDigest();
                sHA1Hasher = new SHA1Hasher();
                sHA1Hasher.update(KEYB_IV);
                sHA1Hasher.update(byArray);
                byte[] byArray3 = sHA1Hasher.getDigest();
                sHA1Hasher = new SHA1Hasher();
                sHA1Hasher.update(KEYC_IV);
                sHA1Hasher.update(byArray);
                byte[] byArray4 = sHA1Hasher.getDigest();
                sHA1Hasher = new SHA1Hasher();
                sHA1Hasher.update(KEYD_IV);
                sHA1Hasher.update(byArray);
                byte[] byArray5 = sHA1Hasher.getDigest();
                RC4Engine rC4Engine = this.getCipher(byArray2);
                RC4Engine rC4Engine2 = this.getCipher(byArray3);
                RC4Engine rC4Engine3 = this.getCipher(byArray4);
                RC4Engine rC4Engine4 = this.getCipher(byArray5);
                if (this.lead_connection.isIncoming()) {
                    this.header_cipher_out = rC4Engine;
                    this.header_cipher_in = rC4Engine2;
                    this.out_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(byArray5)), rC4Engine3, false);
                    this.in_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(byArray4)), rC4Engine4, true);
                    this.random = new Random(this.bytesToLong(byArray5, 8));
                } else {
                    this.header_cipher_out = rC4Engine2;
                    this.header_cipher_in = rC4Engine;
                    this.in_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(byArray5)), rC4Engine3, true);
                    this.out_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(byArray4)), rC4Engine4, false);
                    this.random = new Random(this.bytesToLong(byArray4, 8));
                }
                this.out_seq_generator.getNextSequenceNumber();
                int[] nArray = this.in_seq_generator.getNextSequenceNumber();
                this.receive_last_inorder_alt_sequence = nArray[3];
                this.crypto_done = true;
            } else if (!this.crypto_done) {
                Debug.out("Secondary setSecret but crypto not done");
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            uDPConnection.close("Crypto problems: " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    protected RC4Engine getCipher(byte[] byArray) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "RC4");
        RC4Engine rC4Engine = new RC4Engine();
        KeyParameter keyParameter = new KeyParameter(secretKeySpec.getEncoded());
        rC4Engine.init(true, keyParameter);
        byte[] byArray2 = new byte[1024];
        rC4Engine.processBytes(byArray2, 0, byArray2.length, byArray2, 0);
        return rC4Engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTimerBase() {
        if (!this.outgoing) {
            return;
        }
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            if (this.timer_is_adjusting) {
                return;
            }
            if (this.stats_packets_unique_sent > 2) {
                float f;
                int n = this.current_timer_base;
                if (this.stats_packets_resent_via_timer > 0 && (double)(f = (float)this.stats_packets_resent_via_timer / (float)this.stats_packets_unique_sent) >= 0.25) {
                    n = (int)((float)this.current_timer_base * (f + 1.0f));
                    n = n / 10 * 10;
                    if ((n = Math.min(15000, n)) != this.current_timer_base && this.manager.trace()) {
                        this.trace("Increasing timer base from " + this.current_timer_base + " to " + n + " due to resends (ratio=" + f + ")");
                    }
                }
                if (n == this.current_timer_base && this.stats_packets_unique_received > 2) {
                    f = (float)this.stats_packets_duplicates / (float)this.stats_packets_unique_received;
                    if ((double)(f /= 2.0f) >= 0.25) {
                        n = (int)((float)this.current_timer_base * (f + 1.0f));
                        n = n / 10 * 10;
                        if ((n = Math.min(15000, n)) != this.current_timer_base && this.manager.trace()) {
                            this.trace("Increasing timer base from " + this.current_timer_base + " to " + n + " due to duplicates (ratio=" + f + ")");
                        }
                    }
                }
                if (n == this.current_timer_base && this.stats_packets_unique_received > 2 && this.stats_packets_resent_via_timer == 0 && this.stats_packets_duplicates == 0) {
                    n = this.current_timer_base - this.current_timer_base / 10;
                    n = n / 10 * 10;
                    if ((n = Math.max(n, 100)) != this.current_timer_base && this.manager.trace()) {
                        this.trace("Decreasing timer base from " + this.current_timer_base + " to " + n);
                    }
                }
                boolean bl = false;
                long l = SystemTime.getCurrentTime();
                if (n == this.current_timer_base) {
                    if (l < this.stats_reset_time || l - this.stats_reset_time > 30000L) {
                        bl = true;
                    }
                } else {
                    this.timer_is_adjusting = true;
                    this.old_timer_base = this.current_timer_base;
                    this.current_timer_base = n;
                    bl = true;
                }
                if (bl) {
                    this.resetTimerStats();
                }
            }
        }
    }

    protected void resetTimerStats() {
        this.stats_reset_time = SystemTime.getCurrentTime();
        this.stats_packets_unique_sent = 0;
        this.stats_packets_resent_via_timer = 0;
        this.stats_packets_duplicates = 0;
        this.stats_packets_unique_received = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveTimerBase(int n) {
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            if (n != this.current_timer_base && this.manager.trace()) {
                this.trace("Received timer base: current=" + this.current_timer_base + ",theirs=" + n + "(adj=" + this.timer_is_adjusting + ")");
            }
            if (this.outgoing) {
                if (n == this.current_timer_base && this.timer_is_adjusting) {
                    this.timer_is_adjusting = false;
                    this.resetTimerStats();
                }
            } else {
                this.current_timer_base = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerTick() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            this.idle_ticks = this.connections.size() == 0 ? ++this.idle_ticks : 0;
            ++this.total_tick_count;
            if (this.retransmit_ticks > 0) {
                --this.retransmit_ticks;
                if (this.retransmit_ticks == 0) {
                    bl = true;
                }
            }
            if (this.explicitack_ticks > 0) {
                --this.explicitack_ticks;
                if (this.explicitack_ticks == 0) {
                    bl2 = true;
                }
            }
            if (this.keep_alive_ticks > 0) {
                --this.keep_alive_ticks;
                if (this.keep_alive_ticks == 0) {
                    bl3 = true;
                }
            }
            --this.stats_log_ticks;
            if (this.stats_log_ticks == 0) {
                this.logStats();
                this.stats_log_ticks = STATS_LOG_TICKS;
            }
        }
        if (bl) {
            this.retransmitExpired();
        }
        if (bl2) {
            this.sendAckCommand(true);
        }
        if (bl3) {
            this.sendStatsRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRetransmitTicks() {
        int n;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            n = this.timer_is_adjusting ? (this.current_timer_base > this.old_timer_base ? this.current_timer_base : this.old_timer_base) : this.current_timer_base;
        }
        int n2 = n * 5 / 3;
        return Math.max(1, n2 / 25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getExplicitAckTicks() {
        int n;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            n = this.timer_is_adjusting ? (this.current_timer_base > this.old_timer_base ? this.old_timer_base : this.current_timer_base) : this.current_timer_base;
        }
        return Math.max(1, n / 25);
    }

    protected void startKeepAliveTimer() {
        this.keep_alive_ticks = MIN_KEEPALIVE_TICKS + this.random.nextInt(MAX_KEEPALIVE_TICKS - MIN_KEEPALIVE_TICKS);
    }

    protected void stopKeepAliveTimer() {
        this.keep_alive_ticks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean idleLimitExceeded() {
        if (this.idle_ticks > IDLE_TICKS + (int)(Math.random() * 2000.0)) {
            Map map = this.connections;
            synchronized (map) {
                if (this.connections.size() == 0) {
                    this.failed = true;
                    return true;
                }
            }
        }
        return false;
    }

    protected UDPPacket getRetransmitPacket() {
        Iterator iterator = this.transmit_unack_packets.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            UDPPacket uDPPacket = (UDPPacket)iterator.next();
            if (uDPPacket.hasBeenReceived() || !(bl = uDPPacket.isAutoRetransmit()) && !iterator.hasNext()) continue;
            return uDPPacket;
        }
        return null;
    }

    protected int getRetransmitTicks(int n) {
        int n2 = this.getRetransmitTicks();
        int n3 = n == 0 ? n2 : n2 + (MAX_RETRANSMIT_TICKS - n2) * n / 4;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retransmitExpired() throws IOException {
        UDPPacket uDPPacket = null;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            uDPPacket = this.getRetransmitPacket();
            if (uDPPacket != null) {
                ++this.stats_packets_resent_via_timer;
                ++this.total_packets_resent_via_timer;
                uDPPacket.resent();
            }
        }
        if (uDPPacket != null) {
            if (this.manager.trace()) {
                this.trace("Retransmit: " + uDPPacket.getString());
            }
            this.send(uDPPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remoteLastInSequence(int n) {
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (int i = 0; i < this.transmit_unack_packets.size(); ++i) {
                UDPPacket uDPPacket = (UDPPacket)this.transmit_unack_packets.get(i);
                if (uDPPacket.getAlternativeSequence() != n) continue;
                this.receive_their_last_inorder_sequence = uDPPacket.getSequence();
                for (int j = 0; j <= i; ++j) {
                    this.transmit_unack_packets.remove(0);
                }
                return true;
            }
        }
        return false;
    }

    protected synchronized void dumpState() {
        if (this.manager.trace()) {
            String string = "State:";
            String string2 = "";
            for (int i = 0; i < this.transmit_unack_packets.size(); ++i) {
                UDPPacket uDPPacket = (UDPPacket)this.transmit_unack_packets.get(i);
                string2 = string2 + (i == 0 ? "" : ",") + uDPPacket.getString();
            }
            string = string + "unack=" + string2 + ",last_in_order=" + this.receive_last_inorder_sequence + ",current_in_seq=" + this.current_receive_unack_in_sequence_count + ",sent_in_seq=" + this.sent_receive_unack_in_sequence_count + ",current_oo=" + this.current_receive_out_of_order_count + ",sent_oo=" + this.sent_receive_out_of_order_count;
            String string3 = "";
            for (int i = 0; i < this.receive_out_of_order_packets.size(); ++i) {
                Object[] objectArray = (Object[])this.receive_out_of_order_packets.get(i);
                string3 = string3 + (i == 0 ? "" : ",") + objectArray[0] + "/" + objectArray[1] + "/" + (objectArray[2] == null ? "null" : String.valueOf(((ByteBuffer)objectArray[2]).remaining()));
            }
            string = string + ",oo=" + string3;
            string = string + ",sent_data=" + this.total_data_sent + "/" + this.total_data_resent + ",sent_prot=" + this.total_protocol_sent + "/" + this.total_protocol_resent;
            this.trace(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(UDPPacket uDPPacket) throws IOException {
        if (this.failed) {
            throw new IOException("Connection set has failed");
        }
        byte[] byArray = uDPPacket.getBuffer();
        if (this.manager.trace()) {
            this.trace(uDPPacket.getConnection(), "Write: " + uDPPacket.getString());
        }
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            short s;
            UDPPacket uDPPacket2;
            ++this.total_packets_sent;
            short s2 = uDPPacket.getResendCount();
            if (s2 > 5) {
                throw new IOException("Packet resend limit exceeded");
            }
            long l = uDPPacket.getUnAckInSequenceCount();
            if (l > this.sent_receive_unack_in_sequence_count) {
                this.sent_receive_unack_in_sequence_count = l;
            }
            if ((uDPPacket2 = this.getRetransmitPacket()) == null) {
                this.retransmit_ticks = 0;
            } else if (uDPPacket2 != this.current_retransmit_target || uDPPacket2 == uDPPacket) {
                this.retransmit_ticks = this.getRetransmitTicks(s2);
            } else if (this.retransmit_ticks == 0) {
                this.retransmit_ticks = this.getRetransmitTicks(s2);
            }
            this.current_retransmit_target = uDPPacket2;
            if (uDPPacket.getAlternativeSequence() != -1) {
                byte[] byArray2 = this.intToBytes(this.receive_last_inorder_alt_sequence);
                byArray[0] = byArray2[0];
                byArray[1] = byArray2[1];
                byArray[8] = byArray2[2];
                byArray[9] = byArray2[3];
            }
            if ((s = uDPPacket.sent(this.total_tick_count)) == 1) {
                if (uDPPacket.getCommand() == 1) {
                    ++this.total_data_sent;
                } else {
                    ++this.total_protocol_sent;
                }
            } else if (uDPPacket.getCommand() == 1) {
                ++this.total_data_resent;
            } else {
                ++this.total_protocol_resent;
            }
        }
        this.manager.send(this.local_port, this.remote_address, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive(byte[] var1_1, int var2_2) throws IOException {
        block151: {
            block150: {
                block149: {
                    block148: {
                        block147: {
                            block146: {
                                block145: {
                                    if (this.failed) {
                                        throw new IOException("Connection set has failed");
                                    }
                                    this.dumpState();
                                    if (this.manager.trace()) {
                                        this.trace("Read: total=" + var2_2);
                                    }
                                    var3_3 = this;
                                    synchronized (var3_3) {
                                        ++this.total_packets_received;
                                    }
                                    var3_3 = ByteBuffer.wrap(var1_1);
                                    var3_3.limit(var2_2);
                                    if (!this.crypto_done) {
                                        var3_3.position(4);
                                        var4_4 = new Integer(var3_3.getInt());
                                        var3_3.position(0);
                                        if (!this.receive_done_sequences.contains(var4_4)) {
                                            this.receive_done_sequences.addFirst(var4_4);
                                            if (this.receive_done_sequences.size() > 128) {
                                                this.receive_done_sequences.removeLast();
                                            }
                                        }
                                        if (this.outgoing) {
                                            this.remoteLastInSequence(-1);
                                        }
                                        this.receiveCrypto((ByteBuffer)var3_3);
                                        return;
                                    }
                                    var4_5 = new byte[]{var1_1[0], var1_1[1], var1_1[8], var1_1[9]};
                                    var5_6 = this.bytesToInt(var4_5, 0);
                                    var6_7 = this.remoteLastInSequence(var5_6);
                                    var7_8 = false;
                                    try {
                                        var3_3.getInt();
                                        var8_9 = new Integer(var3_3.getInt());
                                        var3_3.getInt();
                                        if (this.receive_done_sequences.contains(var8_9)) {
                                            if (this.manager.trace()) {
                                                this.trace("Duplicate processed packet: " + var8_9);
                                            }
                                            var9_10 = null;
                                            var10_12 = this;
                                            synchronized (var10_12) {
                                                ++this.stats_packets_duplicates;
                                                ++this.total_packets_duplicates;
                                                if (this.transmit_unack_packets.size() == 1 && !(var11_14 = (UDPPacket)this.transmit_unack_packets.get(0)).isAutoRetransmit() && this.total_tick_count - var11_14.getSendTickCount() >= (long)UDPConnectionSet.MIN_RETRANSMIT_TICKS) {
                                                    if (this.manager.trace()) {
                                                        this.trace("Retrans non-auto-retrans packet");
                                                    }
                                                    var9_10 = var11_14;
                                                }
                                                ** if (var9_10 == null) goto lbl53
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                this.send(var9_10);
                                            }
lbl53:
                                            // 2 sources

                                            var25_16 = null;
                                            var26_24 = false;
                                            var27_32 = this;
                                            break block145;
                                        }
                                        if (!this.out_seq_generator.isValidAlterativeSequence(var5_6)) {
                                            if (this.manager.trace()) {
                                                this.trace("Received invalid alternative sequence " + var5_6 + " - dropping packet");
                                            }
                                            break block146;
                                        }
                                        var9_11 = false;
                                        for (var10_13 = 0; var10_13 < this.receive_out_of_order_packets.size(); ++var10_13) {
                                            var11_15 = (Object[])this.receive_out_of_order_packets.get(var10_13);
                                            var12_72 = (Object[])var11_15[0];
                                            var13_73 = (ByteBuffer)var11_15[2];
                                            if (!var12_72.equals(var8_9)) continue;
                                            var14_74 = this;
                                            synchronized (var14_74) {
                                                if (var13_73 != null) {
                                                    ++this.stats_packets_duplicates;
                                                    ++this.total_packets_duplicates;
                                                    if (this.manager.trace()) {
                                                        this.trace("Duplicate out-of-order packet: " + var8_9);
                                                    }
                                                    // MONITOREXIT @DISABLED, blocks:[1, 20, 42, 142] lbl78 : MonitorExitStatement: MONITOREXIT : var14_74
                                                    break block147;
                                                }
                                                ++this.stats_packets_unique_received;
                                                ++this.total_packets_unique_received;
                                                if (this.manager.trace()) {
                                                    this.trace("Out-of-order packet entry data matched for seq " + var8_9);
                                                }
                                                var11_15[2] = var3_3;
                                                var9_11 = true;
                                                break;
                                            }
                                        }
                                        if (!var9_11) {
                                            var10_13 = 0;
                                            while (this.receive_out_of_order_packets.size() < 64) {
                                                var11_15 = this.in_seq_generator.getNextSequenceNumber();
                                                if (var8_9.intValue() == var11_15[1]) {
                                                    var12_72 = this;
                                                    synchronized (var12_72) {
                                                        ++this.stats_packets_unique_received;
                                                        ++this.total_packets_unique_received;
                                                        ** if (this.receive_out_of_order_packets.size() == 0 || !this.manager.trace()) goto lbl96
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        this.trace("Out-of-order packet entry adding for seq " + (int)var11_15[1]);
                                                    }
lbl96:
                                                    // 2 sources

                                                    this.receive_out_of_order_packets.add(new Object[]{var8_9, new Integer((int)var11_15[3]), var3_3});
                                                    var10_13 = 1;
                                                    break;
                                                }
                                                if (this.manager.trace()) {
                                                    this.trace("Out-of-order packet: adding spacer for seq " + (int)var11_15[1]);
                                                }
                                                this.receive_out_of_order_packets.add(new Object[]{new Integer((int)var11_15[1]), new Integer((int)var11_15[3]), null});
                                            }
                                            if (var10_13 == 0) {
                                                if (this.manager.trace()) {
                                                    this.trace("Out-of-order packet dropped as too many pending");
                                                }
                                                break block148;
                                            }
                                        }
                                        var10_13 = 1;
                                        var11_15 = this.receive_out_of_order_packets.iterator();
                                        while (var11_15.hasNext() && (var13_73 = (ByteBuffer)(var12_72 = (Object[])var11_15.next())[2]) != null) {
                                            var11_15.remove();
                                            var14_74 = var13_73.array();
                                            if (var13_73 == var3_3) {
                                                var10_13 = 0;
                                            }
                                            var15_75 = this;
                                            synchronized (var15_75) {
                                                ++this.current_receive_unack_in_sequence_count;
                                            }
                                            var15_75 = (Integer)var12_72[0];
                                            this.receive_last_inorder_sequence = var15_75.intValue();
                                            this.receive_last_inorder_alt_sequence = (Integer)var12_72[1];
                                            if (!this.receive_done_sequences.contains(var15_75)) {
                                                this.receive_done_sequences.addFirst(var15_75);
                                                if (this.receive_done_sequences.size() > 128) {
                                                    this.receive_done_sequences.removeLast();
                                                }
                                            }
                                            this.header_cipher_in.processBytes((byte[])var14_74, 12, 2, (byte[])var14_74, 12);
                                            var16_76 = var13_73.getShort() & 65535;
                                            if (var16_76 > ((Object)var14_74).length) {
                                                if (this.manager.trace()) {
                                                    this.trace("Header length too large");
                                                }
                                                break block149;
                                            }
                                            this.header_cipher_in.processBytes((byte[])var14_74, 14, var16_76 - 14, (byte[])var14_74, 14);
                                            var17_77 = new SHA1Hasher();
                                            var17_77.update((byte[])var14_74, 4, 4);
                                            var17_77.update((byte[])var14_74, 12, var16_76 - 4 - 12);
                                            var18_78 = var17_77.getDigest();
                                            for (var19_79 = 0; var19_79 < 4; ++var19_79) {
                                                if (var18_78[var19_79] == var14_74[var16_76 - 4 + var19_79]) continue;
                                                if (this.manager.trace()) {
                                                    this.trace("hash incorrect");
                                                }
                                                break block150;
                                            }
                                            var19_79 = var13_73.get();
                                            if (var19_79 != 1) {
                                                // empty if block
                                            }
                                            if (((var20_80 = var13_73.get()) & 1) != 0) {
                                                var7_8 = true;
                                            }
                                            var21_81 = (var13_73.getShort() & 65535) * 10;
                                            this.receiveTimerBase(var21_81);
                                            var22_82 = var13_73.get();
                                            if (var22_82 == 1) {
                                                this.receiveDataCommand(var15_75.intValue(), var13_73, var16_76);
                                                continue;
                                            }
                                            if (var22_82 == 2) {
                                                this.receiveAckCommand(var13_73);
                                                continue;
                                            }
                                            if (var22_82 == 3) {
                                                this.receiveCloseCommand(var13_73);
                                                continue;
                                            }
                                            if (var22_82 == 4) {
                                                this.receiveStatsRequest(var13_73);
                                                continue;
                                            }
                                            if (var22_82 != 5) continue;
                                            this.receiveStatsReply(var13_73);
                                        }
                                        if (var10_13 != 0) {
                                            var12_72 = this;
                                            synchronized (var12_72) {
                                                ++this.current_receive_out_of_order_count;
                                                ++this.total_packets_out_of_order;
                                            }
                                        }
                                        break block151;
                                    }
                                    catch (Throwable var24_83) {
                                        var25_23 = null;
                                        var26_31 = false;
                                        var27_39 = this;
                                        synchronized (var27_39) {
                                            var28_54 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                                            var30_63 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                                            if (var28_54 > 3L || var30_63 > 3L) {
                                                var26_31 = true;
                                            }
                                            ** if (!var26_31) goto lbl188
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            this.sendAckCommand(false);
                                        }
lbl188:
                                        // 2 sources

                                        var27_39 = this;
                                        synchronized (var27_39) {
                                            var28_54 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                                            if (var28_54 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                                                if (this.manager.trace()) {
                                                    this.trace("Not starting ack timer, only lazy ack received");
                                                }
                                                this.startKeepAliveTimer();
                                            } else {
                                                this.stopKeepAliveTimer();
                                                if ((var28_54 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                                                    this.explicitack_ticks = this.getExplicitAckTicks();
                                                }
                                            }
                                        }
                                        if (var6_7 == false) throw var24_83;
                                        var27_39 = this.connection_writers;
                                        synchronized (var27_39) {
                                            var28_55 = this.connection_writers.iterator();
                                            while (var28_55.hasNext() != false) {
                                                var29_71 = (UDPConnection)var28_55.next();
                                                if (var29_71.isConnected()) {
                                                    var29_71.sent();
                                                    continue;
                                                }
                                                var28_55.remove();
                                            }
                                            throw var24_83;
                                        }
                                    }
                                }
                                synchronized (var27_32) {
                                    var28_40 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                                    var30_56 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                                    if (var28_40 > 3L || var30_56 > 3L) {
                                        var26_24 = true;
                                    }
                                    ** if (!var26_24) goto lbl219
                                }
lbl-1000:
                                // 1 sources

                                {
                                    this.sendAckCommand(false);
                                }
lbl219:
                                // 2 sources

                                var27_32 = this;
                                synchronized (var27_32) {
                                    var28_40 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                                    if (var28_40 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                                        if (this.manager.trace()) {
                                            this.trace("Not starting ack timer, only lazy ack received");
                                        }
                                        this.startKeepAliveTimer();
                                    } else {
                                        this.stopKeepAliveTimer();
                                        if ((var28_40 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                                            this.explicitack_ticks = this.getExplicitAckTicks();
                                        }
                                    }
                                }
                                if (var6_7 == false) return;
                                var27_32 = this.connection_writers;
                                synchronized (var27_32) {
                                    var28_41 = this.connection_writers.iterator();
                                    while (var28_41.hasNext() != false) {
                                        var29_64 = (UDPConnection)var28_41.next();
                                        if (var29_64.isConnected()) {
                                            var29_64.sent();
                                            continue;
                                        }
                                        var28_41.remove();
                                    }
                                    return;
                                }
                            }
                            var25_17 = null;
                            var26_25 = false;
                            var27_33 = this;
                            synchronized (var27_33) {
                                var28_42 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                                var30_57 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                                if (var28_42 > 3L || var30_57 > 3L) {
                                    var26_25 = true;
                                }
                                ** if (!var26_25) goto lbl253
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.sendAckCommand(false);
                            }
lbl253:
                            // 2 sources

                            var27_33 = this;
                            synchronized (var27_33) {
                                var28_42 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                                if (var28_42 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                                    if (this.manager.trace()) {
                                        this.trace("Not starting ack timer, only lazy ack received");
                                    }
                                    this.startKeepAliveTimer();
                                } else {
                                    this.stopKeepAliveTimer();
                                    if ((var28_42 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                                        this.explicitack_ticks = this.getExplicitAckTicks();
                                    }
                                }
                            }
                            if (var6_7 == false) return;
                            var27_33 = this.connection_writers;
                            synchronized (var27_33) {
                                var28_43 = this.connection_writers.iterator();
                                while (var28_43.hasNext() != false) {
                                    var29_65 = (UDPConnection)var28_43.next();
                                    if (var29_65.isConnected()) {
                                        var29_65.sent();
                                        continue;
                                    }
                                    var28_43.remove();
                                }
                                return;
                            }
                        }
                        var25_18 = null;
                        var26_26 = false;
                        var27_34 = this;
                        synchronized (var27_34) {
                            var28_44 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                            var30_58 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                            if (var28_44 > 3L || var30_58 > 3L) {
                                var26_26 = true;
                            }
                            ** if (!var26_26) goto lbl287
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.sendAckCommand(false);
                        }
lbl287:
                        // 2 sources

                        var27_34 = this;
                        synchronized (var27_34) {
                            var28_44 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                            if (var28_44 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                                if (this.manager.trace()) {
                                    this.trace("Not starting ack timer, only lazy ack received");
                                }
                                this.startKeepAliveTimer();
                            } else {
                                this.stopKeepAliveTimer();
                                if ((var28_44 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                                    this.explicitack_ticks = this.getExplicitAckTicks();
                                }
                            }
                        }
                        if (var6_7 == false) return;
                        var27_34 = this.connection_writers;
                        synchronized (var27_34) {
                            var28_45 = this.connection_writers.iterator();
                            while (var28_45.hasNext() != false) {
                                var29_66 = (UDPConnection)var28_45.next();
                                if (var29_66.isConnected()) {
                                    var29_66.sent();
                                    continue;
                                }
                                var28_45.remove();
                            }
                            return;
                        }
                    }
                    var25_19 = null;
                    var26_27 = false;
                    var27_35 = this;
                    synchronized (var27_35) {
                        var28_46 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                        var30_59 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                        if (var28_46 > 3L || var30_59 > 3L) {
                            var26_27 = true;
                        }
                        ** if (!var26_27) goto lbl321
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.sendAckCommand(false);
                    }
lbl321:
                    // 2 sources

                    var27_35 = this;
                    synchronized (var27_35) {
                        var28_46 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                        if (var28_46 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                            if (this.manager.trace()) {
                                this.trace("Not starting ack timer, only lazy ack received");
                            }
                            this.startKeepAliveTimer();
                        } else {
                            this.stopKeepAliveTimer();
                            if ((var28_46 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                                this.explicitack_ticks = this.getExplicitAckTicks();
                            }
                        }
                    }
                    if (var6_7 == false) return;
                    var27_35 = this.connection_writers;
                    synchronized (var27_35) {
                        var28_47 = this.connection_writers.iterator();
                        while (var28_47.hasNext() != false) {
                            var29_67 = (UDPConnection)var28_47.next();
                            if (var29_67.isConnected()) {
                                var29_67.sent();
                                continue;
                            }
                            var28_47.remove();
                        }
                        return;
                    }
                }
                var25_20 = null;
                var26_28 = false;
                var27_36 = this;
                synchronized (var27_36) {
                    var28_48 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                    var30_60 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                    if (var28_48 > 3L || var30_60 > 3L) {
                        var26_28 = true;
                    }
                    ** if (!var26_28) goto lbl355
                }
lbl-1000:
                // 1 sources

                {
                    this.sendAckCommand(false);
                }
lbl355:
                // 2 sources

                var27_36 = this;
                synchronized (var27_36) {
                    var28_48 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                    if (var28_48 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                        if (this.manager.trace()) {
                            this.trace("Not starting ack timer, only lazy ack received");
                        }
                        this.startKeepAliveTimer();
                    } else {
                        this.stopKeepAliveTimer();
                        if ((var28_48 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                            this.explicitack_ticks = this.getExplicitAckTicks();
                        }
                    }
                }
                if (var6_7 == false) return;
                var27_36 = this.connection_writers;
                synchronized (var27_36) {
                    var28_49 = this.connection_writers.iterator();
                    while (var28_49.hasNext() != false) {
                        var29_68 = (UDPConnection)var28_49.next();
                        if (var29_68.isConnected()) {
                            var29_68.sent();
                            continue;
                        }
                        var28_49.remove();
                    }
                    return;
                }
            }
            var25_21 = null;
            var26_29 = false;
            var27_37 = this;
            synchronized (var27_37) {
                var28_50 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                var30_61 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
                if (var28_50 > 3L || var30_61 > 3L) {
                    var26_29 = true;
                }
                ** if (!var26_29) goto lbl389
            }
lbl-1000:
            // 1 sources

            {
                this.sendAckCommand(false);
            }
lbl389:
            // 2 sources

            var27_37 = this;
            synchronized (var27_37) {
                var28_50 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
                if (var28_50 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                    if (this.manager.trace()) {
                        this.trace("Not starting ack timer, only lazy ack received");
                    }
                    this.startKeepAliveTimer();
                } else {
                    this.stopKeepAliveTimer();
                    if ((var28_50 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                        this.explicitack_ticks = this.getExplicitAckTicks();
                    }
                }
            }
            if (var6_7 == false) return;
            var27_37 = this.connection_writers;
            synchronized (var27_37) {
                var28_51 = this.connection_writers.iterator();
                while (var28_51.hasNext() != false) {
                    var29_69 = (UDPConnection)var28_51.next();
                    if (var29_69.isConnected()) {
                        var29_69.sent();
                        continue;
                    }
                    var28_51.remove();
                }
                return;
            }
        }
        var25_22 = null;
        var26_30 = false;
        var27_38 = this;
        synchronized (var27_38) {
            var28_52 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
            var30_62 = this.current_receive_out_of_order_count - this.sent_receive_out_of_order_count;
            if (var28_52 > 3L || var30_62 > 3L) {
                var26_30 = true;
            }
            ** if (!var26_30) goto lbl423
        }
lbl-1000:
        // 1 sources

        {
            this.sendAckCommand(false);
        }
lbl423:
        // 2 sources

        var27_38 = this;
        synchronized (var27_38) {
            var28_52 = this.current_receive_unack_in_sequence_count - this.sent_receive_unack_in_sequence_count;
            if (var28_52 == 1L && var7_8 && this.receive_out_of_order_packets.size() == 0) {
                if (this.manager.trace()) {
                    this.trace("Not starting ack timer, only lazy ack received");
                }
                this.startKeepAliveTimer();
            } else {
                this.stopKeepAliveTimer();
                if ((var28_52 > 0L || this.receive_out_of_order_packets.size() > 0) && this.explicitack_ticks == 0) {
                    this.explicitack_ticks = this.getExplicitAckTicks();
                }
            }
        }
        if (var6_7 == false) return;
        var27_38 = this.connection_writers;
        synchronized (var27_38) {
            var28_53 = this.connection_writers.iterator();
            while (var28_53.hasNext() != false) {
                var29_70 = (UDPConnection)var28_53.next();
                if (var29_70.isConnected()) {
                    var29_70.sent();
                    continue;
                }
                var28_53.remove();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sendCrypto(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        byte[] byArray = new byte[n3];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (int i = n; i < n + n2; ++i) {
            byteBuffer.put(byteBufferArray[i]);
        }
        UDPPacket uDPPacket = new UDPPacket(this.lead_connection, new int[]{-1, -1, -1, -1}, 0, byArray, 0L);
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            ++this.stats_packets_unique_sent;
            ++this.total_packets_unique_sent;
            this.transmit_unack_packets.add(uDPPacket);
        }
        if (this.manager.trace()) {
            this.trace("sendCrypto: seq=" + uDPPacket.getSequence() + ", len=" + n3);
        }
        this.send(uDPPacket);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveCrypto(ByteBuffer byteBuffer) throws IOException {
        boolean bl = false;
        UDPConnection uDPConnection = null;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            if (this.connections.size() == 0) {
                uDPConnection = new UDPConnection(this, -1);
                this.connections.put(new Integer(uDPConnection.getID()), uDPConnection);
                this.lead_connection = uDPConnection;
                bl = true;
            } else {
                uDPConnection = this.lead_connection;
            }
        }
        if (bl) {
            this.manager.accept(this.local_port, this.remote_address, uDPConnection);
        }
        if (this.manager.trace()) {
            this.trace(uDPConnection, "readCrypto: rem=" + byteBuffer.remaining());
        }
        uDPConnection.receive(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sendDataCommand(UDPConnection uDPConnection, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        UDPPacket uDPPacket;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            long l = this.current_receive_unack_in_sequence_count;
            int[] nArray = this.writeHeaderStart(byteBuffer, (byte)1, (byte)0);
            byteBuffer.putInt(uDPConnection.getID());
            int n4 = this.writeHeaderEnd(byteBuffer, false);
            int n5 = uDPConnection.getTransport().getMss();
            if (n5 < 256) {
                n5 = 256;
            }
            if (n3 > n5 - n4) {
                n3 = n5 - n4;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            byte[] byArray2 = new byte[n4 + n3];
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
            byteBuffer2.put(byArray, 0, n4);
            int n6 = n3;
            for (int i = n; i < n + n2; ++i) {
                Object var22_20;
                ByteBuffer byteBuffer3 = byteBufferArray[i];
                int n7 = byteBuffer3.limit();
                try {
                    if (byteBuffer3.remaining() > n6) {
                        byteBuffer3.limit(byteBuffer3.position() + n6);
                    }
                    n6 -= byteBuffer3.remaining();
                    byteBuffer2.put(byteBuffer3);
                    var22_20 = null;
                    byteBuffer3.limit(n7);
                }
                catch (Throwable throwable) {
                    var22_20 = null;
                    byteBuffer3.limit(n7);
                    throw throwable;
                }
                if (n6 == 0) break;
            }
            uDPPacket = new UDPPacket(uDPConnection, nArray, 1, byArray2, l);
            this.transmit_unack_packets.add(uDPPacket);
        }
        if (this.manager.trace()) {
            this.trace(uDPConnection, "sendData: seq=" + uDPPacket.getSequence() + ",data=" + n3);
        }
        this.send(uDPPacket);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveDataCommand(int n, ByteBuffer byteBuffer, int n2) throws IOException {
        int n3 = byteBuffer.getInt();
        UDPConnection uDPConnection = null;
        boolean bl = false;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            uDPConnection = (UDPConnection)this.connections.get(new Integer(n3));
            if (uDPConnection == null && (uDPConnection = (UDPConnection)this.connections.remove(new Integer(-1))) != null) {
                uDPConnection.setID(n3);
                this.connections.put(new Integer(n3), uDPConnection);
            }
            if (uDPConnection == null) {
                if (this.connections.size() == 128) {
                    throw new IOException("Connection limit reached");
                }
                uDPConnection = new UDPConnection(this, n3);
                this.connections.put(new Integer(uDPConnection.getID()), uDPConnection);
                bl = true;
            }
        }
        byteBuffer.position(n2);
        if (bl) {
            this.manager.accept(this.local_port, this.remote_address, uDPConnection);
        }
        if (this.manager.trace()) {
            this.trace(uDPConnection, "receiveData: seq=" + n + ",data=" + byteBuffer.remaining());
        }
        uDPConnection.receive(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAckCommand(boolean bl) throws IOException {
        Object object = null;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (Object object2 : this.transmit_unack_packets) {
                if (((UDPPacket)object2).getCommand() != 2) continue;
                if (this.total_tick_count - ((UDPPacket)object2).getSendTickCount() >= (long)this.getExplicitAckTicks()) {
                    if (this.manager.trace()) {
                        this.trace(((UDPPacket)object2).getConnection(), "retransAck:" + ((UDPPacket)object2).getString());
                    }
                    object = object2;
                    break;
                }
                return;
            }
            if (object == null) {
                Object object2;
                object2 = new byte[516];
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object2);
                long l = this.current_receive_unack_in_sequence_count;
                boolean bl2 = this.transmit_unack_packets.size() == 0 && bl && this.receive_out_of_order_packets.size() == 0;
                int[] nArray = this.writeHeaderStart(byteBuffer, (byte)2, bl2 ? (byte)1 : 0);
                Iterator iterator = this.receive_out_of_order_packets.iterator();
                String string = "";
                int n = 0;
                while (iterator.hasNext() && n < 3) {
                    Object[] objectArray = (Object[])iterator.next();
                    if (objectArray[2] == null) continue;
                    int n2 = (Integer)objectArray[0];
                    int n3 = (Integer)objectArray[1];
                    string = string + (string.length() == 0 ? "" : ",") + n2 + "/" + n3;
                    byteBuffer.putInt(n2);
                    ++n;
                }
                byteBuffer.putInt(-1);
                if (n == 0) {
                    this.sent_receive_out_of_order_count = this.current_receive_out_of_order_count;
                } else {
                    this.sent_receive_out_of_order_count += (long)n;
                    if (this.sent_receive_out_of_order_count > this.current_receive_out_of_order_count) {
                        this.sent_receive_out_of_order_count = this.current_receive_out_of_order_count;
                    }
                }
                int n4 = this.writeHeaderEnd(byteBuffer, true);
                byte[] byArray = new byte[n4];
                System.arraycopy(object2, 0, byArray, 0, n4);
                object = new UDPPacket(this.lead_connection, nArray, 2, byArray, l);
                if (bl2) {
                    ((UDPPacket)object).setAutoRetransmit(false);
                    this.startKeepAliveTimer();
                }
                this.transmit_unack_packets.add(object);
                if (this.manager.trace()) {
                    this.trace(this.lead_connection, "sendAck: in_seq=" + this.receive_last_inorder_sequence + ",out_of_seq=" + string);
                }
            }
        }
        this.send((UDPPacket)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveAckCommand(ByteBuffer byteBuffer) throws IOException {
        ArrayList<UDPPacket> arrayList = new ArrayList<UDPPacket>();
        String string = "";
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            int n;
            Iterator iterator = this.transmit_unack_packets.iterator();
            block3: while (arrayList.size() < 3 && (n = byteBuffer.getInt()) != -1) {
                if (this.manager.trace()) {
                    string = string + (string.length() == 0 ? "" : ",") + n;
                }
                while (iterator.hasNext() && arrayList.size() < 3) {
                    UDPPacket uDPPacket = (UDPPacket)iterator.next();
                    if (uDPPacket.getSequence() == n) {
                        uDPPacket.setHasBeenReceived();
                        continue block3;
                    }
                    if (this.total_tick_count - uDPPacket.getSendTickCount() < (long)MIN_RETRANSMIT_TICKS || arrayList.contains(uDPPacket)) continue;
                    arrayList.add(uDPPacket);
                }
            }
            this.total_packets_resent_via_ack += arrayList.size();
        }
        if (this.manager.trace()) {
            this.trace("receiveAck: in_seq=" + this.receive_their_last_inorder_sequence + ",out_of_seq=" + string);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.send((UDPPacket)arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStatsRequest() throws IOException {
        Object object = null;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (Object object2 : this.transmit_unack_packets) {
                if (((UDPPacket)object2).getCommand() != 4) continue;
                if (this.total_tick_count - ((UDPPacket)object2).getSendTickCount() >= (long)MIN_RETRANSMIT_TICKS) {
                    if (this.manager.trace()) {
                        this.trace(((UDPPacket)object2).getConnection(), "retransStatsRequest:" + ((UDPPacket)object2).getString());
                    }
                    object = object2;
                    break;
                }
                return;
            }
            if (object == null) {
                Object object2;
                object2 = new byte[256];
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object2);
                long l = this.current_receive_unack_in_sequence_count;
                int[] nArray = this.writeHeaderStart(byteBuffer, (byte)4, (byte)0);
                int n = this.writeHeaderEnd(byteBuffer, true);
                byte[] byArray = new byte[n];
                System.arraycopy(object2, 0, byArray, 0, n);
                object = new UDPPacket(this.lead_connection, nArray, 4, byArray, l);
                this.transmit_unack_packets.add(object);
                if (this.manager.trace()) {
                    this.trace(this.lead_connection, "sendStatsRequest");
                }
            }
        }
        this.send((UDPPacket)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveStatsRequest(ByteBuffer byteBuffer) throws IOException {
        Object object = null;
        if (this.manager.trace()) {
            this.trace("ReceiveStatsRequest");
        }
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (Object object2 : this.transmit_unack_packets) {
                if (((UDPPacket)object2).getCommand() != 5) continue;
                if (this.total_tick_count - ((UDPPacket)object2).getSendTickCount() >= (long)MIN_RETRANSMIT_TICKS) {
                    if (this.manager.trace()) {
                        this.trace(((UDPPacket)object2).getConnection(), "retransStatsReply:" + ((UDPPacket)object2).getString());
                    }
                    object = object2;
                    break;
                }
                return;
            }
            if (object == null) {
                Object object2;
                object2 = new byte[256];
                ByteBuffer byteBuffer2 = ByteBuffer.wrap((byte[])object2);
                long l = this.current_receive_unack_in_sequence_count;
                boolean bl = this.transmit_unack_packets.size() == 0 && this.receive_out_of_order_packets.size() == 0;
                int[] nArray = this.writeHeaderStart(byteBuffer2, (byte)5, bl ? (byte)1 : 0);
                int n = this.writeHeaderEnd(byteBuffer2, true);
                byte[] byArray = new byte[n];
                System.arraycopy(object2, 0, byArray, 0, n);
                object = new UDPPacket(this.lead_connection, nArray, 5, byArray, l);
                if (bl) {
                    ((UDPPacket)object).setAutoRetransmit(false);
                }
                this.transmit_unack_packets.add(object);
                if (this.manager.trace()) {
                    this.trace(this.lead_connection, "sendStatsReply");
                }
            }
        }
        this.send((UDPPacket)object);
    }

    protected void receiveStatsReply(ByteBuffer byteBuffer) throws IOException {
        if (this.manager.trace()) {
            this.trace("receiveStatsReply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCloseCommand(UDPConnection uDPConnection) throws IOException {
        UDPPacket uDPPacket;
        if (this.crypto_done) {
            UDPConnectionSet uDPConnectionSet = this;
            synchronized (uDPConnectionSet) {
                byte[] byArray = new byte[256];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                long l = this.current_receive_unack_in_sequence_count;
                int[] nArray = this.writeHeaderStart(byteBuffer, (byte)3, (byte)0);
                byteBuffer.putInt(uDPConnection.getID());
                int n = this.writeHeaderEnd(byteBuffer, true);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                if (this.manager.trace()) {
                    this.trace(uDPConnection, "sendClose");
                }
                uDPPacket = new UDPPacket(this.lead_connection, nArray, 3, byArray2, l);
                this.transmit_unack_packets.add(uDPPacket);
            }
        } else {
            IOException iOException = new IOException("Connection failed during setup phase");
            this.failed(iOException);
            throw iOException;
        }
        this.send(uDPPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveCloseCommand(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        UDPConnection uDPConnection = null;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            uDPConnection = (UDPConnection)this.connections.get(new Integer(n));
        }
        if (this.manager.trace()) {
            this.trace("receiveClose: con=" + (uDPConnection == null ? "<null>" : "" + uDPConnection.getID()));
        }
        if (uDPConnection != null) {
            uDPConnection.close("Remote has closed the connection");
        }
    }

    protected int[] writeHeaderStart(ByteBuffer byteBuffer, byte by, byte by2) throws IOException {
        this.sendTimerBase();
        ++this.stats_packets_unique_sent;
        ++this.total_packets_unique_sent;
        int[] nArray = this.out_seq_generator.getNextSequenceNumber();
        int n = nArray[1];
        byteBuffer.putInt(nArray[0]);
        byteBuffer.putInt(n);
        byteBuffer.putInt(nArray[2]);
        byteBuffer.putShort((short)0);
        byteBuffer.put((byte)1);
        byteBuffer.put(by2);
        byteBuffer.putShort((short)(this.current_timer_base / 10));
        byteBuffer.put(by);
        return nArray;
    }

    protected int writeHeaderEnd(ByteBuffer byteBuffer, boolean bl) throws IOException {
        int n;
        if (bl) {
            n = this.random.nextInt(8);
            for (int i = 0; i < n; ++i) {
                byteBuffer.put((byte)0);
            }
        }
        n = byteBuffer.position();
        byteBuffer.position(12);
        byteBuffer.putShort((short)(n + 4));
        byte[] byArray = byteBuffer.array();
        SHA1Hasher sHA1Hasher = new SHA1Hasher();
        sHA1Hasher.update(byArray, 4, 4);
        sHA1Hasher.update(byArray, 12, n - 12);
        byte[] byArray2 = sHA1Hasher.getDigest();
        byteBuffer.position(n);
        byteBuffer.put(byArray2, 0, 4);
        n = (short)(n + 4);
        this.header_cipher_out.processBytes(byArray, 12, n - 12, byArray, 12);
        if (n > 128) {
            Debug.out("MAX_HEADER exceeded!!!!");
            throw new IOException("MAX_HEADER exceeded");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int write(UDPConnection uDPConnection, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.canWrite(uDPConnection)) {
            return 0;
        }
        LinkedList linkedList = this.connection_writers;
        synchronized (linkedList) {
            int n3 = this.connection_writers.size();
            if (n3 == 0) {
                this.connection_writers.add(uDPConnection);
            } else if (this.connection_writers.size() != 1 || this.connection_writers.get(0) != uDPConnection) {
                this.connection_writers.remove(uDPConnection);
                this.connection_writers.addLast(uDPConnection);
            }
        }
        if (this.total_packets_sent == 0) {
            return this.sendCrypto(byteBufferArray, n, n2);
        }
        return this.sendDataCommand(uDPConnection, byteBufferArray, n, n2);
    }

    protected boolean canWrite(UDPConnection uDPConnection) {
        if (!this.crypto_done) {
            if (uDPConnection != this.lead_connection) {
                return false;
            }
            if (this.total_packets_sent > 0) {
                return false;
            }
        }
        boolean bl = this.transmit_unack_packets.size() < 10;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(UDPConnection uDPConnection, String string) {
        boolean bl;
        if (this.manager.trace()) {
            this.trace(uDPConnection, "close: " + string);
        }
        Map map = this.connections;
        synchronized (map) {
            bl = this.connections.containsValue(uDPConnection);
        }
        if (bl) {
            try {
                this.sendCloseCommand(uDPConnection);
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
        uDPConnection.poll();
        this.manager.remove(this, uDPConnection);
    }

    public void failed(UDPConnection uDPConnection, Throwable throwable) {
        if (this.manager.trace()) {
            this.trace(uDPConnection, "Failed: " + Debug.getNestedExceptionMessage(throwable));
        }
        uDPConnection.poll();
        this.manager.remove(this, uDPConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed(Throwable throwable) {
        ArrayList arrayList = null;
        Map map = this.connections;
        synchronized (map) {
            if (!this.failed) {
                if (this.manager.trace()) {
                    this.trace("Connection set failed: " + Debug.getNestedExceptionMessage(throwable));
                }
                this.failed = true;
                arrayList = new ArrayList(this.connections.values());
            }
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((UDPConnection)arrayList.get(i)).failed(throwable);
                    continue;
                }
                catch (Throwable throwable2) {
                    Debug.printStackTrace(throwable2);
                }
            }
            this.manager.failed(this);
        }
    }

    protected boolean hasFailed() {
        return this.failed;
    }

    protected void removed() {
        this.logStats();
    }

    static void forDocumentation() {
        PRUDPPacketReply.registerDecoders(new HashMap());
    }

    protected int cipherInt(RC4Engine rC4Engine, int n) {
        byte[] byArray = this.intToBytes(n);
        rC4Engine.processBytes(byArray, 0, byArray.length, byArray, 0);
        return this.bytesToInt(byArray, 0);
    }

    protected int bytesToInt(byte[] byArray, int n) {
        int n2 = byArray[n++] << 24 & 0xFF000000 | byArray[n++] << 16 & 0xFF0000 | byArray[n++] << 8 & 0xFF00 | byArray[n++] & 0xFF;
        return n2;
    }

    protected byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    protected long bytesToLong(byte[] byArray) {
        return this.bytesToLong(byArray, 0);
    }

    protected long bytesToLong(byte[] byArray, int n) {
        long l = (long)(byArray[n++] << 24) & 0xFF000000L | (long)(byArray[n++] << 16) & 0xFF0000L | (long)(byArray[n++] << 8) & 0xFF00L | (long)byArray[n++] & 0xFFL;
        long l2 = (long)(byArray[n++] << 24) & 0xFF000000L | (long)(byArray[n++] << 16) & 0xFF0000L | (long)(byArray[n++] << 8) & 0xFF00L | (long)byArray[n++] & 0xFFL;
        long l3 = l << 32 | l2;
        return l3;
    }

    protected String getName() {
        return "loc=" + this.local_port + " - " + this.remote_address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logStats() {
        if (Logger.isEnabled()) {
            UDPConnectionSet uDPConnectionSet = this;
            synchronized (uDPConnectionSet) {
                String string = "sent: tot=" + this.total_packets_sent + ",uni=" + this.total_packets_unique_sent + ",ds=" + this.total_data_sent + ",dr=" + this.total_data_resent + ",ps=" + this.total_protocol_sent + ",pr=" + this.total_protocol_resent + ",rt=" + this.total_packets_resent_via_timer + ",ra=" + this.total_packets_resent_via_ack;
                string = string + " recv: tot=" + this.total_packets_received + ",uni=" + this.total_packets_unique_received + ",du=" + this.total_packets_duplicates + ",oo=" + this.total_packets_out_of_order;
                string = string + " timer=" + this.current_timer_base + ",adj=" + this.timer_is_adjusting;
                Logger.log(new LogEvent(LOGID, "UDP " + this.getName() + " - " + string));
            }
        }
    }

    protected void trace(String string) {
        if (this.manager.trace()) {
            this.manager.trace("UDP " + this.getName() + ": " + string);
        }
    }

    protected void trace(UDPConnection uDPConnection, String string) {
        if (this.manager.trace()) {
            this.manager.trace("UDP " + this.getName() + " (" + uDPConnection.getID() + "): " + string);
        }
    }

    protected class SequenceGenerator {
        private Random generator;
        private RC4Engine cipher;
        private boolean in;
        private final int[] seq_memory;
        private final int[] alt_seq_memory;
        private int seq_memory_pos;
        private int debug_seq_in_next;
        private int debug_seq_out_next;

        protected SequenceGenerator(Random random, RC4Engine rC4Engine, boolean bl) {
            this.debug_seq_in_next = UDPConnectionSet.this.outgoing ? 0 : 1000000;
            this.debug_seq_out_next = UDPConnectionSet.this.outgoing ? 1000000 : 0;
            this.generator = random;
            this.cipher = rC4Engine;
            this.in = bl;
            this.seq_memory = new int[MAX_SEQ_MEMORY];
            this.alt_seq_memory = new int[MAX_SEQ_MEMORY];
            Arrays.fill(this.seq_memory, -1);
            Arrays.fill(this.alt_seq_memory, -1);
        }

        protected synchronized int[] getNextSequenceNumber() {
            int n;
            int n2;
            int n3;
            int n4;
            while (true) {
                n4 = this.generator.nextInt();
                n3 = this.generator.nextInt();
                n2 = this.generator.nextInt();
                n = this.generator.nextInt();
                n4 = UDPConnectionSet.this.cipherInt(this.cipher, n4);
                n3 = UDPConnectionSet.this.cipherInt(this.cipher, n3);
                n2 = UDPConnectionSet.this.cipherInt(this.cipher, n2);
                n = UDPConnectionSet.this.cipherInt(this.cipher, n);
                if ((n4 & 0xFFFFF800) == 0 || n3 == -1 || (n2 & 0xFFFFF800) == 0 || (n & 0xFFFF0000) == 0 || (n & 0xFFFF) == 0) continue;
                boolean bl = false;
                for (int i = 0; i < MAX_SEQ_MEMORY; ++i) {
                    if (this.seq_memory[i] != n3 && this.alt_seq_memory[i] != n) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            this.seq_memory[this.seq_memory_pos] = n3;
            this.alt_seq_memory[this.seq_memory_pos++] = n;
            if (this.seq_memory_pos == MAX_SEQ_MEMORY) {
                this.seq_memory_pos = 0;
            }
            return new int[]{n4, n3, n2, n};
        }

        protected boolean isValidAlterativeSequence(int n) {
            for (int i = 0; i < MAX_SEQ_MEMORY; ++i) {
                if (this.alt_seq_memory[i] != n) continue;
                return true;
            }
            return false;
        }
    }
}

