/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlue;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlueListener;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkGlueUDP
implements NetworkGlue,
PRUDPPrimordialHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private NetworkGlueListener listener;
    private PRUDPPacketHandler handler;
    private LinkedList msg_queue = new LinkedList();
    private AESemaphore msg_queue_sem = new AESemaphore("NetworkGlueUDP");
    private AESemaphore msg_queue_slot_sem = new AESemaphore("NetworkGlueUDP", 128);
    private long total_packets_received;
    private long total_bytes_received;
    private long total_packets_sent;
    private long total_bytes_sent;

    protected NetworkGlueUDP(NetworkGlueListener networkGlueListener) {
        this.listener = networkGlueListener;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"UDP.Listen.Port", "UDP.Listen.Port.Enable"}, new ParameterListener(){

            public void parameterChanged(String string) {
                boolean bl = COConfigurationManager.getBooleanParameter("UDP.Listen.Port.Enable");
                if (bl) {
                    int n = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                    if (NetworkGlueUDP.this.handler == null || n != NetworkGlueUDP.this.handler.getPort()) {
                        if (NetworkGlueUDP.this.handler != null) {
                            Logger.log(new LogEvent(LOGID, "Deactivating UDP listener on port " + NetworkGlueUDP.this.handler.getPort()));
                            NetworkGlueUDP.this.handler.removePrimordialHandler(NetworkGlueUDP.this);
                        }
                        Logger.log(new LogEvent(LOGID, "Activating UDP listener on port " + n));
                        NetworkGlueUDP.this.handler = PRUDPPacketHandlerFactory.getHandler(n);
                        NetworkGlueUDP.this.handler.addPrimordialHandler(NetworkGlueUDP.this);
                    }
                } else if (NetworkGlueUDP.this.handler != null) {
                    Logger.log(new LogEvent(LOGID, "Deactivating UDP listener on port " + NetworkGlueUDP.this.handler.getPort()));
                    NetworkGlueUDP.this.handler.removePrimordialHandler(NetworkGlueUDP.this);
                }
            }
        });
        new AEThread("NetworkGlueUDP", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void runSupport() {
                while (true) {
                    InetSocketAddress inetSocketAddress = null;
                    byte[] byArray = null;
                    NetworkGlueUDP.this.msg_queue_sem.reserve();
                    LinkedList linkedList = NetworkGlueUDP.this.msg_queue;
                    synchronized (linkedList) {
                        Object[] objectArray = (Object[])NetworkGlueUDP.this.msg_queue.removeFirst();
                        inetSocketAddress = (InetSocketAddress)objectArray[0];
                        byArray = (byte[])objectArray[1];
                    }
                    NetworkGlueUDP.this.msg_queue_slot_sem.release();
                    NetworkGlueUDP.this.total_packets_sent++;
                    NetworkGlueUDP.this.total_bytes_sent += byArray.length;
                    NetworkGlueUDP.this.handler.primordialSend(byArray, inetSocketAddress);
                    Object var7_6 = null;
                    try {
                        Thread.sleep(3L);
                    }
                    catch (Throwable throwable2) {}
                    continue;
                    {
                        catch (Throwable throwable) {
                            Logger.log(new LogEvent(LOGID, "Primordial UDP send failed: " + Debug.getNestedExceptionMessage(throwable)));
                            var7_6 = null;
                            try {
                                Thread.sleep(3L);
                            }
                            catch (Throwable throwable2) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        try {
                            Thread.sleep(3L);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }.start();
    }

    public boolean packetReceived(DatagramPacket datagramPacket) {
        byte[] byArray;
        if (!(datagramPacket.getLength() < 12 || ((byArray = datagramPacket.getData())[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 0 && (byArray[2] & 0xF8) == 0 || (byArray[8] & 0xFF) == 0 && (byArray[9] & 0xFF) == 0 && (byArray[10] & 0xF8) == 0)) {
            ++this.total_packets_received;
            this.total_bytes_received += (long)datagramPacket.getLength();
            this.listener.receive(this.handler.getPort(), new InetSocketAddress(datagramPacket.getAddress(), datagramPacket.getPort()), datagramPacket.getData(), datagramPacket.getLength());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(int n, InetSocketAddress inetSocketAddress, byte[] byArray) throws IOException {
        this.msg_queue_slot_sem.reserve();
        LinkedList linkedList = this.msg_queue;
        synchronized (linkedList) {
            this.msg_queue.add(new Object[]{inetSocketAddress, byArray});
        }
        this.msg_queue_sem.release();
        return byArray.length;
    }

    public long[] getStats() {
        return new long[]{this.total_packets_sent, this.total_bytes_sent, this.total_packets_received, this.total_bytes_received};
    }
}

