/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.plugin;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import java.util.Date;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class PluginResult
extends Result {
    private static final Object NULL_OBJECT = PluginResult.class;
    private SearchResult result;
    private String search_term;
    private Map property_cache = new LightHashMap();

    protected PluginResult(PluginEngine pluginEngine, SearchResult searchResult, String string) {
        super(pluginEngine);
        this.result = searchResult;
        this.search_term = string;
    }

    public Date getPublishedDate() {
        return (Date)this.getResultProperty(2);
    }

    public String getCategory() {
        return this.getStringProperty(7);
    }

    public void setCategory(String string) {
    }

    public String getContentType() {
        return this.getStringProperty(10);
    }

    public void setContentType(String string) {
    }

    public String getName() {
        return this.getStringProperty(1);
    }

    public long getSize() {
        return this.getLongProperty(3);
    }

    public int getNbPeers() {
        return this.getIntProperty(4);
    }

    public int getNbSeeds() {
        return this.getIntProperty(5);
    }

    public int getNbSuperSeeds() {
        return this.getIntProperty(6);
    }

    public int getComments() {
        return this.getIntProperty(8);
    }

    public int getVotes() {
        return this.getIntProperty(9);
    }

    public int getVotesDown() {
        return this.getIntProperty(19);
    }

    public boolean isPrivate() {
        return this.getBooleanProperty(14);
    }

    public String getDRMKey() {
        return this.getStringProperty(15);
    }

    public String getDownloadLink() {
        return this.getStringProperty(12);
    }

    public String getDownloadButtonLink() {
        return this.getStringProperty(16);
    }

    public String getCDPLink() {
        return this.getStringProperty(11);
    }

    public String getPlayLink() {
        return this.getStringProperty(13);
    }

    public String getUID() {
        return this.getStringProperty(20);
    }

    public String getHash() {
        byte[] byArray = this.getByteArrayProperty(21);
        if (byArray == null) {
            return null;
        }
        return Base32.encode(byArray);
    }

    public float getRank() {
        if (((PluginEngine)this.getEngine()).useAccuracyForRank()) {
            return this.applyRankBias(this.getAccuracy());
        }
        long l = this.getLongProperty(17);
        if (this.getLongProperty(5) >= 0L && this.getLongProperty(4) >= 0L) {
            l = Long.MIN_VALUE;
        }
        if (l == Long.MIN_VALUE) {
            return super.getRank();
        }
        float f = l;
        if (f > 100.0f) {
            f = 100.0f;
        } else if (f < 0.0f) {
            f = 0.0f;
        }
        return this.applyRankBias(f / 100.0f);
    }

    public float getAccuracy() {
        long l = this.getLongProperty(18);
        if (l == Long.MIN_VALUE) {
            return -1.0f;
        }
        float f = l;
        if (f > 100.0f) {
            f = 100.0f;
        } else if (f < 0.0f) {
            f = 0.0f;
        }
        return f / 100.0f;
    }

    public String getSearchQuery() {
        return this.search_term;
    }

    protected int getIntProperty(int n) {
        return (int)this.getLongProperty(n);
    }

    protected long getLongProperty(int n) {
        return this.getLongProperty(n, Long.MIN_VALUE);
    }

    protected long getLongProperty(int n, long l) {
        try {
            Long l2 = (Long)this.getResultProperty(n);
            if (l2 == null) {
                return l;
            }
            return l2;
        }
        catch (Throwable throwable) {
            Debug.out("Invalid value returned for Long property " + n);
            return l;
        }
    }

    protected boolean getBooleanProperty(int n) {
        return this.getBooleanProperty(n, false);
    }

    protected boolean getBooleanProperty(int n, boolean bl) {
        try {
            Boolean bl2 = (Boolean)this.getResultProperty(n);
            if (bl2 == null) {
                return bl;
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Debug.out("Invalid value returned for Boolean property " + n);
            return bl;
        }
    }

    protected String getStringProperty(int n) {
        return this.getStringProperty(n, "");
    }

    protected String getStringProperty(int n, String string) {
        try {
            String string2 = (String)this.getResultProperty(n);
            if (string2 == null) {
                return string;
            }
            return PluginResult.unescapeEntities(PluginResult.removeHTMLTags(string2));
        }
        catch (Throwable throwable) {
            Debug.out("Invalid value returned for String property " + n);
            return string;
        }
    }

    protected byte[] getByteArrayProperty(int n) {
        try {
            return (byte[])this.getResultProperty(n);
        }
        catch (Throwable throwable) {
            Debug.out("Invalid value returned for byte[] property " + n);
            return null;
        }
    }

    protected synchronized Object getResultProperty(int n) {
        Integer n2 = new Integer(n);
        Object object = this.property_cache.get(n2);
        if (object == null) {
            object = this.result.getProperty(n);
            if (object == null) {
                object = NULL_OBJECT;
            }
            this.property_cache.put(n2, object);
        }
        if (object == NULL_OBJECT) {
            return null;
        }
        return object;
    }
}

