/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class PlatformConfigMessenger {
    public static final String LISTENER_ID = "config";
    private static final String OP_LOG_PLUGIN = "log-plugin";
    private static boolean allowSendDeviceList = false;
    private static int iRPCVersion = 0;
    private static String playAfterURL = null;
    private static boolean sendStats = true;
    private static boolean doUrlQOS = false;
    private static boolean platformLoginComplete = false;
    protected static List platformLoginCompleteListeners = Collections.EMPTY_LIST;

    public static void login(long l, long l2) {
        Object[] objectArray;
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        String string = null;
        if (l != 1L) {
            objectArray = ContentNetworkManagerFactory.getSingleton().getContentNetwork(l);
            string = (String)objectArray.getPersistentProperty("source_ref");
        }
        if (string == null) {
            string = "unknown";
        }
        objectArray = new Object[]{"version", "4.5.0.4", "locale", MessageText.getCurrentLocale().toString(), "vid", COConfigurationManager.getStringParameter("ID"), "source-ref", string};
        PlatformMessage platformMessage = new PlatformMessage("AZMSG", LISTENER_ID, "login", objectArray, l2);
        platformMessage.setContentNetworkID(l);
        PlatformMessengerListener platformMessengerListener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage platformMessage, String string, Map map) {
                Object object;
                int n;
                Object[] objectArray;
                if (map == null) {
                    return;
                }
                boolean bl = MapUtils.getMapBoolean(map, "allow-multi-rpc", PlatformMessenger.getAllowMulti());
                PlatformMessenger.setAllowMulti(bl);
                try {
                    objectArray = (Object[])MapUtils.getMapObject(map, "url-whitelist", null, List.class);
                    if (objectArray != null) {
                        for (n = 0; n < objectArray.size(); ++n) {
                            object = (String)objectArray.get(n);
                            UrlFilter.getInstance().addUrlWhitelist((String)object);
                        }
                    }
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
                try {
                    objectArray = (List)MapUtils.getMapObject(map, "url-blacklist", null, List.class);
                    if (objectArray != null) {
                        for (n = 0; n < objectArray.size(); ++n) {
                            object = (String)objectArray.get(n);
                            UrlFilter.getInstance().addUrlBlacklist((String)object);
                        }
                    }
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
                try {
                    objectArray = (List)MapUtils.getMapObject(map, "tracker-domains", null, List.class);
                    if (objectArray != null) {
                        for (n = 0; n < objectArray.size(); ++n) {
                            object = (String)objectArray.get(n);
                            PlatformTorrentUtils.addPlatformHost((String)object);
                            PlatformMessenger.debug("v3.login: got tracker domain of " + (String)object);
                        }
                    }
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
                if (platformMessage.getContentNetworkID() != ConstantsVuze.getDefaultContentNetwork().getID()) {
                    return;
                }
                try {
                    sendStats = MapUtils.getMapBoolean(map, "send-stats", false);
                    doUrlQOS = MapUtils.getMapBoolean(map, "do-url-qos", false);
                    allowSendDeviceList = MapUtils.getMapBoolean(map, "send-device-list", false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    iRPCVersion = MapUtils.getMapInt(map, "rpc-version", 0);
                    playAfterURL = MapUtils.getMapString(map, "play-after-url", null);
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
                platformLoginComplete = true;
                objectArray = platformLoginCompleteListeners.toArray();
                platformLoginCompleteListeners = Collections.EMPTY_LIST;
                for (n = 0; n < objectArray.length; ++n) {
                    try {
                        object = (PlatformLoginCompleteListener)objectArray[n];
                        object.platformLoginComplete();
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.out(exception);
                    }
                }
            }

            public void messageSent(PlatformMessage platformMessage) {
            }
        };
        PlatformMessenger.pushMessageNow(platformMessage, platformMessengerListener);
    }

    public static void logPlugin(String string, String string2) {
        boolean bl = COConfigurationManager.getBooleanParameter("Send Version Info");
        if (!bl) {
            return;
        }
        try {
            PlatformMessage platformMessage = new PlatformMessage("AZMSG", LISTENER_ID, OP_LOG_PLUGIN, new Object[]{"event", string, "plugin-id", string2}, 5000L);
            PlatformMessenger.queueMessage(platformMessage, null);
        }
        catch (Exception exception) {
            Debug.out(exception);
        }
    }

    public static void sendUsageStats(Map map, long l, String string, PlatformMessengerListener platformMessengerListener) {
        if (!sendStats) {
            return;
        }
        try {
            PlatformMessage platformMessage = new PlatformMessage("AZMSG", LISTENER_ID, "send-usage-stats2", new Object[]{"stats", map, "version", string, "timestamp", new Long(l), "ago-ms", new Long(SystemTime.getCurrentTime() - l)}, 5000L);
            PlatformMessenger.queueMessage(platformMessage, platformMessengerListener);
        }
        catch (Exception exception) {
            Debug.out(exception);
        }
    }

    public static void sendVersionServerMap(Map map) {
        boolean bl = COConfigurationManager.getBooleanParameter("Send Version Info");
        if (!bl) {
            return;
        }
        try {
            PlatformMessage platformMessage = new PlatformMessage("AZMSG", LISTENER_ID, "send-version-info", map, 5000L);
            PlatformMessenger.queueMessage(platformMessage, null);
        }
        catch (Exception exception) {
            Debug.out(exception);
        }
    }

    public static int getRPCVersion() {
        return iRPCVersion;
    }

    public static String getPlayAfterURL() {
        return playAfterURL;
    }

    public static boolean allowSendStats() {
        return sendStats;
    }

    public static boolean doUrlQOS() {
        return doUrlQOS;
    }

    public static void addPlatformLoginCompleteListener(PlatformLoginCompleteListener platformLoginCompleteListener) {
        try {
            if (platformLoginCompleteListener == null) {
                return;
            }
            if (platformLoginComplete) {
                platformLoginCompleteListener.platformLoginComplete();
                return;
            }
            if (platformLoginCompleteListeners == Collections.EMPTY_LIST) {
                platformLoginCompleteListeners = new ArrayList(1);
            }
            platformLoginCompleteListeners.add(platformLoginCompleteListener);
        }
        catch (Exception exception) {
            Debug.out(exception);
        }
    }

    public static boolean allowSendDeviceList() {
        return allowSendDeviceList;
    }

    public static interface PlatformLoginCompleteListener {
        public void platformLoginComplete();
    }

    public static interface GetBrowseSectionsReplyListener {
        public void messageSent();

        public void replyReceived(Map[] var1);
    }
}

