/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCache
implements CacheFile {
    protected CacheFileManagerImpl manager;
    protected FMFile file;
    protected TOTorrentFile torrent_file;

    protected CacheFileWithoutCache(CacheFileManagerImpl cacheFileManagerImpl, FMFile fMFile, TOTorrentFile tOTorrentFile) {
        this.manager = cacheFileManagerImpl;
        this.file = fMFile;
        this.torrent_file = tOTorrentFile;
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void moveFile(File file) throws CacheFileManagerException {
        try {
            this.file.moveFile(file);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void renameFile(String string) throws CacheFileManagerException {
        try {
            this.file.renameFile(string);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void setAccessMode(int n) throws CacheFileManagerException {
        try {
            this.file.setAccessMode(n == 1 ? 1 : 2);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public int getAccessMode() {
        return this.file.getAccessMode() == 1 ? 1 : 2;
    }

    public void setStorageType(int n) throws CacheFileManagerException {
        try {
            this.file.setStorageType(CacheFileManagerImpl.convertCacheToFileType(n));
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.file.getStorageType());
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.file.exists() ? this.file.getLength() : 0L;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
            return 0L;
        }
    }

    public long compareLength(long l) throws CacheFileManagerException {
        return this.getLength() - l;
    }

    public void setLength(long l) throws CacheFileManagerException {
        try {
            this.file.setLength(l);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void setPieceComplete(int n, DirectByteBuffer directByteBuffer) throws CacheFileManagerException {
        try {
            this.file.setPieceComplete(n, directByteBuffer);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void read(DirectByteBuffer[] directByteBufferArray, long l, short s) throws CacheFileManagerException {
        int n = 0;
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            n += directByteBufferArray[i].remaining((byte)3);
        }
        try {
            this.file.read(directByteBufferArray, l);
            this.manager.fileBytesRead(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void read(DirectByteBuffer directByteBuffer, long l, short s) throws CacheFileManagerException {
        int n = directByteBuffer.remaining((byte)3);
        try {
            this.file.read(directByteBuffer, l);
            this.manager.fileBytesRead(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void write(DirectByteBuffer directByteBuffer, long l) throws CacheFileManagerException {
        int n = directByteBuffer.remaining((byte)3);
        try {
            this.file.write(directByteBuffer, l);
            this.manager.fileBytesWritten(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void write(DirectByteBuffer[] directByteBufferArray, long l) throws CacheFileManagerException {
        int n = 0;
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            n += directByteBufferArray[i].remaining((byte)3);
        }
        try {
            this.file.write(directByteBufferArray, l);
            this.manager.fileBytesWritten(n);
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffer(DirectByteBuffer directByteBuffer, long l) throws CacheFileManagerException {
        int n = directByteBuffer.remaining((byte)3);
        boolean bl = false;
        try {
            try {
                this.file.write(directByteBuffer, l);
                this.manager.fileBytesWritten(n);
                bl = true;
            }
            catch (FMFileManagerException fMFileManagerException) {
                this.manager.rethrow(this, fMFileManagerException);
                Object var8_6 = null;
                if (bl) {
                    directByteBuffer.returnToPool();
                }
            }
            Object var8_5 = null;
            if (bl) {
                directByteBuffer.returnToPool();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (bl) {
                directByteBuffer.returnToPool();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeAndHandoverBuffers(DirectByteBuffer[] directByteBufferArray, long l) throws CacheFileManagerException {
        int n;
        int n2 = 0;
        for (n = 0; n < directByteBufferArray.length; n2 += directByteBufferArray[n].remaining((byte)3), ++n) {
        }
        n = 0;
        try {
            try {
                this.file.write(directByteBufferArray, l);
                this.manager.fileBytesWritten(n2);
                n = 1;
            }
            catch (FMFileManagerException fMFileManagerException) {
                this.manager.rethrow(this, fMFileManagerException);
                Object var8_6 = null;
                if (n == 0) return;
                for (int i = 0; i < directByteBufferArray.length; ++i) {
                    directByteBufferArray[i].returnToPool();
                }
                return;
            }
            Object var8_5 = null;
            if (n == 0) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (n == 0) throw throwable;
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                directByteBufferArray[i].returnToPool();
            }
            throw throwable;
        }
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            directByteBufferArray[i].returnToPool();
        }
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.file.flush();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public void clearCache() throws CacheFileManagerException {
    }

    public void close() throws CacheFileManagerException {
        try {
            this.file.close();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }

    public boolean isOpen() {
        return this.file.isOpen();
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.manager.rethrow(this, fMFileManagerException);
        }
    }
}

