/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.speed.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTSpeedTesterImpl
implements DHTSpeedTester {
    private static final long PING_TIMEOUT = 5000L;
    private PluginInterface plugin_interface;
    private DHT dht;
    private int contact_num;
    private BloomFilter tried_bloom;
    private LinkedList pending_contacts = new LinkedList();
    private List active_pings = new ArrayList();
    private List new_listeners = new ArrayList();
    private CopyOnWriteList listeners = new CopyOnWriteList();

    public DHTSpeedTesterImpl(DHT dHT) {
        this.dht = dHT;
        this.plugin_interface = this.dht.getLogger().getPluginInterface();
        UTTimer uTTimer = this.plugin_interface.getUtilities().createTimer("DHTSpeedTester:finder", true);
        uTTimer.addPeriodicEvent(5000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent uTTimerEvent) {
                DHTSpeedTesterImpl.this.findContacts();
            }
        });
        uTTimer.addPeriodicEvent(1000L, new UTTimerEventPerformer(){
            int tick_count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent uTTimerEvent) {
                try {
                    DHTSpeedTesterImpl.this.pingContacts(this.tick_count);
                    Object var3_2 = null;
                    ++this.tick_count;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    ++this.tick_count;
                    throw throwable;
                }
            }
        });
    }

    public int getContactNumber() {
        return this.contact_num;
    }

    public void setContactNumber(int n) {
        this.contact_num = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findContacts() {
        DHTTransportContact[] dHTTransportContactArray = this.dht.getTransport().getReachableContacts();
        for (int i = 0; i < dHTTransportContactArray.length; ++i) {
            DHTTransportContact dHTTransportContact = dHTTransportContactArray[i];
            byte[] byArray = dHTTransportContact.getAddress().getAddress().getAddress();
            if (this.tried_bloom == null || this.tried_bloom.getEntryCount() > 500) {
                this.tried_bloom = BloomFilterFactory.createAddOnly(4096);
            }
            if (this.tried_bloom.contains(byArray)) continue;
            this.tried_bloom.add(byArray);
            LinkedList linkedList = this.pending_contacts;
            synchronized (linkedList) {
                potentialPing potentialPing2 = new potentialPing(dHTTransportContact, DHTNetworkPositionManager.estimateRTT(dHTTransportContact.getNetworkPositions(), this.dht.getTransport().getLocalContact().getNetworkPositions()));
                this.pending_contacts.add(0, potentialPing2);
                if (this.pending_contacts.size() > 60) {
                    this.pending_contacts.removeLast();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingContacts(int n) {
        Object object;
        Object object2;
        ArrayList arrayList = null;
        List list = this.new_listeners;
        synchronized (list) {
            if (this.new_listeners.size() > 0) {
                arrayList = new ArrayList(this.new_listeners);
                this.new_listeners.clear();
            }
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (DHTSpeedTesterListener)arrayList.get(i);
                this.listeners.add(object2);
                for (int j = 0; j < this.active_pings.size(); ++j) {
                    object = (activePing)this.active_pings.get(j);
                    if (!((activePing)object).isInformedAlive()) continue;
                    try {
                        object2.contactAdded((DHTSpeedTesterContact)object);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }
        Iterator iterator = this.active_pings.iterator();
        object2 = new pingInstanceSet(true);
        while (iterator.hasNext()) {
            activePing activePing2 = (activePing)iterator.next();
            if (activePing2.update((pingInstanceSet)object2, n) && !activePing2.isInformedAlive()) {
                activePing2.setInformedAlive();
                object = this.listeners.iterator();
                while (object.hasNext()) {
                    try {
                        ((DHTSpeedTesterListener)object.next()).contactAdded(activePing2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            if (!activePing2.isDead()) continue;
            iterator.remove();
            activePing2.informDead();
        }
        ((pingInstanceSet)object2).setFull();
        int n2 = this.active_pings.size();
        if (n2 < this.contact_num) {
            object = new TreeSet(new Comparator(){

                public int compare(Object object, Object object2) {
                    potentialPing potentialPing2 = (potentialPing)object;
                    potentialPing potentialPing3 = (potentialPing)object2;
                    return potentialPing2.getRTT() - potentialPing3.getRTT();
                }
            });
            Object object3 = this.pending_contacts;
            synchronized (object3) {
                object.addAll(this.pending_contacts);
            }
            object3 = object.iterator();
            if (object.size() >= 3) {
                ArrayList<potentialPing> arrayList2 = new ArrayList<potentialPing>();
                for (int i = 0; i < 3; ++i) {
                    potentialPing potentialPing2 = (potentialPing)object3.next();
                    arrayList2.add(potentialPing2);
                    object3.remove();
                    LinkedList linkedList = this.pending_contacts;
                    synchronized (linkedList) {
                        this.pending_contacts.remove(potentialPing2);
                        continue;
                    }
                }
                this.active_pings.add(new activePing(arrayList2));
            }
        } else if (n2 > this.contact_num) {
            for (int i = 0; i < n2 - this.contact_num; ++i) {
                ((activePing)this.active_pings.get(i)).destroy();
            }
        }
    }

    protected void informResults(DHTSpeedTesterContact[] dHTSpeedTesterContactArray, int[] nArray) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((DHTSpeedTesterListener)iterator.next()).resultGroup(dHTSpeedTesterContactArray, nArray);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DHTSpeedTesterListener dHTSpeedTesterListener) {
        List list = this.new_listeners;
        synchronized (list) {
            this.new_listeners.add(dHTSpeedTesterListener);
        }
    }

    public void removeListener(DHTSpeedTesterListener dHTSpeedTesterListener) {
        this.listeners.remove(dHTSpeedTesterListener);
    }

    protected class pingInstanceSet {
        private boolean active;
        private int instances;
        private boolean full;
        List results = new ArrayList();

        protected pingInstanceSet(boolean bl) {
            this.active = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(pingInstance pingInstance2) {
            pingInstanceSet pingInstanceSet2 = this;
            synchronized (pingInstanceSet2) {
                ++this.instances;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setFull() {
            pingInstanceSet pingInstanceSet2 = this;
            synchronized (pingInstanceSet2) {
                this.full = true;
                if (this.results.size() == this.instances) {
                    this.sendResult();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete(pingInstance pingInstance2) {
            pingInstanceSet pingInstanceSet2 = this;
            synchronized (pingInstanceSet2) {
                this.results.add(pingInstance2);
                if (this.results.size() == this.instances && this.full) {
                    this.sendResult();
                }
            }
        }

        protected void sendResult() {
            if (this.active && this.results.size() > 0) {
                DHTSpeedTesterContact[] dHTSpeedTesterContactArray = new DHTSpeedTesterContact[this.results.size()];
                int[] nArray = new int[dHTSpeedTesterContactArray.length];
                for (int i = 0; i < dHTSpeedTesterContactArray.length; ++i) {
                    pingInstance pingInstance2 = (pingInstance)this.results.get(i);
                    dHTSpeedTesterContactArray[i] = pingInstance2.getContact();
                    nArray[i] = pingInstance2.getResult();
                }
                DHTSpeedTesterImpl.this.informResults(dHTSpeedTesterContactArray, nArray);
            }
        }
    }

    protected class pingInstance {
        private activePing contact;
        private pingInstanceSet set;
        private int result;

        protected pingInstance(pingInstanceSet pingInstanceSet2) {
            this.set = pingInstanceSet2;
            this.set.add(this);
        }

        protected activePing getContact() {
            return this.contact;
        }

        protected int getResult() {
            return this.result;
        }

        protected void setResult(activePing activePing2, int n) {
            this.contact = activePing2;
            this.result = n;
            this.set.complete(this);
        }
    }

    protected class activePing
    implements DHTSpeedTesterContact {
        private boolean running;
        private boolean dead;
        private boolean informed_alive;
        private int outstanding;
        private int best_ping = Integer.MAX_VALUE;
        private DHTTransportContact best_pingee;
        private int consec_fails;
        private int total_ok;
        private int total_fails;
        private int period = 5;
        private CopyOnWriteList listeners = new CopyOnWriteList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected activePing(List list) {
            String string = "";
            pingInstanceSet pingInstanceSet2 = new pingInstanceSet(false);
            activePing activePing2 = this;
            synchronized (activePing2) {
                for (int i = 0; i < list.size(); ++i) {
                    potentialPing potentialPing2 = (potentialPing)list.get(i);
                    string = string + (i == 0 ? "" : ",") + potentialPing2.getContact().getString() + "/" + potentialPing2.getRTT();
                    this.ping(pingInstanceSet2, potentialPing2.getContact());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean update(pingInstanceSet pingInstanceSet2, int n) {
            activePing activePing2 = this;
            synchronized (activePing2) {
                if (this.dead || !this.running || this.outstanding > 0) {
                    return false;
                }
                if (this.best_pingee == null) {
                    this.dead = true;
                    return false;
                }
            }
            if (n % this.period == 0) {
                this.ping(pingInstanceSet2, this.best_pingee);
            }
            return true;
        }

        protected void ping(pingInstanceSet pingInstanceSet2, DHTTransportContact dHTTransportContact) {
            final pingInstance pingInstance2 = new pingInstance(pingInstanceSet2);
            ++this.outstanding;
            try {
                dHTTransportContact.sendImmediatePing(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pingReply(DHTTransportContact dHTTransportContact) {
                        int n = this.getElapsed();
                        try {
                            Object object = activePing.this;
                            synchronized (object) {
                                activePing.this.outstanding--;
                                if (!activePing.this.running) {
                                    if (n < activePing.this.best_ping) {
                                        activePing.this.best_pingee = dHTTransportContact;
                                        activePing.this.best_ping = n;
                                    }
                                    if (activePing.this.outstanding == 0) {
                                        activePing.this.running = true;
                                    }
                                } else {
                                    activePing.this.total_ok++;
                                    activePing.this.consec_fails = 0;
                                }
                            }
                            object = activePing.this.listeners.iterator();
                            while (object.hasNext()) {
                                try {
                                    ((DHTSpeedTesterContactListener)object.next()).ping(activePing.this, this.getElapsed());
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                }
                            }
                            Object var6_6 = null;
                            pingInstance2.setResult(activePing.this, n);
                        }
                        catch (Throwable throwable) {
                            Object var6_7 = null;
                            pingInstance2.setResult(activePing.this, n);
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                        try {
                            Object object = activePing.this;
                            synchronized (object) {
                                activePing.this.outstanding--;
                                if (!activePing.this.running) {
                                    if (activePing.this.outstanding == 0) {
                                        activePing.this.running = true;
                                    }
                                } else {
                                    activePing.this.consec_fails++;
                                    activePing.this.total_fails++;
                                    if (activePing.this.consec_fails == 3) {
                                        activePing.this.dead = true;
                                    } else if (activePing.this.total_ok > 10 && activePing.this.total_fails > 0 && activePing.this.total_ok / activePing.this.total_fails < 1) {
                                        activePing.this.dead = true;
                                    } else if (activePing.this.total_ok > 100) {
                                        activePing.this.total_ok = 0;
                                        activePing.this.total_fails = 0;
                                    }
                                }
                            }
                            if (!activePing.this.dead) {
                                object = activePing.this.listeners.iterator();
                                while (object.hasNext()) {
                                    try {
                                        ((DHTSpeedTesterContactListener)object.next()).pingFailed(activePing.this);
                                    }
                                    catch (Throwable throwable2) {
                                        Debug.printStackTrace(throwable2);
                                    }
                                }
                            }
                            Object var6_6 = null;
                            pingInstance2.setResult(activePing.this, -1);
                        }
                        catch (Throwable throwable3) {
                            Object var6_7 = null;
                            pingInstance2.setResult(activePing.this, -1);
                            throw throwable3;
                        }
                    }
                }, 5000L);
            }
            catch (Throwable throwable) {
                pingInstance2.setResult(this, -1);
                this.dead = true;
                --this.outstanding;
                Debug.printStackTrace(throwable);
            }
        }

        public void destroy() {
            this.dead = true;
        }

        protected boolean isDead() {
            return this.dead;
        }

        protected boolean isInformedAlive() {
            return this.informed_alive;
        }

        protected void setInformedAlive() {
            this.informed_alive = true;
        }

        protected void informDead() {
            if (this.informed_alive) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((DHTSpeedTesterContactListener)iterator.next()).contactDied(this);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }

        public DHTTransportContact getContact() {
            return this.best_pingee;
        }

        public InetSocketAddress getAddress() {
            return this.getContact().getAddress();
        }

        public String getString() {
            return this.getContact().getString();
        }

        public int getPingPeriod() {
            return this.period;
        }

        public void setPingPeriod(int n) {
            this.period = n;
        }

        public void addListener(DHTSpeedTesterContactListener dHTSpeedTesterContactListener) {
            this.listeners.add(dHTSpeedTesterContactListener);
        }

        public void removeListener(DHTSpeedTesterContactListener dHTSpeedTesterContactListener) {
            this.listeners.remove(dHTSpeedTesterContactListener);
        }
    }

    protected class potentialPing {
        private DHTTransportContact contact;
        private int rtt;

        protected potentialPing(DHTTransportContact dHTTransportContact, float f) {
            this.contact = dHTTransportContact;
            this.rtt = (int)(Float.isNaN(f) ? 1000.0 : (double)f);
        }

        protected DHTTransportContact getContact() {
            return this.contact;
        }

        protected int getRTT() {
            return this.rtt;
        }
    }
}

