/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl;

import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.Coordinates;

public class HeightCoordinatesImpl
implements Coordinates {
    protected float x;
    protected float y;
    protected float h;

    public HeightCoordinatesImpl(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.h = f3;
    }

    public HeightCoordinatesImpl(HeightCoordinatesImpl heightCoordinatesImpl) {
        this.x = heightCoordinatesImpl.x;
        this.y = heightCoordinatesImpl.y;
        this.h = heightCoordinatesImpl.h;
    }

    public Coordinates add(Coordinates coordinates) {
        HeightCoordinatesImpl heightCoordinatesImpl = (HeightCoordinatesImpl)coordinates;
        return new HeightCoordinatesImpl(this.x + heightCoordinatesImpl.x, this.y + heightCoordinatesImpl.y, Math.abs(this.h + heightCoordinatesImpl.h));
    }

    public Coordinates sub(Coordinates coordinates) {
        HeightCoordinatesImpl heightCoordinatesImpl = (HeightCoordinatesImpl)coordinates;
        return new HeightCoordinatesImpl(this.x - heightCoordinatesImpl.x, this.y - heightCoordinatesImpl.y, Math.abs(this.h + heightCoordinatesImpl.h));
    }

    public Coordinates scale(float f) {
        return new HeightCoordinatesImpl(f * this.x, f * this.y, f * this.h);
    }

    public float measure() {
        return (float)(Math.sqrt(this.x * this.x + this.y * this.y) + (double)this.h);
    }

    public boolean atOrigin() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    public boolean isValid() {
        return this.valid(this.x) && this.valid(this.y) && this.valid(this.h) && Math.abs(this.x) <= 30000.0f && Math.abs(this.y) <= 30000.0f && Math.abs(this.h) <= 30000.0f;
    }

    private boolean valid(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    public float distance(Coordinates coordinates) {
        return this.sub(coordinates).measure();
    }

    public Coordinates unity() {
        float f = this.measure();
        if (f == 0.0f) {
            float f2 = (float)Math.random();
            float f3 = (float)Math.random();
            float f4 = (float)Math.random();
            return new HeightCoordinatesImpl(f2, f3, f4).unity();
        }
        return this.scale(1.0f / f);
    }

    public double[] getCoordinates() {
        return new double[]{this.x, this.y};
    }

    public String toString() {
        return (int)this.x + "," + (int)this.y + "," + (int)this.h;
    }

    public float getH() {
        return this.h;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (object instanceof HeightCoordinatesImpl) {
            HeightCoordinatesImpl heightCoordinatesImpl = (HeightCoordinatesImpl)object;
            return heightCoordinatesImpl.x == this.x && heightCoordinatesImpl.y == this.y && heightCoordinatesImpl.h == this.h;
        }
        return false;
    }
}

