/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.nat.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTNATPuncherImpl
implements DHTNATPuncher {
    private static boolean TESTING = false;
    private static boolean TRACE = false;
    private static final int RT_BIND_REQUEST = 0;
    private static final int RT_BIND_REPLY = 1;
    private static final int RT_PUNCH_REQUEST = 2;
    private static final int RT_PUNCH_REPLY = 3;
    private static final int RT_CONNECT_REQUEST = 4;
    private static final int RT_CONNECT_REPLY = 5;
    private static final int RT_TUNNEL_INBOUND = 6;
    private static final int RT_TUNNEL_OUTBOUND = 7;
    private static final int RT_QUERY_REQUEST = 8;
    private static final int RT_QUERY_REPLY = 9;
    private static final int RT_CLOSE_REQUEST = 10;
    private static final int RT_CLOSE_REPLY = 11;
    private static final int RESP_OK = 0;
    private static final int RESP_NOT_OK = 1;
    private static final int RESP_FAILED = 2;
    private static byte[] transfer_handler_key;
    private boolean started;
    private DHTNATPuncherAdapter adapter;
    private DHT dht;
    private DHTLogger logger;
    private PluginInterface plugin_interface;
    private Formatters formatters;
    private UTTimer timer;
    private static final int REPUBLISH_TIME_MIN = 300000;
    private static final int TRANSFER_TIMEOUT = 30000;
    private static final int RENDEZVOUS_LOOKUP_TIMEOUT = 30000;
    private static final int TUNNEL_TIMEOUT = 3000;
    private static final int RENDEZVOUS_SERVER_MAX = 8;
    private static final int RENDEZVOUS_SERVER_TIMEOUT = 300000;
    private static final int RENDEZVOUS_CLIENT_PING_PERIOD = 50000;
    private static final int RENDEZVOUS_PING_FAIL_LIMIT = 4;
    private Monitor server_mon;
    private Map rendezvous_bindings = new HashMap();
    private long last_publish;
    private Monitor pub_mon;
    private boolean publish_in_progress;
    private volatile DHTTransportContact rendezvous_local_contact;
    private volatile DHTTransportContact rendezvous_target;
    private volatile DHTTransportContact last_ok_rendezvous;
    private static final int FAILED_RENDEZVOUS_HISTORY_MAX = 16;
    private Map failed_rendezvous = new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 16;
        }
    };
    private boolean rendezvous_thread_running;
    private Map explicit_rendezvous_map = new HashMap();
    private Monitor punch_mon;
    private List oustanding_punches = new ArrayList();
    private DHTTransportContact current_local = null;
    private DHTTransportContact current_target = null;
    private int rendevzous_fail_count = 0;

    public DHTNATPuncherImpl(DHTNATPuncherAdapter dHTNATPuncherAdapter, DHT dHT) {
        this.adapter = dHTNATPuncherAdapter;
        this.dht = dHT;
        this.logger = this.dht.getLogger();
        this.plugin_interface = this.dht.getLogger().getPluginInterface();
        this.formatters = this.plugin_interface.getUtilities().getFormatters();
        this.pub_mon = this.plugin_interface.getUtilities().getMonitor();
        this.server_mon = this.plugin_interface.getUtilities().getMonitor();
        this.punch_mon = this.plugin_interface.getUtilities().getMonitor();
        this.timer = this.plugin_interface.getUtilities().createTimer("DHTNATPuncher:refresher", true);
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        DHTTransport dHTTransport = this.dht.getTransport();
        dHTTransport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact dHTTransportContact) {
                DHTNATPuncherImpl.this.publish(false);
            }

            public void resetNetworkPositions() {
            }

            public void currentAddress(String string) {
            }

            public void reachabilityChanged(boolean bl) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        dHTTransport.registerTransferHandler(transfer_handler_key, new DHTTransportTransferHandler(){

            public String getName() {
                return "NAT Traversal";
            }

            public byte[] handleRead(DHTTransportContact dHTTransportContact, byte[] byArray) {
                return null;
            }

            public byte[] handleWrite(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
                return DHTNATPuncherImpl.this.receiveRequest((DHTTransportUDPContact)dHTTransportContact, byArray2);
            }
        });
        this.timer.addPeriodicEvent(300000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent uTTimerEvent) {
                DHTNATPuncherImpl.this.publish(false);
            }
        });
        this.timer.addPeriodicEvent(150000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent uTTimerEvent) {
                long l = DHTNATPuncherImpl.this.plugin_interface.getUtilities().getCurrentSystemTime();
                try {
                    DHTNATPuncherImpl.this.server_mon.enter();
                    Iterator iterator = DHTNATPuncherImpl.this.rendezvous_bindings.values().iterator();
                    while (iterator.hasNext()) {
                        Object[] objectArray = (Object[])iterator.next();
                        long l2 = (Long)objectArray[1];
                        boolean bl = false;
                        if (l2 > l) {
                            iterator.remove();
                            bl = true;
                        } else if (l - l2 > 300000L) {
                            iterator.remove();
                            bl = true;
                        }
                        if (!bl) continue;
                        DHTNATPuncherImpl.this.log("Rendezvous " + ((DHTTransportContact)objectArray[0]).getString() + " removed due to inactivity");
                    }
                    Object var10_7 = null;
                    DHTNATPuncherImpl.this.server_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    DHTNATPuncherImpl.this.server_mon.exit();
                    throw throwable;
                }
            }
        });
        this.publish(false);
    }

    public boolean active() {
        return this.rendezvous_local_contact != null;
    }

    public boolean operational() {
        DHTTransportContact dHTTransportContact = this.last_ok_rendezvous;
        return dHTTransportContact != null && dHTTransportContact == this.rendezvous_target;
    }

    protected void publish(boolean bl) {
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (l < this.last_publish && !bl) {
            this.last_publish = l;
        } else if (bl || l - this.last_publish >= 300000L) {
            this.last_publish = l;
            this.plugin_interface.getUtilities().createThread("DHTNATPuncher:publisher", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object v1;
                    block8: {
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            if (DHTNATPuncherImpl.this.publish_in_progress) {
                                Object var2_1 = null;
                                DHTNATPuncherImpl.this.pub_mon.exit();
                                return;
                            }
                            DHTNATPuncherImpl.this.publish_in_progress = true;
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            throw throwable;
                        }
                        Object var2_2 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                        try {
                            DHTNATPuncherImpl.this.publishSupport();
                            Object var4_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object v0;
                            Object var4_6 = null;
                            try {
                                DHTNATPuncherImpl.this.pub_mon.enter();
                                DHTNATPuncherImpl.this.publish_in_progress = false;
                                v0 = null;
                            }
                            catch (Throwable throwable2) {
                                v0 = null;
                            }
                            Object var6_10 = v0;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            throw throwable;
                        }
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            DHTNATPuncherImpl.this.publish_in_progress = false;
                            v1 = null;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            v1 = null;
                        }
                        {
                        }
                    }
                    Object var6_9 = v1;
                    DHTNATPuncherImpl.this.pub_mon.exit();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void publishSupport() {
        DHTTransport dHTTransport = this.dht.getTransport();
        if (TESTING || !dHTTransport.isReachable()) {
            int n;
            boolean bl;
            DHTTransportContact dHTTransportContact = dHTTransport.getLocalContact();
            boolean bl2 = bl = this.rendezvous_target != null && this.failed_rendezvous.containsKey(this.rendezvous_target.getAddress());
            if (this.rendezvous_local_contact != null && !bl && dHTTransportContact.getAddress().equals(this.rendezvous_local_contact.getAddress())) {
                return;
            }
            DHTTransportContact dHTTransportContact2 = (DHTTransportContact)this.explicit_rendezvous_map.get(dHTTransportContact.getAddress());
            if (dHTTransportContact2 != null) {
                try {
                    this.pub_mon.enter();
                    this.rendezvous_local_contact = dHTTransportContact;
                    this.rendezvous_target = dHTTransportContact2;
                    this.runRendezvous();
                    Object var6_5 = null;
                    this.pub_mon.exit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.pub_mon.exit();
                    throw throwable;
                }
            }
            final DHTTransportContact[] dHTTransportContactArray = new DHTTransportContact[]{null};
            DHTTransportContact[] dHTTransportContactArray2 = this.dht.getTransport().getReachableContacts();
            int n2 = 0;
            int n3 = 0;
            final Semaphore semaphore = this.plugin_interface.getUtilities().getSemaphore();
            for (n = 0; n < dHTTransportContactArray2.length; ++n) {
                Object var13_17;
                DHTTransportContact dHTTransportContact3;
                block20: {
                    dHTTransportContact3 = dHTTransportContactArray2[n];
                    try {
                        this.pub_mon.enter();
                        if (dHTTransportContactArray[0] != null) {
                            var13_17 = null;
                            this.pub_mon.exit();
                            break;
                        }
                        if (!this.failed_rendezvous.containsKey(dHTTransportContact3.getAddress())) break block20;
                        ++n3;
                        semaphore.release();
                    }
                    catch (Throwable throwable) {
                        var13_17 = null;
                        this.pub_mon.exit();
                        throw throwable;
                    }
                    var13_17 = null;
                    this.pub_mon.exit();
                    continue;
                }
                var13_17 = null;
                this.pub_mon.exit();
                if (n > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n2;
                dHTTransportContact3.sendPing(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pingReply(DHTTransportContact dHTTransportContact) {
                        DHTNATPuncherImpl.this.trace("Punch:" + dHTTransportContact.getString() + " OK");
                        try {
                            DHTNATPuncherImpl.this.pub_mon.enter();
                            if (dHTTransportContactArray[0] == null) {
                                dHTTransportContactArray[0] = dHTTransportContact;
                            }
                            Object var3_2 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            semaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            DHTNATPuncherImpl.this.pub_mon.exit();
                            semaphore.release();
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                        try {
                            DHTNATPuncherImpl.this.trace("Punch:" + dHTTransportContact.getString() + " Failed");
                            Object var4_3 = null;
                            semaphore.release();
                        }
                        catch (Throwable throwable2) {
                            Object var4_4 = null;
                            semaphore.release();
                            throw throwable2;
                        }
                    }
                });
            }
            for (n = 0; n < dHTTransportContactArray2.length; ++n) {
                Object var15_18;
                semaphore.reserve();
                try {
                    this.pub_mon.enter();
                    if (dHTTransportContactArray[0] != null) {
                        this.rendezvous_target = dHTTransportContactArray[0];
                        this.rendezvous_local_contact = dHTTransportContact;
                        this.log("Rendezvous found: " + this.rendezvous_local_contact.getString() + " -> " + this.rendezvous_target.getString());
                        this.runRendezvous();
                        var15_18 = null;
                        this.pub_mon.exit();
                        break;
                    }
                    var15_18 = null;
                    this.pub_mon.exit();
                    continue;
                }
                catch (Throwable throwable) {
                    var15_18 = null;
                    this.pub_mon.exit();
                    throw throwable;
                }
            }
            if (dHTTransportContactArray[0] != null) return;
            this.log("No rendezvous found: candidates=" + dHTTransportContactArray2.length + ",tried=" + n2 + ",skipped=" + n3);
            try {
                this.pub_mon.enter();
                this.rendezvous_local_contact = null;
                this.rendezvous_target = null;
                Object var17_20 = null;
                this.pub_mon.exit();
                return;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                this.pub_mon.exit();
                throw throwable;
            }
        }
        try {
            this.pub_mon.enter();
            this.rendezvous_local_contact = null;
            this.rendezvous_target = null;
            Object var19_23 = null;
            this.pub_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            this.pub_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRendezvous() {
        try {
            this.pub_mon.enter();
            if (!this.rendezvous_thread_running) {
                this.rendezvous_thread_running = true;
                this.plugin_interface.getUtilities().createThread("DHTNatPuncher:rendevzous", new Runnable(){

                    public void run() {
                        DHTNATPuncherImpl.this.runRendezvousSupport();
                    }
                });
            }
            Object var2_1 = null;
            this.pub_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pub_mon.exit();
            throw throwable;
        }
    }

    protected void runRendezvousSupport() {
        SimpleTimer.addPeriodicEvent("DHTNAT:cp", 50000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent timerEvent2) {
                try {
                    DHTTransportContact dHTTransportContact;
                    DHTTransportContact dHTTransportContact2;
                    try {
                        DHTNATPuncherImpl.this.pub_mon.enter();
                        dHTTransportContact2 = DHTNATPuncherImpl.this.rendezvous_local_contact;
                        dHTTransportContact = DHTNATPuncherImpl.this.rendezvous_target;
                        Object var5_5 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        DHTNATPuncherImpl.this.pub_mon.exit();
                        throw throwable;
                    }
                    if (DHTNATPuncherImpl.this.current_local != null || dHTTransportContact2 != null) {
                        if (DHTNATPuncherImpl.this.current_local != dHTTransportContact2) {
                            if (DHTNATPuncherImpl.this.current_local != null) {
                                DHTNATPuncherImpl.this.log("Removing publish for " + DHTNATPuncherImpl.this.current_local.getString() + " -> " + DHTNATPuncherImpl.this.current_target.getString());
                                DHTNATPuncherImpl.this.dht.remove(DHTNATPuncherImpl.this.getPublishKey(DHTNATPuncherImpl.this.current_local), "DHTNatPuncher: removal of publish", new DHTOperationListener(){

                                    public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                                    }

                                    public void found(DHTTransportContact dHTTransportContact, boolean bl) {
                                    }

                                    public void diversified(String string) {
                                    }

                                    public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                    }

                                    public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                    }

                                    public void complete(boolean bl) {
                                    }
                                });
                            }
                            if (dHTTransportContact2 != null) {
                                DHTNATPuncherImpl.this.log("Adding publish for " + dHTTransportContact2.getString() + " -> " + dHTTransportContact.getString());
                                DHTNATPuncherImpl.this.rendevzous_fail_count = 2;
                                DHTNATPuncherImpl.this.dht.put(DHTNATPuncherImpl.this.getPublishKey(dHTTransportContact2), "NAT Traversal: rendezvous publish", DHTNATPuncherImpl.this.encodePublishValue(dHTTransportContact), (byte)0, new DHTOperationListener(){

                                    public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                                    }

                                    public void found(DHTTransportContact dHTTransportContact, boolean bl) {
                                    }

                                    public void diversified(String string) {
                                    }

                                    public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                    }

                                    public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                    }

                                    public void complete(boolean bl) {
                                    }
                                });
                            }
                        } else if (DHTNATPuncherImpl.this.current_target != dHTTransportContact) {
                            DHTNATPuncherImpl.this.log("Updating publish for " + dHTTransportContact2.getString() + " -> " + dHTTransportContact.getString());
                            DHTNATPuncherImpl.this.rendevzous_fail_count = 2;
                            DHTNATPuncherImpl.this.dht.put(DHTNATPuncherImpl.this.getPublishKey(dHTTransportContact2), "DHTNatPuncher: update publish", DHTNATPuncherImpl.this.encodePublishValue(dHTTransportContact), (byte)0, new DHTOperationListener(){

                                public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                                }

                                public void found(DHTTransportContact dHTTransportContact, boolean bl) {
                                }

                                public void diversified(String string) {
                                }

                                public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                }

                                public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                                }

                                public void complete(boolean bl) {
                                }
                            });
                        }
                    }
                    DHTNATPuncherImpl.this.current_local = dHTTransportContact2;
                    DHTNATPuncherImpl.this.current_target = dHTTransportContact;
                    if (DHTNATPuncherImpl.this.current_target != null) {
                        int n = DHTNATPuncherImpl.this.sendBind(DHTNATPuncherImpl.this.current_target);
                        if (n == 0) {
                            DHTNATPuncherImpl.this.trace("Rendezvous:" + DHTNATPuncherImpl.this.current_target.getString() + " OK");
                            DHTNATPuncherImpl.this.rendevzous_fail_count = 0;
                            if (DHTNATPuncherImpl.this.last_ok_rendezvous != DHTNATPuncherImpl.this.current_target) {
                                DHTNATPuncherImpl.this.last_ok_rendezvous = DHTNATPuncherImpl.this.current_target;
                                DHTNATPuncherImpl.this.log("Rendezvous " + dHTTransportContact.getString() + " operational");
                            }
                        } else {
                            if (n == 1) {
                                DHTNATPuncherImpl.this.rendevzous_fail_count = 4;
                            } else {
                                DHTNATPuncherImpl.this.rendevzous_fail_count++;
                            }
                            if (DHTNATPuncherImpl.this.rendevzous_fail_count == 4) {
                                DHTNATPuncherImpl.this.rendezvousFailed(DHTNATPuncherImpl.this.current_target, false);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    DHTNATPuncherImpl.this.log(throwable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rendezvousFailed(DHTTransportContact dHTTransportContact, boolean bl) {
        this.log("Rendezvous " + (bl ? "closed" : "failed") + ": " + dHTTransportContact.getString());
        try {
            this.pub_mon.enter();
            this.failed_rendezvous.put(dHTTransportContact.getAddress(), "");
            Object var4_3 = null;
            this.pub_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pub_mon.exit();
            throw throwable;
        }
        this.publish(true);
    }

    protected byte[] sendRequest(DHTTransportContact dHTTransportContact, byte[] byArray, int n) {
        try {
            return this.dht.getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                public void reportSize(long l) {
                }

                public void reportActivity(String string) {
                }

                public void reportCompleteness(int n) {
                }
            }, dHTTransportContact, transfer_handler_key, byArray, n);
        }
        catch (DHTTransportException dHTTransportException) {
            return null;
        }
    }

    protected byte[] receiveRequest(DHTTransportUDPContact dHTTransportUDPContact, byte[] byArray) {
        try {
            Map map = this.receiveRequest(dHTTransportUDPContact, this.formatters.bDecode(byArray));
            if (map == null) {
                return null;
            }
            return this.formatters.bEncode(map);
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return null;
        }
    }

    protected Map sendRequest(DHTTransportContact dHTTransportContact, Map map, int n) {
        try {
            byte[] byArray = this.sendRequest(dHTTransportContact, this.formatters.bEncode(map), n);
            if (byArray == null) {
                return null;
            }
            return this.formatters.bDecode(byArray);
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return null;
        }
    }

    protected Map receiveRequest(DHTTransportUDPContact dHTTransportUDPContact, Map map) {
        int n = ((Long)map.get("type")).intValue();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        switch (n) {
            case 0: {
                hashMap.put("type", new Long(1L));
                this.receiveBind(dHTTransportUDPContact, map, hashMap);
                break;
            }
            case 10: {
                hashMap.put("type", new Long(11L));
                this.receiveClose(dHTTransportUDPContact, map, hashMap);
                break;
            }
            case 8: {
                hashMap.put("type", new Long(9L));
                this.receiveQuery(dHTTransportUDPContact, map, hashMap);
                break;
            }
            case 2: {
                hashMap.put("type", new Long(3L));
                this.receivePunch(dHTTransportUDPContact, map, hashMap);
                break;
            }
            case 4: {
                hashMap.put("type", new Long(5L));
                this.receiveConnect(dHTTransportUDPContact, map, hashMap);
                break;
            }
            case 6: {
                this.receiveTunnelInbound(dHTTransportUDPContact, map);
                hashMap = null;
                break;
            }
            case 7: {
                this.receiveTunnelOutbound(dHTTransportUDPContact, map);
                hashMap = null;
                break;
            }
            default: {
                hashMap = null;
            }
        }
        return hashMap;
    }

    protected boolean sendTunnelMessage(DHTTransportContact dHTTransportContact, Map map) {
        try {
            return this.sendTunnelMessage(dHTTransportContact, this.formatters.bEncode(map));
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return false;
        }
    }

    protected boolean sendTunnelMessage(DHTTransportContact dHTTransportContact, byte[] byArray) {
        try {
            this.dht.getTransport().writeTransfer(new DHTTransportProgressListener(){

                public void reportSize(long l) {
                }

                public void reportActivity(String string) {
                }

                public void reportCompleteness(int n) {
                }
            }, dHTTransportContact, transfer_handler_key, new byte[0], byArray, 3000L);
            return true;
        }
        catch (DHTTransportException dHTTransportException) {
            return false;
        }
    }

    protected int sendBind(DHTTransportContact dHTTransportContact) {
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(0L));
            Map map = this.sendRequest(dHTTransportContact, hashMap, 30000);
            if (map == null) {
                return 2;
            }
            if (((Long)map.get("type")).intValue() == 1) {
                int n = ((Long)map.get("ok")).intValue();
                this.trace("received bind reply: " + (n == 0 ? "failed" : "ok"));
                if (n == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveBind(DHTTransportUDPContact dHTTransportUDPContact, Map map, Map map2) {
        this.trace("received bind request");
        boolean bl = true;
        boolean bl2 = true;
        try {
            this.server_mon.enter();
            Object[] objectArray = (Object[])this.rendezvous_bindings.get(dHTTransportUDPContact.getAddress().toString());
            if (objectArray == null) {
                if (this.rendezvous_bindings.size() == 8) {
                    bl = false;
                }
            } else {
                bl2 = false;
            }
            if (bl) {
                long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
                this.rendezvous_bindings.put(dHTTransportUDPContact.getAddress().toString(), new Object[]{dHTTransportUDPContact, new Long(l)});
                map2.put("port", new Long(dHTTransportUDPContact.getAddress().getPort()));
            }
            Object var10_8 = null;
            this.server_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.server_mon.exit();
            throw throwable;
        }
        if (bl2) {
            this.log("Rendezvous request from " + dHTTransportUDPContact.getString() + " " + (bl ? "accepted" : "denied"));
        }
        map2.put("ok", new Long(bl ? 1L : 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            try {
                this.server_mon.enter();
                for (Object[] objectArray : this.rendezvous_bindings.values()) {
                    final DHTTransportUDPContact dHTTransportUDPContact = (DHTTransportUDPContact)objectArray[0];
                    new AEThread2("DHTNATPuncher:destroy", true){

                        public void run() {
                            DHTNATPuncherImpl.this.sendClose(dHTTransportUDPContact);
                        }
                    }.start();
                }
                Object var5_5 = null;
                this.server_mon.exit();
            }
            catch (Throwable throwable) {
                this.log(throwable);
                Object var5_6 = null;
                this.server_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.server_mon.exit();
            throw throwable;
        }
    }

    protected int sendClose(DHTTransportContact dHTTransportContact) {
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(10L));
            Map map = this.sendRequest(dHTTransportContact, hashMap, 30000);
            if (map == null) {
                return 2;
            }
            if (((Long)map.get("type")).intValue() == 11) {
                int n = ((Long)map.get("ok")).intValue();
                this.trace("received close reply: " + (n == 0 ? "failed" : "ok"));
                if (n == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return 2;
        }
    }

    protected void receiveClose(DHTTransportUDPContact dHTTransportUDPContact, Map map, Map map2) {
        this.trace("received close request");
        final DHTTransportContact dHTTransportContact = this.rendezvous_target;
        if (dHTTransportContact != null && Arrays.equals(dHTTransportContact.getID(), dHTTransportUDPContact.getID())) {
            new AEThread2("DHTNATPuncher:close", true){

                public void run() {
                    DHTNATPuncherImpl.this.rendezvousFailed(dHTTransportContact, true);
                }
            }.start();
        }
        map2.put("ok", new Long(1L));
    }

    private int sendQuery(DHTTransportContact dHTTransportContact) {
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(8L));
            Map map = this.sendRequest(dHTTransportContact, hashMap, 30000);
            if (map == null) {
                return 2;
            }
            if (((Long)map.get("type")).intValue() == 9) {
                int n = ((Long)map.get("ok")).intValue();
                this.trace("received query reply: " + (n == 0 ? "failed" : "ok"));
                if (n == 1) {
                    return 0;
                }
            }
            return 1;
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return 2;
        }
    }

    protected void receiveQuery(DHTTransportUDPContact dHTTransportUDPContact, Map map, Map map2) {
        this.trace("received query request");
        InetSocketAddress inetSocketAddress = dHTTransportUDPContact.getTransportAddress();
        map2.put("ip", inetSocketAddress.getAddress().getHostAddress().getBytes());
        map2.put("port", new Long(inetSocketAddress.getPort()));
        map2.put("ok", new Long(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map sendPunch(DHTTransportContact dHTTransportContact, final DHTTransportUDPContact dHTTransportUDPContact, Map map, boolean bl) {
        Map map2;
        Object[] objectArray;
        block27: {
            HashMap hashMap;
            block26: {
                Map n2;
                block25: {
                    AESemaphore aESemaphore = new AESemaphore("DHTNatPuncher::sendPunch");
                    objectArray = new Object[]{dHTTransportUDPContact, aESemaphore, new Integer(0)};
                    try {
                        try {
                            Map map22;
                            try {
                                this.punch_mon.enter();
                                this.oustanding_punches.add(objectArray);
                                map22 = null;
                                this.punch_mon.exit();
                            }
                            catch (Throwable hashMap2) {
                                Object var8_8 = null;
                                this.punch_mon.exit();
                                throw hashMap2;
                            }
                            HashMap<String, Object> throwable = new HashMap<String, Object>();
                            throwable.put("type", new Long(2L));
                            throwable.put("target", dHTTransportUDPContact.getAddress().toString().getBytes());
                            if (map != null) {
                                if (bl) {
                                    map.put("_notunnel", new Long(1L));
                                }
                                throwable.put("client_data", map);
                            }
                            if ((map22 = this.sendRequest(dHTTransportContact, throwable, bl ? 60000 : 30000)) == null) {
                                n2 = null;
                                Object var16_16 = null;
                                break block25;
                            }
                            if (((Long)map22.get("type")).intValue() == 3) {
                                int map4 = ((Long)map22.get("ok")).intValue();
                                this.trace("received " + (bl ? "message" : "punch") + " reply: " + (map4 == 0 ? "failed" : "ok"));
                                if (map4 == 1) {
                                    HashMap hashMap2;
                                    int uTTimerEvent;
                                    Long l = (Long)map22.get("port");
                                    if (l != null && (uTTimerEvent = l.intValue()) != 0 && uTTimerEvent != ((InetSocketAddress)((Object)(hashMap2 = dHTTransportUDPContact.getTransportAddress()))).getPort()) {
                                        dHTTransportUDPContact.setTransportAddress(new InetSocketAddress(((InetSocketAddress)((Object)hashMap2)).getAddress(), uTTimerEvent));
                                    }
                                    if (!bl) {
                                        UTTimerEvent uTTimerEvent2 = this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){
                                            private int pings = 1;

                                            public void perform(UTTimerEvent uTTimerEvent) {
                                                if (this.pings > 3) {
                                                    uTTimerEvent.cancel();
                                                    return;
                                                }
                                                ++this.pings;
                                                if (DHTNATPuncherImpl.this.sendTunnelOutbound(dHTTransportUDPContact)) {
                                                    uTTimerEvent.cancel();
                                                }
                                            }
                                        });
                                        if (this.sendTunnelOutbound(dHTTransportUDPContact)) {
                                            uTTimerEvent2.cancel();
                                        }
                                        if (aESemaphore.reserve(10000L)) {
                                            uTTimerEvent2.cancel();
                                        }
                                    }
                                    uTTimerEvent = 0;
                                    try {
                                        this.punch_mon.enter();
                                        uTTimerEvent = (Integer)objectArray[2];
                                        Object var14_40 = null;
                                        this.punch_mon.exit();
                                    }
                                    catch (Throwable hashMap3) {
                                        Object var14_41 = null;
                                        this.punch_mon.exit();
                                        throw hashMap3;
                                    }
                                    if (uTTimerEvent != 0 && uTTimerEvent != ((InetSocketAddress)((Object)(hashMap2 = dHTTransportUDPContact.getTransportAddress()))).getPort()) {
                                        dHTTransportUDPContact.setTransportAddress(new InetSocketAddress(((InetSocketAddress)((Object)hashMap2)).getAddress(), uTTimerEvent));
                                    }
                                    if ((hashMap2 = (Map)map22.get("client_data")) == null) {
                                        hashMap2 = new HashMap();
                                    }
                                    hashMap = hashMap2;
                                    break block26;
                                }
                            }
                            map2 = null;
                            break block27;
                        }
                        catch (Throwable throwable) {
                            this.log(throwable);
                            Map map3 = null;
                            Object var16_19 = null;
                            try {
                                this.punch_mon.enter();
                                this.oustanding_punches.remove(objectArray);
                                Object var18_27 = null;
                                this.punch_mon.exit();
                                return map3;
                            }
                            catch (Throwable throwable3) {
                                Object var18_28 = null;
                                this.punch_mon.exit();
                                throw throwable3;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_20 = null;
                        try {}
                        catch (Throwable throwable2) {
                            Object var18_30 = null;
                            this.punch_mon.exit();
                            throw throwable2;
                        }
                        this.punch_mon.enter();
                        this.oustanding_punches.remove(objectArray);
                        Object var18_29 = null;
                        this.punch_mon.exit();
                        throw throwable;
                    }
                }
                try {}
                catch (Throwable throwable) {
                    Object var18_22 = null;
                    this.punch_mon.exit();
                    throw throwable;
                }
                this.punch_mon.enter();
                this.oustanding_punches.remove(objectArray);
                Object var18_21 = null;
                this.punch_mon.exit();
                return n2;
            }
            Object var16_17 = null;
            try {}
            catch (Throwable throwable) {
                Object var18_24 = null;
                this.punch_mon.exit();
                throw throwable;
            }
            this.punch_mon.enter();
            this.oustanding_punches.remove(objectArray);
            Object var18_23 = null;
            this.punch_mon.exit();
            return hashMap;
        }
        Object var16_18 = null;
        try {}
        catch (Throwable throwable4) {
            Object var18_26 = null;
            this.punch_mon.exit();
            throw throwable4;
        }
        this.punch_mon.enter();
        this.oustanding_punches.remove(objectArray);
        Object var18_25 = null;
        this.punch_mon.exit();
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePunch(DHTTransportUDPContact dHTTransportUDPContact, Map map, Map map2) {
        DHTTransportUDPContact dHTTransportUDPContact2;
        Map map3;
        Object[] objectArray;
        this.trace("received punch request");
        boolean bl = false;
        String string = new String((byte[])map.get("target"));
        try {
            this.server_mon.enter();
            objectArray = (Object[])this.rendezvous_bindings.get(string);
            map3 = null;
            this.server_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.server_mon.exit();
            throw throwable;
        }
        if (objectArray != null && (map3 = this.sendConnect(dHTTransportUDPContact2 = (DHTTransportUDPContact)objectArray[0], dHTTransportUDPContact, (Map)map.get("client_data"))) != null) {
            map2.put("client_data", map3);
            map2.put("port", new Long(dHTTransportUDPContact2.getTransportAddress().getPort()));
            bl = true;
        }
        this.log("Rendezvous punch request from " + dHTTransportUDPContact.getString() + " to " + string + " " + (bl ? "initiated" : "failed"));
        map2.put("ok", new Long(bl ? 1L : 0L));
    }

    protected Map sendConnect(DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2, Map map) {
        try {
            Map map2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(4L));
            hashMap.put("origin", this.encodeContact(dHTTransportContact2));
            hashMap.put("port", new Long(((DHTTransportUDPContact)dHTTransportContact2).getTransportAddress().getPort()));
            if (map != null) {
                hashMap.put("client_data", map);
            }
            if ((map2 = this.sendRequest(dHTTransportContact, hashMap, 30000)) == null) {
                return null;
            }
            if (((Long)map2.get("type")).intValue() == 5) {
                int n = ((Long)map2.get("ok")).intValue();
                this.trace("received connect reply: " + (n == 0 ? "failed" : "ok"));
                if (n == 1) {
                    HashMap hashMap2 = (HashMap)map2.get("client_data");
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                    }
                    return hashMap2;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return null;
        }
    }

    protected void receiveConnect(DHTTransportContact dHTTransportContact, Map map, Map map2) {
        this.trace("received connect request");
        boolean bl = false;
        DHTTransportContact dHTTransportContact2 = this.rendezvous_target;
        if (dHTTransportContact2 != null && dHTTransportContact2.getAddress().equals(dHTTransportContact.getAddress())) {
            final DHTTransportUDPContact dHTTransportUDPContact = this.decodeContact((byte[])map.get("origin"));
            if (dHTTransportUDPContact != null) {
                HashMap hashMap;
                HashMap hashMap2;
                int n = 0;
                Long l = (Long)map.get("port");
                if (l != null) {
                    n = l.intValue();
                }
                if (n != 0 && n != ((InetSocketAddress)((Object)(hashMap2 = dHTTransportUDPContact.getTransportAddress()))).getPort()) {
                    dHTTransportUDPContact.setTransportAddress(new InetSocketAddress(((InetSocketAddress)((Object)hashMap2)).getAddress(), n));
                }
                hashMap2 = (Map)map.get("client_data");
                boolean bl2 = false;
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                } else {
                    boolean bl3 = bl2 = hashMap2.get("_notunnel") != null;
                }
                if (bl2) {
                    this.log("Received message from " + dHTTransportUDPContact.getString());
                } else {
                    this.log("Received connect request from " + dHTTransportUDPContact.getString());
                    hashMap = this.timer.addPeriodicEvent(3000L, new UTTimerEventPerformer(){
                        private int pings = 1;

                        public void perform(UTTimerEvent uTTimerEvent) {
                            if (this.pings > 3) {
                                uTTimerEvent.cancel();
                                return;
                            }
                            ++this.pings;
                            if (DHTNATPuncherImpl.this.sendTunnelInbound(dHTTransportUDPContact)) {
                                uTTimerEvent.cancel();
                            }
                        }
                    });
                    if (this.sendTunnelInbound(dHTTransportUDPContact)) {
                        hashMap.cancel();
                    }
                }
                hashMap = this.adapter.getClientData(dHTTransportUDPContact.getTransportAddress(), hashMap2);
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                map2.put("client_data", hashMap);
                bl = true;
            } else {
                this.log("Connect request: failed to decode target");
            }
        } else {
            this.log("Connect request from invalid rendezvous: " + dHTTransportContact.getString());
        }
        map2.put("ok", new Long(bl ? 1L : 0L));
    }

    protected boolean sendTunnelInbound(DHTTransportContact dHTTransportContact) {
        this.log("Sending tunnel inbound message to " + dHTTransportContact.getString());
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(6L));
            return this.sendTunnelMessage(dHTTransportContact, hashMap);
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveTunnelInbound(DHTTransportUDPContact dHTTransportUDPContact, Map map) {
        this.log("Received tunnel inbound message from " + dHTTransportUDPContact.getString());
        try {
            this.punch_mon.enter();
            for (int i = 0; i < this.oustanding_punches.size(); ++i) {
                Object[] objectArray = (Object[])this.oustanding_punches.get(i);
                DHTTransportContact dHTTransportContact = (DHTTransportContact)objectArray[0];
                if (!dHTTransportUDPContact.getAddress().getAddress().equals(dHTTransportContact.getAddress().getAddress())) continue;
                objectArray[2] = new Integer(dHTTransportUDPContact.getTransportAddress().getPort());
                ((AESemaphore)objectArray[1]).release();
            }
            Object var7_6 = null;
            this.punch_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.punch_mon.exit();
            throw throwable;
        }
    }

    protected boolean sendTunnelOutbound(DHTTransportContact dHTTransportContact) {
        this.log("Sending tunnel outbound message to " + dHTTransportContact.getString());
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(7L));
            return this.sendTunnelMessage(dHTTransportContact, hashMap);
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return false;
        }
    }

    protected void receiveTunnelOutbound(DHTTransportContact dHTTransportContact, Map map) {
        this.log("Received tunnel outbound message from " + dHTTransportContact.getString());
    }

    public Map punch(String string, InetSocketAddress[] inetSocketAddressArray, DHTTransportContact[] dHTTransportContactArray, Map map) {
        try {
            DHTTransportUDP dHTTransportUDP = (DHTTransportUDP)this.dht.getTransport();
            DHTTransportUDPContact dHTTransportUDPContact = dHTTransportUDP.importContact(inetSocketAddressArray[0], dHTTransportUDP.getProtocolVersion());
            Map map2 = this.punch(string, dHTTransportUDPContact, dHTTransportContactArray, map);
            inetSocketAddressArray[0] = dHTTransportUDPContact.getTransportAddress();
            return map2;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public Map punch(String string, DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray, Map map) {
        DHTTransportUDPContact dHTTransportUDPContact = (DHTTransportUDPContact)dHTTransportContact;
        try {
            DHTTransportContact dHTTransportContact2 = this.getRendezvous(string, dHTTransportUDPContact);
            if (dHTTransportContactArray != null && dHTTransportContactArray.length > 0) {
                dHTTransportContactArray[0] = dHTTransportContact2;
            }
            if (dHTTransportContact2 == null) {
                return null;
            }
            Map map2 = this.sendPunch(dHTTransportContact2, dHTTransportUDPContact, map, false);
            if (map2 != null) {
                this.log("    punch to " + dHTTransportUDPContact.getString() + " succeeded");
                return map2;
            }
        }
        catch (Throwable throwable) {
            this.log(throwable);
        }
        this.log("    punch to " + dHTTransportUDPContact.getString() + " failed");
        return null;
    }

    public Map sendMessage(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, Map map) {
        try {
            DHTTransportUDP dHTTransportUDP = (DHTTransportUDP)this.dht.getTransport();
            DHTTransportUDPContact dHTTransportUDPContact = dHTTransportUDP.importContact(inetSocketAddress, dHTTransportUDP.getProtocolVersion());
            DHTTransportUDPContact dHTTransportUDPContact2 = dHTTransportUDP.importContact(inetSocketAddress2, dHTTransportUDP.getProtocolVersion());
            Map map2 = this.sendPunch(dHTTransportUDPContact, dHTTransportUDPContact2, map, true);
            return map2;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public void setRendezvous(DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        this.explicit_rendezvous_map.put(dHTTransportContact.getAddress(), dHTTransportContact2);
        if (dHTTransportContact.getAddress().equals(this.dht.getTransport().getLocalContact().getAddress())) {
            this.publish(true);
        }
    }

    protected DHTTransportContact getRendezvous(String string, DHTTransportContact dHTTransportContact) {
        DHTTransportContact dHTTransportContact2 = (DHTTransportContact)this.explicit_rendezvous_map.get(dHTTransportContact.getAddress());
        if (dHTTransportContact2 != null) {
            return dHTTransportContact2;
        }
        byte[] byArray = this.getPublishKey(dHTTransportContact);
        final DHTTransportValue[] dHTTransportValueArray = new DHTTransportValue[]{null};
        final Semaphore semaphore = this.plugin_interface.getUtilities().getSemaphore();
        this.dht.get(byArray, string + ": lookup for '" + dHTTransportContact.getString() + "'", (byte)0, 1, 30000L, false, true, new DHTOperationAdapter(){

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                dHTTransportValueArray[0] = dHTTransportValue;
                semaphore.release();
            }

            public void complete(boolean bl) {
                semaphore.release();
            }
        });
        semaphore.reserve();
        DHTTransportContact dHTTransportContact3 = null;
        if (dHTTransportValueArray[0] != null) {
            byte[] byArray2 = dHTTransportValueArray[0].getValue();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                byte by = dataInputStream.readByte();
                if (by != 0) {
                    throw new Exception("Unsupported rendezvous version '" + by + "'");
                }
                dHTTransportContact3 = this.dht.getTransport().importContact(dataInputStream);
            }
            catch (Throwable throwable) {
                this.log(throwable);
            }
        }
        this.log("Lookup of rendezvous for " + dHTTransportContact.getString() + " -> " + (dHTTransportContact3 == null ? "None" : dHTTransportContact3.getString()));
        return dHTTransportContact3;
    }

    protected byte[] getPublishKey(DHTTransportContact dHTTransportContact) {
        byte[] byArray = dHTTransportContact.getID();
        byte[] byArray2 = ":DHTNATPuncher".getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    protected byte[] encodePublishValue(DHTTransportContact dHTTransportContact) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(0);
            dHTTransportContact.exportContact(dataOutputStream);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return new byte[0];
        }
    }

    protected byte[] encodeContact(DHTTransportContact dHTTransportContact) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dHTTransportContact.exportContact(dataOutputStream);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return null;
        }
    }

    protected DHTTransportUDPContact decodeContact(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return (DHTTransportUDPContact)this.dht.getTransport().importContact(dataInputStream);
        }
        catch (Throwable throwable) {
            this.log(throwable);
            return null;
        }
    }

    protected void log(String string) {
        if (TRACE) {
            System.out.println(string);
        }
        this.logger.log("NATPuncher: " + string);
    }

    protected void log(Throwable throwable) {
        if (TRACE) {
            throwable.printStackTrace();
        }
        this.logger.log("NATPuncher: error occurred");
        this.logger.log(throwable);
    }

    protected void trace(String string) {
        if (TRACE) {
            System.out.println(string);
        }
    }

    static {
        if (TESTING) {
            System.out.println("**** DHTNATPuncher test on ****");
        }
        if (TRACE) {
            System.out.println("**** DHTNATPuncher trace on ****");
        }
        transfer_handler_key = new SHA1Simple().calculateHash("Aelitis:NATPuncher:TransferHandlerKey".getBytes());
    }
}

