/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTDBValueImpl
implements DHTDBValue {
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    private long creation_time;
    private byte[] value;
    private DHTTransportContact originator;
    private DHTTransportContact sender;
    private boolean local;
    private byte flags;
    private byte life_hours;
    private byte rep_control;
    private int version;
    private long store_time;

    protected DHTDBValueImpl(long l, byte[] byArray, int n, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2, boolean bl, int n2, int n3, byte by) {
        this.creation_time = l;
        this.value = byArray;
        this.version = n;
        this.originator = dHTTransportContact;
        this.sender = dHTTransportContact2;
        this.local = bl;
        this.flags = (byte)n2;
        this.life_hours = (byte)n3;
        this.rep_control = by;
        if (this.value != null && this.value.length == 0) {
            this.value = ZERO_LENGTH_BYTE_ARRAY;
        }
        this.reset();
    }

    protected DHTDBValueImpl(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue, boolean bl) {
        this(dHTTransportValue.getCreationTime(), dHTTransportValue.getValue(), dHTTransportValue.getVersion(), dHTTransportValue.getOriginator(), dHTTransportContact, bl, dHTTransportValue.getFlags(), dHTTransportValue.getLifeTimeHours(), dHTTransportValue.getReplicationControl());
    }

    protected void reset() {
        this.store_time = SystemTime.getCurrentTime();
        if (this.creation_time > this.store_time) {
            this.creation_time = this.store_time;
        }
    }

    public long getCreationTime() {
        return this.creation_time;
    }

    protected void setCreationTime() {
        this.creation_time = SystemTime.getCurrentTime();
    }

    protected void setStoreTime(long l) {
        this.store_time = l;
    }

    protected long getStoreTime() {
        return this.store_time;
    }

    public boolean isLocal() {
        return this.local;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public DHTTransportContact getOriginator() {
        return this.originator;
    }

    public DHTTransportContact getSender() {
        return this.sender;
    }

    public int getFlags() {
        return this.flags & 0xFF;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public int getLifeTimeHours() {
        return this.life_hours & 0xFF;
    }

    public byte getReplicationControl() {
        return this.rep_control;
    }

    public byte getReplicationFactor() {
        return this.rep_control == -1 ? (byte)-1 : (byte)(this.rep_control & 0xF);
    }

    public byte getReplicationFrequencyHours() {
        return this.rep_control == -1 ? (byte)-1 : (byte)((this.rep_control & 0xF0) >> 4);
    }

    protected void setOriginatorAndSender(DHTTransportContact dHTTransportContact) {
        this.originator = dHTTransportContact;
        this.sender = dHTTransportContact;
    }

    public DHTDBValue getValueForRelay(DHTTransportContact dHTTransportContact) {
        return new DHTDBValueImpl(dHTTransportContact, this, this.local);
    }

    public DHTDBValue getValueForDeletion(int n) {
        DHTDBValueImpl dHTDBValueImpl = new DHTDBValueImpl(this.originator, this, this.local);
        dHTDBValueImpl.value = ZERO_LENGTH_BYTE_ARRAY;
        dHTDBValueImpl.setCreationTime();
        dHTDBValueImpl.version = n;
        return dHTDBValueImpl;
    }

    public String getString() {
        long l = SystemTime.getCurrentTime();
        return DHTLog.getString(this.value) + " - " + new String(this.value) + "{v=" + this.version + ",f=" + Integer.toHexString(this.flags) + ",l=" + this.life_hours + ",r=" + Integer.toHexString(this.rep_control) + ",ca=" + (l - this.creation_time) + ",sa=" + (l - this.store_time) + ",se=" + this.sender.getString() + ",or=" + this.originator.getString() + "}";
    }
}

