/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public abstract class TranscodePipe {
    private final int BUFFER_SIZE = 131072;
    private final int BUFFER_CACHE_SIZE = 393216;
    protected volatile boolean paused;
    protected volatile boolean destroyed;
    protected volatile int bytes_available;
    protected volatile int max_bytes_per_sec;
    protected List<Socket> sockets = new ArrayList<Socket>();
    private ServerSocket server_socket;
    private AEThread2 refiller;
    private LinkedList<bufferCache> buffer_cache = new LinkedList();
    private int buffer_cache_size;
    private Average connection_speed = Average.getInstance(1000, 10);
    private Average write_speed = Average.getInstance(1000, 10);
    private errorListener error_listener;

    protected TranscodePipe(errorListener errorListener2) throws IOException {
        this.error_listener = errorListener2;
        this.server_socket = new ServerSocket(0, 50, InetAddress.getByName("127.0.0.1"));
        new AEThread2("TranscodePipe", true){

            public void run() {
                while (!TranscodePipe.this.destroyed) {
                    try {
                        final Socket socket = TranscodePipe.this.server_socket.accept();
                        TranscodePipe.this.connection_speed.addValue(1L);
                        new AEThread2("TranscodePipe", true){

                            public void run() {
                                TranscodePipe.this.handleSocket(socket);
                            }
                        }.start();
                    }
                    catch (Throwable throwable) {
                        if (TranscodePipe.this.destroyed) break;
                        TranscodePipe.this.destroy();
                        break;
                    }
                }
            }
        }.start();
    }

    public long getConnectionRate() {
        return this.connection_speed.getAverage();
    }

    public long getWriteSpeed() {
        return this.write_speed.getAverage();
    }

    protected abstract void handleSocket(Socket var1);

    protected void handlePipe(final InputStream inputStream, final OutputStream outputStream) {
        new AEThread2("TranscodePipe:c", true){

            public void run() {
                byte[] byArray = new byte[131072];
                while (!TranscodePipe.this.destroyed) {
                    try {
                        int n;
                        if (TranscodePipe.this.paused) {
                            Thread.sleep(250L);
                            n = 1;
                        } else if (TranscodePipe.this.max_bytes_per_sec > 0) {
                            n = TranscodePipe.this.bytes_available;
                            if (n <= 0) {
                                Thread.sleep(25L);
                                continue;
                            }
                            n = Math.min(131072, n);
                        } else {
                            n = 131072;
                        }
                        int n2 = inputStream.read(byArray, 0, n);
                        if (n2 <= 0) break;
                        if (TranscodePipe.this.max_bytes_per_sec > 0) {
                            TranscodePipe.this.bytes_available -= n2;
                        }
                        outputStream.write(byArray, 0, n2);
                        TranscodePipe.this.write_speed.addValue(n2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    outputStream.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }.start();
    }

    protected RandomAccessFile reserveRAF() throws IOException {
        throw new IOException("Not implemented");
    }

    protected void releaseRAF(RandomAccessFile randomAccessFile) {
    }

    protected void handleRAF(final OutputStream outputStream, final long l, final long l2) {
        new AEThread2("TranscodePipe:c", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block35: {
                    RandomAccessFile randomAccessFile = null;
                    randomAccessFile = TranscodePipe.this.reserveRAF();
                    long l5 = l;
                    long l22 = l2;
                    while (!TranscodePipe.this.destroyed && l22 > 0L) {
                        int n;
                        if (TranscodePipe.this.paused) {
                            Thread.sleep(250L);
                            n = 1;
                        } else {
                            if (TranscodePipe.this.max_bytes_per_sec > 0) {
                                n = TranscodePipe.this.bytes_available;
                                if (n <= 0) {
                                    Thread.sleep(25L);
                                    continue;
                                }
                                n = Math.min(131072, n);
                            } else {
                                n = 131072;
                            }
                            n = (int)Math.min(l22, (long)n);
                        }
                        int n2 = 0;
                        int n3 = 0;
                        byte[] byArray = null;
                        TranscodePipe transcodePipe = TranscodePipe.this;
                        synchronized (transcodePipe) {
                            bufferCache bufferCache2;
                            int n4 = 0;
                            Iterator iterator = TranscodePipe.this.buffer_cache.iterator();
                            while (iterator.hasNext()) {
                                byte[] byArray2;
                                long l3;
                                bufferCache2 = (bufferCache)iterator.next();
                                long l4 = l5 - bufferCache2.offset;
                                if (l4 >= 0L && (l3 = (long)(byArray2 = bufferCache2.data).length - l4) > 0L) {
                                    n2 = (int)Math.min(l3, (long)n);
                                    byArray = byArray2;
                                    n3 = (int)l4;
                                    if (n4 <= 0) break;
                                    iterator.remove();
                                    TranscodePipe.this.buffer_cache.addFirst(bufferCache2);
                                    break;
                                }
                                ++n4;
                            }
                            if (byArray == null) {
                                byArray = new byte[n];
                                randomAccessFile.seek(l5);
                                n2 = randomAccessFile.read(byArray);
                                if (n2 != n) {
                                    Debug.out("eh?");
                                    throw new IOException("Inconsistent");
                                }
                                bufferCache2 = new bufferCache(l5, byArray);
                                TranscodePipe.this.buffer_cache.addFirst(bufferCache2);
                                TranscodePipe.this.buffer_cache_size += n;
                                while (TranscodePipe.this.buffer_cache_size > 393216) {
                                    bufferCache2 = (bufferCache)TranscodePipe.this.buffer_cache.removeLast();
                                    TranscodePipe.this.buffer_cache_size -= bufferCache2.data.length;
                                }
                            }
                        }
                        if (n2 <= 0) break;
                        l22 -= (long)n2;
                        l5 += (long)n2;
                        if (TranscodePipe.this.max_bytes_per_sec > 0) {
                            TranscodePipe.this.bytes_available -= n2;
                        }
                        outputStream.write(byArray, n3, n2);
                        TranscodePipe.this.write_speed.addValue(n2);
                    }
                    outputStream.flush();
                    Object var22_17 = null;
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (randomAccessFile != null) {
                        TranscodePipe.this.releaseRAF(randomAccessFile);
                    }
                    break block35;
                    {
                        catch (Throwable throwable) {
                            if (randomAccessFile != null) {
                                try {
                                    TranscodePipe transcodePipe = TranscodePipe.this;
                                    synchronized (transcodePipe) {
                                        randomAccessFile.seek(0L);
                                        randomAccessFile.read(new byte[1]);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    TranscodePipe.this.reportError(throwable);
                                }
                            }
                            Object var22_18 = null;
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                            if (randomAccessFile != null) {
                                TranscodePipe.this.releaseRAF(randomAccessFile);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_19 = null;
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                        if (randomAccessFile != null) {
                            TranscodePipe.this.releaseRAF(randomAccessFile);
                        }
                        throw throwable;
                    }
                }
            }
        }.start();
    }

    protected void pause() {
        this.paused = true;
    }

    protected void resume() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBytesPerSecond(int n) {
        if (n == this.max_bytes_per_sec) {
            return;
        }
        this.max_bytes_per_sec = n;
        TranscodePipe transcodePipe = this;
        synchronized (transcodePipe) {
            if (this.refiller == null) {
                this.refiller = new AEThread2("refiller", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int n = 0;
                        while (!TranscodePipe.this.destroyed) {
                            if (TranscodePipe.this.max_bytes_per_sec == 0) {
                                4 var2_2 = this;
                                synchronized (var2_2) {
                                    if (TranscodePipe.this.max_bytes_per_sec == 0) {
                                        TranscodePipe.this.refiller = null;
                                        break;
                                    }
                                }
                            }
                            TranscodePipe.this.bytes_available += TranscodePipe.this.max_bytes_per_sec / 10;
                            if (++n % 10 == 0) {
                                TranscodePipe.this.bytes_available += TranscodePipe.this.max_bytes_per_sec % 10;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                                break;
                            }
                        }
                    }
                };
                this.refiller.start();
            }
        }
    }

    protected int getPort() {
        return this.server_socket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean destroy() {
        TranscodePipe transcodePipe = this;
        synchronized (transcodePipe) {
            if (this.destroyed) {
                return false;
            }
            this.destroyed = true;
        }
        for (Socket socket : this.sockets) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
        this.sockets.clear();
        try {
            this.server_socket.close();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return true;
    }

    protected void reportError(Throwable throwable) {
        if (this.error_listener != null) {
            this.error_listener.error(throwable);
        } else {
            Debug.out(throwable);
        }
    }

    protected static interface errorListener {
        public void error(Throwable var1);
    }

    private class bufferCache {
        private long offset;
        private byte[] data;

        protected bufferCache(long l, byte[] byArray) {
            this.offset = l;
            this.data = byArray;
        }
    }
}

