/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivoManager;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTivo
extends DeviceMediaRendererImpl {
    private static final boolean TRACE = false;
    private static final String NL = "\r\n";
    private static Map<String, Comparator<ItemInfo>> sort_comparators = new HashMap<String, Comparator<ItemInfo>>();
    private String server_name;
    private boolean tried_tcp_beacon;

    protected DeviceTivo(DeviceManagerImpl deviceManagerImpl, String string, String string2) {
        super(deviceManagerImpl, string, string2, false);
        this.setName("TiVo");
    }

    protected DeviceTivo(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        super(deviceManagerImpl, map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl deviceImpl, boolean bl) {
        if (!super.updateFrom(deviceImpl, bl)) {
            return false;
        }
        if (!(deviceImpl instanceof DeviceTivo)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceTivo deviceTivo = (DeviceTivo)deviceImpl;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    @Override
    public boolean canFilterFilesView() {
        return false;
    }

    @Override
    public boolean canAssociate() {
        return true;
    }

    @Override
    public boolean canShowCategories() {
        return true;
    }

    @Override
    protected boolean getShowCategoriesDefault() {
        return true;
    }

    protected String getMachineName() {
        return this.getPersistentStringProperty("tivo_machine", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void found(DeviceTivoManager deviceTivoManager, InetAddress inetAddress, String string, String string2) {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (this.server_name == null) {
                this.server_name = string;
                bl = true;
            }
        }
        if (string2 == null && !this.tried_tcp_beacon) {
            try {
                try {
                    object = new Socket();
                    try {
                        ((Socket)object).connect(new InetSocketAddress(inetAddress, 2190), 5000);
                        ((Socket)object).setSoTimeout(5000);
                        DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object).getOutputStream());
                        byte[] byArray = deviceTivoManager.encodeBeacon(false, 0);
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        DataInputStream dataInputStream = new DataInputStream(((Socket)object).getInputStream());
                        int n = dataInputStream.readInt();
                        if (n < 65536) {
                            int n2;
                            byte[] byArray2 = new byte[n];
                            for (int i = 0; i < n; i += n2) {
                                n2 = dataInputStream.read(byArray2, i, n - i);
                            }
                            Map<String, String> map = deviceTivoManager.decodeBeacon(byArray2, n);
                            string2 = map.get("machine");
                        }
                        Object var15_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_18 = null;
                        ((Socket)object).close();
                        throw throwable;
                    }
                    ((Socket)object).close();
                    Object var17_20 = null;
                    this.tried_tcp_beacon = true;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    this.tried_tcp_beacon = true;
                }
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                this.tried_tcp_beacon = true;
                throw throwable;
            }
        }
        if (!(string2 == null || (object = this.getMachineName()) != null && ((String)object).equals(string2))) {
            this.setPersistentStringProperty("tivo_machine", string2);
        }
        this.setAddress(inetAddress);
        this.alive();
        if (bl) {
            this.browseReceived();
        }
    }

    protected boolean generate(TrackerWebPageRequest trackerWebPageRequest, TrackerWebPageResponse trackerWebPageResponse) throws IOException {
        String string;
        Object object;
        InetSocketAddress inetSocketAddress = trackerWebPageRequest.getLocalAddress();
        if (inetSocketAddress == null) {
            return false;
        }
        String string2 = inetSocketAddress.getAddress().getHostAddress();
        String string3 = trackerWebPageRequest.getURL();
        if (!string3.startsWith("/TiVoConnect?")) {
            return false;
        }
        int n = string3.indexOf(63);
        if (n == -1) {
            return false;
        }
        String[] stringArray = string3.substring(n + 1).split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string4 : stringArray) {
            object = string4.split("=");
            hashMap.put(object[0], URLDecoder.decode(object[1], "UTF-8"));
        }
        String string5 = (String)hashMap.get("Command");
        if (string5 == null) {
            return false;
        }
        String string6 = null;
        if (string5.equals("QueryContainer")) {
            String string7 = (String)hashMap.get("Container");
            if (string7 == null) {
                return false;
            }
            if (string7.equals("/")) {
                string6 = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<TiVoContainer>\r\n    <Details>\r\n        <Title>" + this.server_name + "</Title>" + NL + "        <ContentType>x-container/tivo-server</ContentType>" + NL + "        <SourceFormat>x-container/folder</SourceFormat>" + NL + "        <TotalItems>1</TotalItems>" + NL + "    </Details>" + NL + "    <Item>" + NL + "        <Details>" + NL + "            <Title>" + this.server_name + "</Title>" + NL + "            <ContentType>x-container/tivo-videos</ContentType>" + NL + "            <SourceFormat>x-container/folder</SourceFormat>" + NL + "        </Details>" + NL + "        <Links>" + NL + "            <Content>" + NL + "                <Url>/TiVoConnect?Command=QueryContainer&amp;Container=" + DeviceTivo.urlencode("/Content") + "</Url>" + NL + "                <ContentType>x-container/tivo-videos</ContentType>" + NL + "            </Content>" + NL + "        </Links>" + NL + "    </Item>" + NL + "    <ItemStart>0</ItemStart>" + NL + "    <ItemCount>1</ItemCount>" + NL + "</TiVoContainer>";
            } else if (string7.startsWith("/Content")) {
                String string4;
                int n2;
                int n3;
                String string8;
                int n4;
                boolean bl = this.getShowCategories();
                object = (String)hashMap.get("Recurse");
                if (object != null && ((String)object).equals("Yes")) {
                    bl = false;
                }
                TranscodeFileImpl[] transcodeFileImplArray = this.getFiles();
                String string10 = null;
                HashMap<String, ContainerInfo> hashMap2 = null;
                if (bl) {
                    if (string7.startsWith("/Content/")) {
                        string10 = string7.substring(string7.lastIndexOf(47) + 1);
                    } else {
                        hashMap2 = new HashMap<String, ContainerInfo>();
                    }
                }
                ArrayList<ItemInfo> arrayList = new ArrayList<ItemInfo>(transcodeFileImplArray.length);
                for (TranscodeFileImpl object22 : transcodeFileImplArray) {
                    FileInfo fileInfo2;
                    String[] i;
                    if (!object22.isComplete() && !this.setupStreamXCode(object22)) continue;
                    if (string10 != null) {
                        String[] n7;
                        boolean n6 = false;
                        i = n7 = object22.getCategories();
                        int itemInfo = i.length;
                        for (n4 = 0; n4 < itemInfo; ++n4) {
                            String string82 = i[n4];
                            if (!string82.equals(string10)) continue;
                            n6 = true;
                        }
                        if (!n6) continue;
                    }
                    if (!(fileInfo2 = new FileInfo(object22, string2)).isOK()) continue;
                    boolean bl2 = false;
                    if (hashMap2 != null && (i = object22.getCategories()).length > 0) {
                        bl2 = true;
                        String[] n22 = i;
                        n4 = n22.length;
                        for (int j = 0; j < n4; ++j) {
                            string8 = n22[j];
                            ContainerInfo containerInfo = (ContainerInfo)hashMap2.get(string8);
                            if (containerInfo == null) {
                                containerInfo = new ContainerInfo(string8);
                                arrayList.add(containerInfo);
                                hashMap2.put(string8, containerInfo);
                            }
                            containerInfo.addChild();
                        }
                    }
                    if (bl2) continue;
                    arrayList.add(fileInfo2);
                }
                String string12 = (String)hashMap.get("SortOrder");
                if (string12 != null) {
                    String[] stringArray5 = string12.split(",");
                    final ArrayList<Comparator<ItemInfo>> arrayList2 = new ArrayList<Comparator<ItemInfo>>();
                    final ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
                    for (String string9 : stringArray5) {
                        Comparator<ItemInfo> comparator;
                        n4 = 0;
                        if (string9.startsWith("!")) {
                            n4 = 1;
                            string9 = string9.substring(1);
                        }
                        if ((comparator = sort_comparators.get(string9)) == null) continue;
                        arrayList2.add(comparator);
                        arrayList3.add(n4 != 0);
                    }
                    if (arrayList2.size() > 0) {
                        Collections.sort(arrayList, new Comparator<ItemInfo>(){

                            @Override
                            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                                for (int i = 0; i < arrayList2.size(); ++i) {
                                    Comparator comparator = (Comparator)arrayList2.get(i);
                                    int n = comparator.compare(itemInfo, itemInfo2);
                                    if (n == 0) continue;
                                    if (((Boolean)arrayList3.get(i)).booleanValue()) {
                                        n = -n;
                                    }
                                    return n;
                                }
                                return 0;
                            }
                        });
                    }
                }
                String string14 = (String)hashMap.get("ItemCount");
                String string15 = (String)hashMap.get("AnchorOffset");
                String string11 = (String)hashMap.get("AnchorItem");
                int n5 = string14 == null ? arrayList.size() : Integer.parseInt(string14);
                int n6 = n5 < 0 ? arrayList.size() : -1;
                if (string11 != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ItemInfo itemInfo = (ItemInfo)arrayList.get(i);
                        if (!string11.equals(itemInfo.getLinkURL())) continue;
                        n6 = i;
                    }
                }
                if (string15 != null) {
                    if ((n6 += Integer.parseInt(string15)) < -1) {
                        n6 = -1;
                    } else if (n6 > arrayList.size()) {
                        n6 = arrayList.size();
                    }
                }
                if (n5 > 0) {
                    n3 = n6 + 1;
                    n2 = n6 + n5;
                } else {
                    n3 = n6 + n5;
                    n2 = n6 - 1;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n2 >= arrayList.size()) {
                    n2 = arrayList.size() - 1;
                }
                if ((n4 = n2 - n3 + 1) < 0) {
                    n4 = 0;
                }
                if ((string4 = this.getMachineName()) == null) {
                    string4 = "TivoHDDVR";
                }
                string6 = string8 = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<TiVoContainer>\r\n    <Tivos>\r\n      <Tivo>" + string4 + "</Tivo>" + NL + "    </Tivos>" + NL + "    <ItemStart>" + n3 + "</ItemStart>" + NL + "    <ItemCount>" + n4 + "</ItemCount>" + NL + "    <Details>" + NL + "        <Title>" + DeviceTivo.escape(string7) + "</Title>" + NL + "        <ContentType>x-container/tivo-videos</ContentType>" + NL + "        <SourceFormat>x-container/folder</SourceFormat>" + NL + "        <TotalItems>" + arrayList.size() + "</TotalItems>" + NL + "    </Details>" + NL;
                for (int i = n3; i <= n2; ++i) {
                    ItemInfo itemInfo;
                    ItemInfo itemInfo2 = (ItemInfo)arrayList.get(i);
                    if (itemInfo2 instanceof FileInfo) {
                        String string13;
                        itemInfo = (FileInfo)itemInfo2;
                        long l = ((FileInfo)itemInfo).getTargetSize();
                        String string16 = string13 = DeviceTivo.escape(((FileInfo)itemInfo).getName());
                        int n7 = 30;
                        if (string13.length() > n7) {
                            int n8;
                            String string17 = "";
                            for (n8 = 0; n8 < string13.length(); ++n8) {
                                char c = string13.charAt(n8);
                                string17 = Character.isLetterOrDigit(c) ? string17 + c : string17 + ' ';
                            }
                            n8 = string17.indexOf(32);
                            if (n8 == -1 || n8 > n7) {
                                string17 = string17.substring(0, 30) + "...";
                            }
                            string13 = string17;
                        }
                        string6 = string6 + "    <Item>\r\n        <Details>\r\n            <Title>" + string13 + "</Title>" + NL + "            <ContentType>video/x-tivo-mpeg</ContentType>" + NL + "            <SourceFormat>video/x-ms-wmv</SourceFormat>" + NL;
                        if (l > 0L) {
                            string6 = string6 + "            <SourceSize>" + l + "</SourceSize>" + NL;
                        } else {
                            long l2 = ((FileInfo)itemInfo).getEstimatedTargetSize();
                            if (l2 > 0L) {
                                string6 = string6 + "            <SourceSize>" + l2 + "</SourceSize>" + NL;
                            }
                        }
                        string6 = string6 + "            <Duration>" + ((FileInfo)itemInfo).getDurationMillis() + "</Duration>" + NL + "            <Description>" + string16 + "</Description>" + NL + "            <SourceChannel>0</SourceChannel>" + NL + "            <SourceStation></SourceStation>" + NL + "            <SeriesId></SeriesId>" + NL + "            <CaptureDate>" + ((FileInfo)itemInfo).getCaptureDate() + "</CaptureDate>" + NL + "        </Details>" + NL + "        <Links>" + NL + "            <Content>" + NL + "                <ContentType>video/x-tivo-mpeg</ContentType>" + NL + "                    <AcceptsParams>No</AcceptsParams>" + NL + "                    <Url>" + ((FileInfo)itemInfo).getLinkURL() + "</Url>" + NL + "                </Content>" + NL + "                <CustomIcon>" + NL + "                    <ContentType>video/*</ContentType>" + NL + "                    <AcceptsParams>No</AcceptsParams>" + NL + "                    <Url>urn:tivo:image:save-until-i-delete-recording</Url>" + NL + "                </CustomIcon>" + NL + "        </Links>" + NL + "    </Item>" + NL;
                        continue;
                    }
                    itemInfo = (ContainerInfo)itemInfo2;
                    string6 = string6 + "    <Item>\r\n        <Details>\r\n            <Title>" + ((ContainerInfo)itemInfo).getName() + "</Title>" + NL + "            <ContentType>x-container/tivo-videos</ContentType>" + NL + "            <SourceFormat>x-container/folder</SourceFormat>" + NL + "            <TotalItems>" + ((ContainerInfo)itemInfo).getChildCount() + "</TotalItems>" + NL + "        </Details>" + NL + "        <Links>" + NL + "            <Content>" + NL + "                <Url>" + ((ContainerInfo)itemInfo).getLinkURL() + "</Url>" + NL + "                <ContentType>x-container/tivo-videos</ContentType>" + NL + "            </Content>" + NL + "        </Links>" + NL + "    </Item>" + NL;
                }
                String string18 = "</TiVoContainer>";
                string6 = string6 + string18;
            }
        } else if (string5.equals("QueryFormats") && (string = (String)hashMap.get("SourceFormat")) != null && string.startsWith("video")) {
            string6 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<TiVoFormats><Format>\r\n<ContentType>video/x-tivo-mpeg</ContentType><Description/>\r\n</Format></TiVoFormats>";
        }
        if (string6 == null) {
            return false;
        }
        trackerWebPageResponse.setContentType("text/xml");
        trackerWebPageResponse.getOutputStream().write(string6.getBytes("UTF-8"));
        return true;
    }

    protected static String urlencode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return string;
        }
    }

    protected static String escape(String string) {
        return XUXmlWriter.escapeXML(string);
    }

    @Override
    protected void getDisplayProperties(List<String[]> list) {
        super.getDisplayProperties(list);
        this.addDP(list, "devices.tivo.machine", this.getMachineName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        super.generate(indentWriter);
        try {
            indentWriter.indent();
            indentWriter.println("tico_machine=" + this.getMachineName());
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    static {
        sort_comparators.put("Type", new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                if (itemInfo.isContainer() == itemInfo2.isContainer()) {
                    return 0;
                }
                if (itemInfo.isContainer()) {
                    return -1;
                }
                return 1;
            }
        });
        sort_comparators.put("Title", new Comparator<ItemInfo>(){
            Comparator<String> c = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                return this.c.compare(itemInfo.getName(), itemInfo2.getName());
            }
        });
        sort_comparators.put("CreationDate", new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                long l = itemInfo.getCreationMillis() - itemInfo2.getCreationMillis();
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        sort_comparators.put("LastChangeDate", sort_comparators.get("CreationDate"));
        sort_comparators.put("CaptureDate", sort_comparators.get("CreationDate"));
    }

    protected static class FileInfo
    extends ItemInfo {
        private TranscodeFile file;
        private String stream_url;
        private long target_size;
        private long creation_millis;
        boolean ok;

        protected FileInfo(TranscodeFile transcodeFile, String string) {
            this.file = transcodeFile;
            try {
                URL uRL = this.file.getStreamURL(string);
                if (uRL == null) {
                    return;
                }
                this.stream_url = uRL.toExternalForm();
                try {
                    if (this.file.isComplete()) {
                        this.target_size = this.file.getTargetFile().getLength();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.creation_millis = this.file.getCreationDateMillis();
                this.ok = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected boolean isOK() {
            return this.ok;
        }

        protected String getName() {
            return this.file.getName();
        }

        protected String getLinkURL() {
            return this.stream_url;
        }

        protected long getTargetSize() {
            return this.target_size;
        }

        protected long getEstimatedTargetSize() {
            try {
                long l = this.getDurationMillis() / 1000L;
                if (l == 0L) {
                    long l2 = this.file.getSourceFile().getLength();
                    return l2 * 10L;
                }
                long l3 = 3L;
                return l * l3 * 1024L * 1024L;
            }
            catch (Throwable throwable) {
                return 0L;
            }
        }

        protected long getDurationMillis() {
            return this.file.getDurationMillis();
        }

        public long getCreationMillis() {
            return this.creation_millis;
        }

        protected String getCaptureDate() {
            return "0x" + Long.toString(this.creation_millis / 1000L, 16);
        }

        protected boolean isContainer() {
            return false;
        }
    }

    protected static class ContainerInfo
    extends ItemInfo {
        private String name;
        private int child_count;

        protected ContainerInfo(String string) {
            this.name = string;
        }

        protected String getName() {
            return this.name;
        }

        protected String getLinkURL() {
            return "/TiVoConnect?Command=QueryContainer&amp;Container=" + DeviceTivo.urlencode("/Content/" + this.name);
        }

        protected void addChild() {
            ++this.child_count;
        }

        protected int getChildCount() {
            return this.child_count;
        }

        public long getCreationMillis() {
            return 0L;
        }

        protected boolean isContainer() {
            return true;
        }
    }

    protected static abstract class ItemInfo {
        protected ItemInfo() {
        }

        protected abstract String getName();

        protected abstract String getLinkURL();

        protected abstract boolean isContainer();

        public abstract long getCreationMillis();
    }
}

