/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public abstract class AbstractChannelInterestWriter
implements ChannelWriter,
InterestWritableByteChannel {
    private volatile InterestWritableByteChannel channel;
    private volatile WriteObserver observer;

    public InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.channel = interestWritableByteChannel;
        interestWritableByteChannel.interestWrite(this, true);
    }

    public void interestWrite(WriteObserver writeObserver, boolean bl) {
        this.observer = bl ? writeObserver : null;
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.interestWrite(this, bl);
        }
    }

    public void close() throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        return interestWritableByteChannel != null ? interestWritableByteChannel.isOpen() : false;
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        return interestWritableByteChannel != null && interestWritableByteChannel.hasBufferedOutput();
    }

    public boolean handleWrite() throws IOException {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            return writeObserver.handleWrite();
        }
        return false;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel == null) {
            throw new IllegalStateException("no source!");
        }
        return interestWritableByteChannel.write(byteBuffer);
    }
}

