/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.SocketInterestReadAdapter;
import org.limewire.nio.SocketInterestWriteAdapter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.ConnectObserver;

public class NIOSocket
extends AbstractNBSocket {
    private final SocketChannel channel;
    private final Socket socket;
    private volatile SocketAddress remoteSocketAddress;

    protected NIOSocket(Socket socket) {
        this.channel = socket.getChannel();
        this.socket = this.channel.socket();
        this.remoteSocketAddress = socket.getRemoteSocketAddress();
        this.initIncomingSocket();
        this.setInitialReader();
        this.setInitialWriter();
        NIODispatcher.instance().register(this.channel, this);
    }

    public NIOSocket() throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.initOutgoingSocket();
        this.setInitialReader();
        this.setInitialWriter();
    }

    public NIOSocket(InetAddress inetAddress, int n) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.initOutgoingSocket();
        this.setInitialReader();
        this.setInitialWriter();
        this.connect(new InetSocketAddress(inetAddress, n));
    }

    public NIOSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.initOutgoingSocket();
        this.setInitialReader();
        this.setInitialWriter();
        this.bind(new InetSocketAddress(inetAddress2, n2));
        this.connect(new InetSocketAddress(inetAddress, n));
    }

    public NIOSocket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n);
    }

    public NIOSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2);
    }

    protected void initIncomingSocket() {
    }

    protected void initOutgoingSocket() throws IOException {
        this.channel.configureBlocking(false);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
    }

    public boolean connect(SocketAddress socketAddress, int n, ConnectObserver connectObserver) {
        this.remoteSocketAddress = socketAddress;
        return super.connect(socketAddress, n, connectObserver);
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public InetAddress getInetAddress() {
        if (this.remoteSocketAddress != null) {
            return ((InetSocketAddress)this.remoteSocketAddress).getAddress();
        }
        return null;
    }

    public int getPort() {
        if (this.remoteSocketAddress != null) {
            return ((InetSocketAddress)this.remoteSocketAddress).getPort();
        }
        return 0;
    }

    protected InterestReadableByteChannel getBaseReadChannel() {
        return new SocketInterestReadAdapter(this.channel);
    }

    protected InterestWritableByteChannel getBaseWriteChannel() {
        return new SocketInterestWriteAdapter(this.channel);
    }

    protected void shutdownImpl() {
        try {
            this.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (Error error) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
            SocketAddress socketAddress = this.socket.getLocalSocketAddress();
            throw new RuntimeException("wrong address type: " + (socketAddress == null ? null : socketAddress.getClass()), unsupportedAddressTypeException);
        }
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int n) {
        throw new UnsupportedOperationException("No urgent data.");
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.socket.setKeepAlive(bl);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.socket.setOOBInline(bl);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.socket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.socket.setSendBufferSize(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.socket.setTrafficClass(n);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return "NIOSocket::" + this.remoteSocketAddress + ", channel: " + this.channel.toString();
    }
}

