/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.StringValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbFileSelector
extends JBreadcrumbBar<File> {
    protected boolean useNativeIcons;

    public BreadcrumbFileSelector() {
        this(true);
    }

    public BreadcrumbFileSelector(boolean bl) {
        this(FileSystemView.getFileSystemView(), bl);
    }

    public BreadcrumbFileSelector(FileSystemView fileSystemView, boolean bl) {
        super(new DirCallback(fileSystemView, bl));
        this.useNativeIcons = bl;
    }

    public void setUseNativeIcons(boolean bl) {
        this.useNativeIcons = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(File file) {
        FileSystemView fileSystemView;
        FileSystemView fileSystemView2 = fileSystemView = FileSystemView.getFileSystemView();
        synchronized (fileSystemView2) {
            if (file == null || !file.isDirectory()) {
                file = fileSystemView.getHomeDirectory();
            }
            ArrayList arrayList = new ArrayList();
            File file2 = file;
            BreadcrumbItem<File> breadcrumbItem = new BreadcrumbItem<File>(fileSystemView.getSystemDisplayName(file), file);
            breadcrumbItem.setIcon(fileSystemView.getSystemIcon(file));
            arrayList.add(breadcrumbItem);
            while ((file2 = fileSystemView.getParentDirectory(file2)) != null) {
                breadcrumbItem = new BreadcrumbItem<File>(fileSystemView.getSystemDisplayName(file2), file2);
                breadcrumbItem.setIcon(fileSystemView.getSystemIcon(file2));
                arrayList.add(breadcrumbItem);
            }
            Collections.reverse(arrayList);
            this.setPath(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirCallback
    extends BreadcrumbBarCallBack<File> {
        protected FileSystemView fsv;
        protected boolean useNativeIcons;

        public DirCallback(boolean bl) {
            this(FileSystemView.getFileSystemView(), bl);
        }

        public DirCallback(FileSystemView fileSystemView, boolean bl) {
            this.fsv = fileSystemView;
            this.useNativeIcons = bl;
        }

        @Override
        public void setup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StringValuePair<File>> getPathChoices(List<BreadcrumbItem<File>> list) {
            FileSystemView fileSystemView = this.fsv;
            synchronized (fileSystemView) {
                if (list == null) {
                    LinkedList<StringValuePair<File>> linkedList = new LinkedList<StringValuePair<File>>();
                    for (File file : this.fsv.getRoots()) {
                        if (this.fsv.isHiddenFile(file)) continue;
                        String string = this.fsv.getSystemDisplayName(file);
                        if (string.length() == 0) {
                            string = file.getAbsolutePath();
                        }
                        StringValuePair<File> stringValuePair = new StringValuePair<File>(string, file);
                        if (this.useNativeIcons) {
                            stringValuePair.set("icon", this.fsv.getSystemIcon(file));
                        }
                        linkedList.add(stringValuePair);
                    }
                    return linkedList;
                }
                if (list.size() == 0) {
                    return null;
                }
                File file = list.get(list.size() - 1).getData();
                if (!file.exists()) {
                    return new ArrayList<StringValuePair<File>>();
                }
                if (!file.isDirectory()) {
                    return null;
                }
                LinkedList<StringValuePair<File>> linkedList = new LinkedList<StringValuePair<File>>();
                for (File file2 : file.listFiles()) {
                    if (!file2.isDirectory() || this.fsv.isHiddenFile(file2)) continue;
                    String string = this.fsv.getSystemDisplayName(file2);
                    if (string == null || string.isEmpty()) {
                        string = file2.getName();
                    }
                    StringValuePair<File> stringValuePair = new StringValuePair<File>(string, file2);
                    if (this.useNativeIcons) {
                        stringValuePair.set("icon", this.fsv.getSystemIcon(file2));
                    }
                    linkedList.add(stringValuePair);
                }
                Collections.sort(linkedList, new Comparator<StringValuePair<File>>(){

                    @Override
                    public int compare(StringValuePair<File> stringValuePair, StringValuePair<File> stringValuePair2) {
                        String string = DirCallback.this.fsv.isFileSystemRoot((File)stringValuePair.getValue()) ? ((File)stringValuePair.getValue()).getAbsolutePath() : (String)stringValuePair.getKey();
                        String string2 = DirCallback.this.fsv.isFileSystemRoot((File)stringValuePair2.getValue()) ? ((File)stringValuePair2.getValue()).getAbsolutePath() : (String)stringValuePair2.getKey();
                        return string.toLowerCase().compareTo(string2.toLowerCase());
                    }

                    @Override
                    public boolean equals(Object object) {
                        return super.equals(object);
                    }
                });
                return linkedList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StringValuePair<File>> getLeafs(List<BreadcrumbItem<File>> list) {
            FileSystemView fileSystemView = this.fsv;
            synchronized (fileSystemView) {
                if (list == null || list.size() == 0) {
                    return null;
                }
                File file = list.get(list.size() - 1).getData();
                if (!file.exists()) {
                    return new ArrayList<StringValuePair<File>>();
                }
                if (!file.isDirectory()) {
                    return null;
                }
                LinkedList<StringValuePair<File>> linkedList = new LinkedList<StringValuePair<File>>();
                for (File file2 : file.listFiles()) {
                    if (file2.isDirectory() || this.fsv.isHiddenFile(file2)) continue;
                    String string = this.fsv.getSystemDisplayName(file2);
                    if (string == null || string.isEmpty()) {
                        string = file2.getName();
                    }
                    StringValuePair<File> stringValuePair = new StringValuePair<File>(string, file2);
                    if (this.useNativeIcons) {
                        stringValuePair.set("icon", this.fsv.getSystemIcon(file2));
                    }
                    linkedList.add(stringValuePair);
                }
                Collections.sort(linkedList, new Comparator<StringValuePair<File>>(){

                    @Override
                    public int compare(StringValuePair<File> stringValuePair, StringValuePair<File> stringValuePair2) {
                        return ((String)stringValuePair.getKey()).toLowerCase().compareTo(((String)stringValuePair2.getKey()).toLowerCase());
                    }

                    @Override
                    public boolean equals(Object object) {
                        return super.equals(object);
                    }
                });
                return linkedList;
            }
        }

        @Override
        public InputStream getLeafContent(File file) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }
}

