/*
 * Decompiled with CFR 0.152.
 */
package irc.dcc.prv;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.Server;
import irc.ServerListener;
import irc.Source;
import irc.dcc.DCCFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class DCCFileHandler
extends IRCObject
implements Server,
Runnable {
    private Socket _socket;
    private ServerSocket _serverSocket;
    private Thread _thread;
    private OutputStream _os;
    private InputStream _is;
    private DCCFile _file;
    private int _action = 0;
    private int _size = 0;
    private boolean _listening;
    private boolean _connected = false;
    private ListenerGroup _listeners;

    public DCCFileHandler(IRCConfiguration iRCConfiguration, String string, File file) {
        super(iRCConfiguration);
        this._file = new DCCFile(iRCConfiguration, file, this);
        this._listeners = new ListenerGroup();
    }

    public void release() {
        this.cleanup();
        this._file = null;
        super.release();
    }

    public void receive(String string, String string2, String string3) {
        this._size = new Integer(string3);
        this._file.prepareReceive(this._size);
        this._serverSocket = null;
        this._action = 1;
        long l = new Long(string);
        int n = (int)(l & 0xFFL);
        int n2 = (int)(l >> 8 & 0xFFL);
        int n3 = (int)(l >> 16 & 0xFFL);
        int n4 = (int)(l >> 24 & 0xFFL);
        string = n4 + "." + n3 + "." + n2 + "." + n;
        try {
            this._socket = this._ircConfiguration.getSecurityProvider().getSocket(string, new Integer(string2));
            this._is = new BufferedInputStream(this._socket.getInputStream());
            this._os = new BufferedOutputStream(this._socket.getOutputStream());
            this._thread = new Thread((Runnable)this, "DCCFile thread");
            this._thread.start();
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("receive failure", exception, "bugs@frostwire.com");
        }
    }

    public String send() {
        this._action = 2;
        this._socket = null;
        try {
            int n;
            int n2;
            int n3;
            this._serverSocket = this._ircConfiguration.getSecurityProvider().getServerSocket(0);
            int n4 = this._serverSocket.getLocalPort();
            InetAddress inetAddress = this._ircConfiguration.getSecurityProvider().getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            int n5 = byArray[0];
            if (n5 < 0) {
                n5 += 256;
            }
            if ((n3 = byArray[1]) < 0) {
                n3 += 256;
            }
            if ((n2 = byArray[2]) < 0) {
                n2 += 256;
            }
            if ((n = byArray[3]) < 0) {
                n += 256;
            }
            long l = (n5 << 24) + (n3 << 16) + (n2 << 8) + n;
            this._file.prepareSend();
            int n6 = this._file.getSize();
            String string = "" + l;
            this._listening = false;
            this._thread = new Thread((Runnable)this, "DCCFile thread");
            this._thread.start();
            while (!this._listening) {
                Thread.yield();
            }
            return string + " " + n4 + " " + n6;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void writeConf(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        outputStream.flush();
    }

    private int readConf(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if (n4 < 0) {
            n4 += 256;
        }
        if ((n3 = inputStream.read()) < 0) {
            n3 += 256;
        }
        if ((n2 = inputStream.read()) < 0) {
            n2 += 256;
        }
        if ((n = inputStream.read()) < 0) {
            n += 256;
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private void connected() {
        this._connected = true;
        this._listeners.sendEventAsync("serverConnected", this);
    }

    private void disconnected() {
        this._connected = false;
        this._listeners.sendEventAsync("serverDisconnected", this);
    }

    public void run() {
        byte[] byArray = new byte[4096];
        if (this._action == 1) {
            try {
                this.connected();
                int n = 0;
                while (this._size - n > 0) {
                    int n2 = this._is.read(byArray, 0, byArray.length);
                    if (n2 == -1) {
                        throw new Exception(this.getText(267));
                    }
                    this._file.bytesReceived(byArray, 0, n2);
                    Thread.yield();
                    this.writeConf(this._os, n += n2);
                }
                this.writeConf(this._os, this._size);
                this._file.fileReceived();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._file.fileReceiveFailed();
            }
            this.disconnected();
            this.cleanup();
        } else if (this._action == 2) {
            this._listening = true;
            try {
                int n;
                int n3;
                this._serverSocket.setSoTimeout(30000);
                this._socket = this._serverSocket.accept();
                this._os = new BufferedOutputStream(this._socket.getOutputStream());
                this._is = new BufferedInputStream(this._socket.getInputStream());
                this.connected();
                int n4 = 0;
                for (int i = n = this._file.getSize(); i > 0; i -= n3) {
                    n3 = this._file.readBytes(byArray, 0, byArray.length);
                    if (n3 < 0) {
                        throw new Exception(this.getText(267));
                    }
                    this._os.write(byArray, 0, n3);
                    if (this._is.available() <= 0) continue;
                    n4 = this.readConf(this._is);
                }
                this._os.flush();
                while (n4 != n) {
                    n4 = this.readConf(this._is);
                }
                this._os.close();
                this._file.fileSent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._file.fileSentFailed();
            }
            this.disconnected();
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            this._is.close();
            this._os.close();
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("cleanup failure", exception, "bugs@frostwire.com");
        }
    }

    public void close() {
        this.cleanup();
    }

    public void say(String string, String string2) {
    }

    public void execute(String string) {
    }

    public void sendStatusMessage(String string) {
    }

    public String getNick() {
        return "";
    }

    public String getUserName() {
        return "";
    }

    public void connect() {
    }

    public void disconnect() {
        this.close();
    }

    public boolean isConnected() {
        return this._connected;
    }

    public Enumeration getSources() {
        Vector<DCCFile> vector = new Vector<DCCFile>();
        if (this._file != null) {
            vector.insertElementAt(this._file, vector.size());
        }
        return vector.elements();
    }

    public void enumerateSourcesAsCreated(ServerListener serverListener) {
        if (this._file != null) {
            serverListener.sourceCreated(this._file, this, new Boolean(true));
        }
    }

    public void enumerateSourcesAsRemoved(ServerListener serverListener) {
        if (this._file != null) {
            serverListener.sourceRemoved(this._file, this);
        }
    }

    public void setDefaultSource(Source source) {
    }

    public void addServerListener(ServerListener serverListener) {
        this._listeners.addListener(serverListener);
    }

    public void removeServerListener(ServerListener serverListener) {
        this._listeners.removeListener(serverListener);
    }

    public void leave() {
        this.disconnect();
        long l = System.currentTimeMillis();
        while (this.isConnected()) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - l <= 10000L) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this._listeners.sendEvent("sourceRemoved", this._file, this);
        this._listeners.sendEvent("serverLeft", this);
        this._file.release();
    }

    public String getServerName() {
        return this.getNick();
    }
}

