/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLSchemaFieldExtractor;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.limewire.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeXMLSchema {
    private final List<SchemaFieldInfo> _canonicalizedFields;
    private final String _schemaURI;
    private final String _description;
    private final String _rootXMLName;

    public LimeXMLSchema(URL uRL) throws IOException {
        this(new InputSource(uRL.openStream()));
    }

    public LimeXMLSchema(InputSource inputSource) throws IOException {
        Document document = this.getDocument(inputSource);
        IOUtils.close(inputSource.getByteStream());
        this._canonicalizedFields = Collections.unmodifiableList(new LimeXMLSchemaFieldExtractor().getFields(document));
        this._schemaURI = LimeXMLSchema.retrieveSchemaURI(document);
        this._rootXMLName = LimeXMLSchema.getRootXMLName(document);
        this._description = LimeXMLSchema.getDisplayString(this._schemaURI);
    }

    private Document getDocument(InputSource inputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        documentBuilder.setEntityResolver(new Resolver(inputSource));
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        return document;
    }

    private static String retrieveSchemaURI(Document document) {
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("targetNamespace");
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }

    private static String getRootXMLName(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("element");
        if (nodeList.getLength() == 0) {
            return "";
        }
        Node node = nodeList.item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return "";
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public String getRootXMLName() {
        return this._rootXMLName;
    }

    public String getInnerXMLName() {
        return this._description;
    }

    public List<SchemaFieldInfo> getCanonicalizedFields() {
        return this._canonicalizedFields;
    }

    public List<SchemaFieldInfo> getEnumerationFields() {
        LinkedList<SchemaFieldInfo> linkedList = new LinkedList<SchemaFieldInfo>();
        for (SchemaFieldInfo schemaFieldInfo : this._canonicalizedFields) {
            if (schemaFieldInfo.getEnumerationList() == null) continue;
            linkedList.add(schemaFieldInfo);
        }
        return linkedList;
    }

    public String[] getCanonicalizedFieldNames() {
        List<SchemaFieldInfo> list = this.getCanonicalizedFields();
        String[] stringArray = new String[list.size()];
        Iterator<SchemaFieldInfo> iterator = list.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iterator.next().getCanonicalizedFieldName();
        }
        return stringArray;
    }

    public String getDescription() {
        return this._description;
    }

    public static String getDisplayString(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        String string2 = n == -1 || n2 == -1 ? string : string.substring(n + 1, n2);
        return string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this._schemaURI.equals(((LimeXMLSchema)object)._schemaURI);
    }

    public int hashCode() {
        return this._schemaURI.hashCode();
    }

    public String toString() {
        return "LimeXMLSchema[description=" + this._description + ", rootXMLName=" + this._rootXMLName + ", schemaURI=" + this._schemaURI + "]";
    }

    private static final class Resolver
    implements EntityResolver {
        private InputSource schema;

        public Resolver(InputSource inputSource) {
            this.schema = inputSource;
        }

        public InputSource resolveEntity(String string, String string2) {
            return this.schema;
        }
    }
}

