/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.MessageParserBinder;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.ByteOrder;

@Singleton
public class MessageFactoryImpl
implements MessageFactory {
    private static final Log LOG = LogFactory.getLog(MessageFactoryImpl.class);
    private final MessageFactory.MessageParser[] PARSERS = new MessageFactory.MessageParser[256];
    private final byte defaultSoftMax = ConnectionSettings.SOFT_MAX.getValue();

    public MessageFactoryImpl() {
    }

    @Inject
    public MessageFactoryImpl(MessageParserBinder messageParserBinder) {
        messageParserBinder.bind(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParser(byte by, MessageFactory.MessageParser messageParser) {
        if (messageParser == null) {
            throw new NullPointerException("MessageParser is null");
        }
        int n = by & 0xFF;
        MessageFactory.MessageParser messageParser2 = null;
        MessageFactory.MessageParser[] messageParserArray = this.PARSERS;
        synchronized (this.PARSERS) {
            messageParser2 = this.PARSERS[n];
            this.PARSERS[n] = messageParser;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (messageParser2 != null && LOG.isErrorEnabled()) {
                LOG.error("There was already a MessageParser of type " + messageParser2.getClass() + " registered for functionId " + by);
            }
            return;
        }
    }

    public MessageFactory.MessageParser getParser(byte by) {
        return this.PARSERS[by & 0xFF];
    }

    public Message read(InputStream inputStream, Message.Network network) throws BadPacketException, IOException {
        return this.read(inputStream, network, new byte[23], this.defaultSoftMax, null);
    }

    public Message read(InputStream inputStream, Message.Network network, byte by) throws BadPacketException, IOException {
        return this.read(inputStream, network, new byte[23], by, null);
    }

    public Message read(InputStream inputStream, Message.Network network, byte[] byArray, byte by) throws BadPacketException, IOException {
        return this.read(inputStream, network, byArray, by, null);
    }

    public Message read(InputStream inputStream, Message.Network network, byte[] byArray, SocketAddress socketAddress) throws BadPacketException, IOException {
        return this.read(inputStream, network, byArray, this.defaultSoftMax, socketAddress);
    }

    public Message read(InputStream inputStream, Message.Network network, byte[] byArray, byte by, SocketAddress socketAddress) throws BadPacketException, IOException {
        int n;
        int n2;
        for (n = 0; n < 23; n += n2) {
            try {
                n2 = inputStream.read(byArray, n, 23 - n);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (n == 0) {
                    return null;
                }
                throw interruptedIOException;
            }
            if (n2 != -1) continue;
            throw new IOException("Connection closed.");
        }
        n = ByteOrder.leb2int(byArray, 19);
        if (n < 0 || n > MessageSettings.MAX_LENGTH.getValue()) {
            throw new IOException("Unreasonable message length: " + n);
        }
        byte[] byArray2 = null;
        if (n != 0) {
            int n3;
            byArray2 = new byte[n];
            for (int i = 0; i < n; i += n3) {
                n3 = inputStream.read(byArray2, i, n - i);
                if (n3 != -1) continue;
                throw new IOException("Read EOF before EOM.");
            }
        } else {
            byArray2 = DataUtils.EMPTY_BYTE_ARRAY;
        }
        return this.createMessage(byArray, byArray2, network, by, socketAddress);
    }

    public Message createMessage(byte[] byArray, byte[] byArray2, Message.Network network, byte by, SocketAddress socketAddress) throws BadPacketException, IOException {
        if (byArray.length < 19) {
            throw new IllegalArgumentException("header must be >= 19 bytes.");
        }
        byte by2 = byArray[16];
        MessageFactory.MessageParser messageParser = this.getParser(by2);
        if (messageParser == null) {
            throw new BadPacketException("Unrecognized function code: " + by2);
        }
        return messageParser.parse(byArray, byArray2, network, by, socketAddress);
    }
}

