/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.Message;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Message {
    private byte[] guid;
    private final byte func;
    private byte ttl;
    private byte hops;
    private int length;
    private int priority = 0;
    private final long creationTime = System.currentTimeMillis();
    private final Message.Network network;

    public static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        assert (this.guid.length == 16);
        assert (this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127 || this.func == 49 || this.func == 50 || this.func == 65) : "Bad function code";
        assert (this.ttl >= 0) : "Negative TTL: " + this.ttl;
        assert (this.hops >= 0) : "Negative hops: " + this.hops;
        assert (this.length >= 0) : "Negative length: " + this.length;
    }

    protected AbstractMessage(byte by, byte by2, int n) {
        this(by, by2, n, Message.Network.UNKNOWN);
    }

    protected AbstractMessage(byte by, byte by2, int n, Message.Network network) {
        this(AbstractMessage.makeGuid(), by, by2, 0, n, network);
    }

    protected AbstractMessage(byte[] byArray, byte by, byte by2, byte by3, int n) {
        this(byArray, by, by2, by3, n, Message.Network.UNKNOWN);
    }

    protected AbstractMessage(byte[] byArray, byte by, byte by2, byte by3, int n, Message.Network network) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + byArray.length);
        }
        this.guid = byArray;
        this.func = by;
        this.ttl = by2;
        this.hops = by3;
        this.length = n;
        this.network = network;
    }

    @Override
    public void writeQuickly(OutputStream outputStream) throws IOException {
        outputStream.write(this.guid, 0, this.guid.length);
        outputStream.write(this.func);
        outputStream.write(this.ttl);
        outputStream.write(this.hops);
        ByteOrder.int2leb(this.length, outputStream);
        this.writePayload(outputStream);
    }

    @Override
    public void write(OutputStream outputStream, byte[] byArray) throws IOException {
        System.arraycopy(this.guid, 0, byArray, 0, this.guid.length);
        byArray[16] = this.func;
        byArray[17] = this.ttl;
        byArray[18] = this.hops;
        ByteOrder.int2leb(this.length, byArray, 19);
        outputStream.write(byArray);
        this.writePayload(outputStream);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, new byte[23]);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    @Override
    public Message.Network getNetwork() {
        return this.network;
    }

    @Override
    public boolean isMulticast() {
        return this.network == Message.Network.MULTICAST;
    }

    @Override
    public boolean isUDP() {
        return this.network == Message.Network.UDP;
    }

    @Override
    public boolean isTCP() {
        return this.network == Message.Network.TCP;
    }

    @Override
    public boolean isUnknownNetwork() {
        return this.network == Message.Network.UNKNOWN;
    }

    @Override
    public byte[] getGUID() {
        return this.guid;
    }

    @Override
    public byte getFunc() {
        return this.func;
    }

    @Override
    public byte getTTL() {
        return this.ttl;
    }

    @Override
    public void setTTL(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        this.ttl = by;
    }

    protected void setGUID(GUID gUID) {
        this.guid = gUID.bytes();
    }

    @Override
    public void setHops(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException("invalid hops: " + by);
        }
        this.hops = by;
    }

    @Override
    public byte getHops() {
        return this.hops;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    protected void updateLength(int n) {
        this.length = n;
    }

    @Override
    public int getTotalLength() {
        return 23 + this.length;
    }

    @Override
    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    public int compareTo(Message message) {
        return message.getPriority() - this.getPriority();
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + ", hops=" + this.hops + ", priority=" + this.getPriority() + "}";
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return this.getClass();
    }
}

