/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.http.HeaderSupport;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

class HandshakeSupport
extends HeaderSupport {
    private String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    private static final String GNUTELLA_06 = "GNUTELLA/0.6";
    private static final String CONNECT = "CONNECT/";
    private static final String CRLF = "\r\n";
    private final Properties readHeaders;
    private final Properties writtenHeaders;
    private final String remoteAddress;
    private String remoteResponse;

    HandshakeSupport(String string) {
        this.remoteAddress = string;
        this.readHeaders = new Properties();
        this.writtenHeaders = new Properties();
    }

    HandshakeResponse createRemoteResponse(String string) throws IOException {
        this.remoteResponse = string.substring(GNUTELLA_06.length()).trim();
        return HandshakeResponse.createRemoteResponse(this.remoteResponse, this.readHeaders);
    }

    void appendConnectLine(StringBuilder stringBuilder) {
        stringBuilder.append(this.GNUTELLA_CONNECT_06).append(CRLF);
    }

    void appendResponse(HandshakeResponse handshakeResponse, StringBuilder stringBuilder) {
        stringBuilder.append(GNUTELLA_06).append(" ").append(handshakeResponse.getStatusLine()).append(CRLF);
        this.appendHeaders(handshakeResponse.props(), stringBuilder);
    }

    void appendHeaders(Properties properties, StringBuilder stringBuilder) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                String string3 = this.processKeyValueForWriting(string, string2);
                stringBuilder.append(string3);
            }
        }
        stringBuilder.append(CRLF);
    }

    boolean isConnectLineValid(String string) {
        return string.startsWith(GNUTELLA_06);
    }

    boolean notLessThan06(String string) {
        int n = string.indexOf(CONNECT);
        if (n < 0) {
            return false;
        }
        try {
            float f = Float.parseFloat(string.substring(n + CONNECT.length()));
            return f >= 0.6f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean processReadHeader(String string) {
        if (string.equals("")) {
            return false;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1).trim();
            this.readHeaders.put(string2, string3);
        }
        return true;
    }

    String processKeyValueForWriting(String string, String string2) {
        if ("Remote-IP".equals(string)) {
            string2 = this.remoteAddress;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.writtenHeaders.put(string, string2);
        return string + ": " + string2 + CRLF;
    }

    public int getHeadersReadSize() {
        return this.readHeaders.size();
    }

    HandshakeResponse getReadHandshakeRemoteResponse() throws IOException {
        return HandshakeResponse.createRemoteResponse(this.remoteResponse, this.readHeaders);
    }

    HandshakeResponse getReadHandshakeResponse() {
        return HandshakeResponse.createResponse(this.readHeaders);
    }

    HandshakeResponse getWrittenHandshakeResponse() {
        return HandshakeResponse.createResponse(this.writtenHeaders);
    }
}

