/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.application.ApplicationTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.audio.AudioTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.document.DocumentTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.image.ImageTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.video.VideoTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.limewire.util.OSUtils;

public class MetaEditor
extends JDialog {
    protected final FileDesc[] fds;
    private final String fileName;
    private JButton cancelButton;
    protected JButton okButton;
    protected MetaEditorTabbedPane tabbedPane;
    protected JPanel southPanel;

    public MetaEditor(Frame frame, FileDesc[] fileDescArray, String string) {
        super(frame, true);
        this.fds = fileDescArray;
        this.fileName = string;
        this.initComponents();
        if (OSUtils.isAnyMac()) {
            this.tabbedPane.setFocusable(false);
        }
        this.setTitle(fileDescArray[0].getFile().getName());
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.updateUI();
        this.cancelButton.updateUI();
        this.setDefaultCloseOperation(2);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.pack();
    }

    private void initComponents() {
        this.initCenterPanel();
        this.initSouthPanel();
        this.setLocationRelativeTo(this);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MetaEditor.this.disposeWindow();
            }
        });
        this.pack();
    }

    protected void initCenterPanel() {
        this.tabbedPane = this.createTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    protected MetaEditorTabbedPane createTabbedPane() {
        MetaEditorTabbedPane metaEditorTabbedPane = null;
        if (MediaType.getAudioMediaType().matches(this.fileName)) {
            metaEditorTabbedPane = new AudioTabbedPane(this.fds);
        } else if (MediaType.getVideoMediaType().matches(this.fileName)) {
            metaEditorTabbedPane = new VideoTabbedPane(this.fds);
        } else if (MediaType.getProgramMediaType().matches(this.fileName)) {
            metaEditorTabbedPane = new ApplicationTabbedPane(this.fds);
        } else if (MediaType.getImageMediaType().matches(this.fileName)) {
            metaEditorTabbedPane = new ImageTabbedPane(this.fds);
        } else if (MediaType.getDocumentMediaType().matches(this.fileName)) {
            metaEditorTabbedPane = new DocumentTabbedPane(this.fds);
        }
        return metaEditorTabbedPane;
    }

    protected void initSouthPanel() {
        JButton jButton;
        JButton jButton2;
        this.southPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(4));
        this.cancelButton = new JButton();
        this.cancelButton.setText(I18n.tr("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaEditor.this.disposeWindow();
            }
        });
        this.okButton = new JButton();
        this.okButton.setText(I18n.tr("OK"));
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaEditor.this.saveAndDisposeWindow();
            }
        });
        if (OSUtils.isAnyMac()) {
            jButton2 = this.cancelButton;
            jButton = this.okButton;
        } else {
            jButton2 = this.okButton;
            jButton = this.cancelButton;
        }
        jPanel.add(jButton2);
        jPanel.add(jButton);
        this.southPanel.add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    protected void disposeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    protected void saveAndDisposeWindow() {
        if (this.tabbedPane.hasDataChanged()) {
            MetaDataSaver metaDataSaver = new MetaDataSaver(this.tabbedPane.getFileDesc(), this.tabbedPane.getSchema(), this.tabbedPane.getInput());
            metaDataSaver.saveMetaData();
        }
        this.disposeWindow();
    }
}

