/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.aelitis.azureus.core.AzureusCore;
import com.frostwire.bittorrent.AzureusStarter;
import com.google.inject.Inject;
import com.limegroup.bittorrent.BTDownloaderImpl;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.BTUploader;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.UploadServicesImpl;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.CoreDownloaderFactory;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.upload.BrowseListener;
import com.limegroup.gnutella.gui.upload.ChatListener;
import com.limegroup.gnutella.gui.upload.ClearListener;
import com.limegroup.gnutella.gui.upload.UploadButtons;
import com.limegroup.gnutella.gui.upload.UploadDataLine;
import com.limegroup.gnutella.gui.upload.UploadModel;
import com.limegroup.gnutella.gui.upload.UploadPopupMenu;
import com.limegroup.gnutella.gui.upload.UploadProgressBarRenderer;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPopupMenu;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.limewire.io.ConnectableImpl;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UploadMediator
extends AbstractTableMediator<UploadModel, UploadDataLine, Uploader> {
    private boolean _seedingHostilesTxt = false;
    private static int _totalUploads = 0;
    private static final ProgressBarRenderer PROGRESS_BAR_RENDERER = new UploadProgressBarRenderer();
    ActionListener CHAT_LISTENER;
    ActionListener CLEAR_LISTENER;
    ActionListener BROWSE_LISTENER;
    private CoreDownloaderFactory _coreDownloaderFactory = GuiCoreMediator.getCore().getCoreDownloaderFactory();
    private static final String UPLOAD_TITLE = I18n.tr("Uploads");
    private static final String ACTIVE = I18n.tr("Active");
    private static final String QUEUED = I18n.tr("Queued");
    private static UploadMediator _instance;
    private static boolean _chatEnabled;
    private static boolean _browseEnabled;

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ChatListener(this);
        this.CLEAR_LISTENER = new ClearListener(this);
        this.BROWSE_LISTENER = new BrowseListener(this);
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(UPLOAD_TITLE);
        this.DATA_MODEL = new UploadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new UploadButtons(this).getComponent();
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(ProgressBarHolder.class, PROGRESS_BAR_RENDERER);
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Upload Window..."));
    }

    @Inject
    public UploadMediator() {
        super("UPLOAD_MEDIATOR");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UploadMediator.this.restoreSeedingTorrents();
            }
        });
    }

    private void restoreSeedingTorrents() {
        AzureusCore azureusCore = AzureusStarter.getAzureusCore();
        List list = azureusCore.getGlobalManager().getDownloadManagers();
        if (list.size() > 0) {
            for (DownloadManager downloadManager : list) {
                BTMetaInfo bTMetaInfo = null;
                try {
                    if (downloadManager.getState() != 70 && downloadManager.getState() != 75) continue;
                    byte[] byArray = FileUtils.readFileFully(new File(downloadManager.getTorrentFileName()));
                    bTMetaInfo = BTMetaInfo.readFromBytes(byArray);
                    BTDownloaderImpl bTDownloaderImpl = (BTDownloaderImpl)this._coreDownloaderFactory.createBTDownloader(bTMetaInfo);
                    bTDownloaderImpl.initBtMetaInfo(bTMetaInfo);
                    this.add(bTDownloaderImpl.createUploader());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @Override
    public void doRefresh() {
        boolean bl = (Boolean)((UploadModel)this.DATA_MODEL).refresh();
        this.setButtonEnabled(2, bl);
        int n = GuiCoreMediator.getUploadServices().getNumUploads();
        if (this._seedingHostilesTxt) {
            --n;
        }
        this.MAIN_PANEL.setTitle(UPLOAD_TITLE + " (" + n + " " + ACTIVE + ", " + GuiCoreMediator.getUploadServices().getNumQueuedUploads() + " " + QUEUED + ")");
    }

    public int getTotalUploads() {
        return _totalUploads;
    }

    public int getCurrentUploads() {
        return ((UploadModel)this.DATA_MODEL).getCurrentUploads();
    }

    public int getActiveUploads() {
        return ((UploadModel)this.DATA_MODEL).getRowCount();
    }

    public double getActiveUploadsBandwidth() {
        return ((UploadModel)this.DATA_MODEL).getActiveUploadsBandwidth();
    }

    @Override
    public void add(Uploader uploader) {
        int n;
        if (uploader.getFileName().startsWith("hostiles.txt.")) {
            this._seedingHostilesTxt = true;
            UploadServicesImpl.IS_SEEDING_HOSTILES_TXT = true;
            return;
        }
        if (!((UploadModel)this.DATA_MODEL).contains(uploader) && (n = ((UploadModel)this.DATA_MODEL).update(uploader)) == -1) {
            ++_totalUploads;
            super.add(uploader);
        }
    }

    @Override
    public void remove(Uploader uploader) {
        if (SharingSettings.CLEAR_UPLOAD.getValue() && (uploader.isInactive() || uploader instanceof BTUploader)) {
            int n = ((UploadModel)this.DATA_MODEL).getRow(uploader);
            if (n != -1) {
                ((UploadDataLine)((UploadModel)this.DATA_MODEL).get(n)).setPersistConnection(true);
                super.removeRow(n);
            }
        } else {
            UploadDataLine uploadDataLine = (UploadDataLine)((UploadModel)this.DATA_MODEL).get(uploader);
            if (uploadDataLine != null) {
                uploadDataLine.setEndTime(System.currentTimeMillis());
            }
        }
    }

    @Override
    public void removeSelection() {
        int[] nArray = this.TABLE.getSelectedRows();
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            ((UploadDataLine)((UploadModel)this.DATA_MODEL).get(n)).cleanup();
            if (!(((UploadDataLine)((UploadModel)this.DATA_MODEL).get(n)).getInitializeObject() instanceof BTUploader)) continue;
            ((UploadModel)this.DATA_MODEL).remove(n);
        }
    }

    void chatWithSelectedUploads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            Uploader uploader = (Uploader)((UploadDataLine)((UploadModel)this.DATA_MODEL).get(nArray[i])).getInitializeObject();
            if (!uploader.isChatEnabled()) continue;
            String string = uploader.getHost();
            int n = uploader.getGnutellaPort();
            GUIMediator.createChat(string, n);
        }
    }

    void browseWithSelectedUploads() {
        boolean bl = false;
        int[] nArray = this.TABLE.getSelectedRows();
        HashSet<String> hashSet = new HashSet<String>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            Uploader uploader = (Uploader)((UploadDataLine)((UploadModel)this.DATA_MODEL).get(nArray[i])).getInitializeObject();
            if (!uploader.isBrowseHostEnabled()) continue;
            String string = uploader.getHost();
            if (string == null) {
                PushEndpoint pushEndpoint;
                if (!(uploader instanceof HTTPUploader) || hashSet.contains((pushEndpoint = ((HTTPUploader)uploader).getPushEndpoint()).httpStringValue())) continue;
                SearchMediator.doBrowseHost(pushEndpoint);
                hashSet.add(pushEndpoint.httpStringValue());
                bl = true;
                continue;
            }
            if (hashSet.contains(string)) continue;
            SearchMediator.doBrowseHost(new ConnectableImpl(uploader), null);
            hashSet.add(string);
            bl = true;
        }
        if (bl) {
            GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
        }
    }

    @Override
    public void handleActionKey() {
    }

    void clearCompletedUploads() {
        ((UploadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(2, false);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new UploadPopupMenu(this).getComponent();
        jPopupMenu.getComponent(0).setEnabled(!this.TABLE.getSelectionModel().isSelectionEmpty());
        jPopupMenu.getComponent(1).setEnabled(_chatEnabled);
        jPopupMenu.getComponent(2).setEnabled(_browseEnabled);
        return jPopupMenu;
    }

    @Override
    public void handleSelection(int n) {
        UploadDataLine uploadDataLine = (UploadDataLine)((UploadModel)this.DATA_MODEL).get(n);
        _chatEnabled = uploadDataLine.isChatEnabled();
        _browseEnabled = uploadDataLine.isBrowseEnabled();
        this.setButtonEnabled(0, !this.TABLE.getSelectionModel().isSelectionEmpty());
        this.setButtonEnabled(1, _browseEnabled);
    }

    @Override
    public void handleNoSelection() {
        _chatEnabled = false;
        _browseEnabled = false;
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
    }

    public static UploadMediator instance() {
        if (_instance == null) {
            _instance = new UploadMediator();
        }
        return _instance;
    }
}

