/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.limewire.util.CommonUtils;

public class ThemeMediator {
    private static final List<ThemeObserver> THEME_OBSERVERS = new LinkedList<ThemeObserver>();
    private static boolean _themeavailable = false;

    public static void changeTheme(File file) {
        ThemeMediator.changeTheme(file, null, false);
    }

    public static boolean changeThemeB(File file, String string) {
        ThemeMediator.changeTheme(file, string, false);
        return _themeavailable;
    }

    public static void changeTheme(File file, String string) {
        ThemeMediator.changeTheme(file, string, false);
    }

    public static void changeTheme(File file, boolean bl) {
        ThemeMediator.changeTheme(file, null, bl);
    }

    public static void changeTheme(File file, String string, boolean bl) {
        if (!file.isFile() && ThemeSettings.JAR_THEME_NAMES.contains(file.getName())) {
            try {
                CommonUtils.copyResourceFile(file.getName(), file, true);
            }
            catch (IOException iOException) {
                throw new RuntimeException("couldn't extract theme!", iOException);
            }
        }
        if (!file.isFile()) {
            GUIMediator.showError(I18n.tr("The skin file you selected does not exist or is invalid. Please choose another file, or use the default."));
            _themeavailable = false;
            return;
        }
        if (string != null && !string.equals("")) {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                GUIMediator.showError(I18n.tr("The skin file you selected does not exist or is invalid. Please choose another file, or use the default."));
                return;
            }
        } else {
            string = "";
        }
        String string2 = ThemeSettings.getOtherLF();
        if (string2 == null) {
            string2 = "";
        }
        if (!ThemeSettings.THEME_FILE.getValue().equals(file) || !string.equals(string2)) {
            File file2 = ThemeSettings.THEME_FILE.getValue();
            ThemeSettings.THEME_FILE.setValue(file);
            ThemeFileHandler.reload(bl);
            ThemeSettings.setOtherLF(string);
            if (!ThemeFileHandler.isCurrent()) {
                ThemeSettings.THEME_FILE.setValue(file2);
                ThemeFileHandler.reload(bl);
                ThemeMediator.showThemeError(file.getName());
            } else {
                boolean bl2 = ThemeSettings.isPinstripesTheme();
                boolean bl3 = ResourceManager.instance().isBrushedMetalSet();
                boolean bl4 = ThemeSettings.isBrushedMetalTheme();
                if (bl2 && bl3 || bl4 && !bl3) {
                    GUIMediator.showMessage(I18n.tr("To try your new skin, you must restart FrostWire."));
                } else {
                    GUIMediator.setAppVisible(false);
                    SplashWindow.instance().setVisible(true);
                    SplashWindow.instance().refreshImage();
                    ResourceManager.instance().themeChanged();
                    ThemeMediator.updateComponentHierarchy();
                    ThemeMediator.updateThemeObservers();
                    GUIMediator.setAppVisible(true);
                    SplashWindow.instance().setVisible(false);
                    _themeavailable = true;
                }
            }
        }
        _themeavailable = true;
    }

    public static void updateComponentHierarchy() {
        SwingUtilities.updateComponentTreeUI(GUIMediator.getMainOptionsComponent());
        TipOfTheDayMediator.instance().updateComponentTreeUI();
        SwingUtilities.updateComponentTreeUI(GUIMediator.getAppFrame());
        NotifyUserProxy.instance().updateUI();
        ThemeMediator.updateThemeObservers();
    }

    public static void addThemeObserver(ThemeObserver themeObserver) {
        THEME_OBSERVERS.add(themeObserver);
    }

    public static void removeThemeObserver(ThemeObserver themeObserver) {
        THEME_OBSERVERS.remove(themeObserver);
    }

    public static void updateThemeObservers() {
        for (ThemeObserver themeObserver : THEME_OBSERVERS) {
            themeObserver.updateTheme();
        }
        GUIMediator.getMainOptionsComponent().validate();
        GUIMediator.getAppFrame().validate();
    }

    public static void showThemeError(String string) {
        Dimension dimension = new Dimension(300, 100);
        final JDialog jDialog = new JDialog(GUIMediator.getAppFrame());
        jDialog.setModal(true);
        jDialog.setResizable(false);
        jDialog.setTitle(I18n.tr("Invalid Skin"));
        jDialog.setDefaultCloseOperation(2);
        BoxPanel boxPanel = new BoxPanel(1);
        BoxPanel boxPanel2 = new BoxPanel(1);
        MultiLineLabel multiLineLabel = new MultiLineLabel(I18n.tr("The skin you selected is out of date. Please download the latest version of the skin."), 250);
        multiLineLabel.setFont(new Font("Dialog", 1, 12));
        boxPanel2.add(Box.createVerticalGlue());
        boxPanel2.add(GUIUtils.center(multiLineLabel));
        boxPanel2.add(Box.createVerticalGlue());
        BoxPanel boxPanel3 = new BoxPanel(0);
        JButton jButton = new JButton(I18n.tr("Get New Skins"));
        JButton jButton2 = new JButton(I18n.tr("Later"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.openURL("http://dl.frostwire.com/skins/4.17.0/");
                jDialog.dispose();
                jDialog.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                jDialog.setVisible(false);
            }
        });
        boxPanel3.add(jButton);
        boxPanel3.add(GUIMediator.getHorizontalSeparator());
        boxPanel3.add(jButton2);
        boxPanel.add(boxPanel2);
        boxPanel.add(boxPanel3);
        boxPanel.setPreferredSize(dimension);
        jDialog.getContentPane().add(boxPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        jDialog.setVisible(true);
    }
}

