/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tabs.Tab;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractTab
implements Tab {
    private String title;
    private String toolTip;
    private Icon icon;
    private String iconFile;
    private final PropertyChangeSupport propertyChangeSupport;

    public AbstractTab(String string, String string2, String string3) {
        this.title = string;
        this.toolTip = string2;
        this.iconFile = string3;
        this.icon = GUIMediator.getThemeImage(this.iconFile);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public abstract void storeState(boolean var1);

    public abstract JComponent getComponent();

    public String getTitle() {
        return this.title;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.title + " tab";
    }

    void changeTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.propertyChangeSupport.firePropertyChange("title", string2, string);
    }

    void changeTooltip(String string) {
        String string2 = this.toolTip;
        this.toolTip = string;
        this.propertyChangeSupport.firePropertyChange("tooltip", string2, string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void mouseClicked() {
    }
}

