/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.JMultilineToolTip;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.DataUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeJTable
extends JTable
implements JSortTable {
    private static final int DEFAULT_ROW_HEIGHT = 16;
    protected Map<Object, LimeTableColumn> _hiddenColumns = new HashMap<Object, LimeTableColumn>();
    protected int pressedColumnIndex = -1;
    private String[] tips;
    private final String[] CLIPPED_TIP = new String[1];
    private static LimeTableColumn _lastRemoved;
    protected ColumnPreferenceHandler columnPreferences;
    protected TableSettings tableSettings;

    public LimeJTable() {
        this.setToolTipText("");
        GUIUtils.fixInputMap(this);
        this.addFocusListener(FocusHandler.INSTANCE);
    }

    public LimeJTable(DataLineModel dataLineModel) {
        super(dataLineModel);
        this.setToolTipText("");
        GUIUtils.fixInputMap(this);
        this.addFocusListener(FocusHandler.INSTANCE);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    public void setSelectedRow(int n) {
        this.clearSelection();
        this.addRowSelectionInterval(n, n);
    }

    @Override
    public int getSelectedRow() {
        int n = super.getSelectedRow();
        if (n >= this.dataModel.getRowCount()) {
            return -1;
        }
        return n;
    }

    @Override
    public int[] getSelectedRows() {
        int[] nArray = super.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return nArray;
        }
        Arrays.sort(nArray);
        int n = this.dataModel.getRowCount();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            int[] nArray2 = new int[i];
            System.arraycopy(nArray, 0, nArray2, 0, i);
            return nArray2;
        }
        return nArray;
    }

    public void ensureSelectionVisible() {
        this.ensureRowVisible(this.getSelectedRow());
    }

    public void ensureRowVisible(int n) {
        if (n != -1) {
            Rectangle rectangle = this.getCellRect(n, 0, false);
            Rectangle rectangle2 = this.getVisibleRect();
            if (!rectangle2.intersects(rectangle)) {
                this.scrollRectToVisible(rectangle);
            }
        }
    }

    public boolean isSelectionVisible() {
        return this.isRowVisible(this.getSelectedRow());
    }

    public boolean isRowVisible(int n) {
        if (n != -1) {
            Rectangle rectangle = this.getCellRect(n, 0, false);
            Rectangle rectangle2 = this.getVisibleRect();
            return rectangle2.intersects(rectangle);
        }
        return false;
    }

    public ColumnPreferenceHandler getColumnPreferenceHandler() {
        return this.columnPreferences;
    }

    public void setColumnPreferenceHandler(ColumnPreferenceHandler columnPreferenceHandler) {
        this.columnPreferences = columnPreferenceHandler;
    }

    public TableSettings getTableSettings() {
        return this.tableSettings;
    }

    public void setTableSettings(TableSettings tableSettings) {
        this.tableSettings = tableSettings;
    }

    public void setPressedColumnIndex(int n) {
        this.pressedColumnIndex = n;
    }

    @Override
    public int getPressedColumnIndex() {
        return this.convertColumnIndexToView(this.pressedColumnIndex);
    }

    @Override
    public int getSortedColumnIndex() {
        return this.convertColumnIndexToView(((DataLineModel)this.dataModel).getSortColumn());
    }

    @Override
    public boolean isSortedColumnAscending() {
        return ((DataLineModel)this.dataModel).isSortAscending();
    }

    public void setColumnVisible(Object object, boolean bl) throws LastColumnException {
        if (!bl) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (tableColumnModel.getColumnCount() == 1) {
                throw new LastColumnException();
            }
            LimeTableColumn limeTableColumn = (LimeTableColumn)tableColumnModel.getColumn(tableColumnModel.getColumnIndex(object));
            this._hiddenColumns.put(object, limeTableColumn);
            _lastRemoved = limeTableColumn;
            this.removeColumn(limeTableColumn);
        } else {
            TableColumn tableColumn = this._hiddenColumns.get(object);
            this._hiddenColumns.remove(object);
            this.addColumn(tableColumn);
        }
    }

    public Iterator<LimeTableColumn> getHiddenColumns() {
        return Collections.unmodifiableCollection(this._hiddenColumns.values()).iterator();
    }

    public LimeTableColumn getLastRemovedColumn() {
        return _lastRemoved;
    }

    public boolean isColumnVisible(Object object) {
        return !this._hiddenColumns.containsKey(object);
    }

    public boolean isPointSelected(Point point) {
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n == -1 || n2 == -1) {
            return false;
        }
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        try {
            int n;
            TableModel tableModel;
            int n2 = -1;
            if (OSUtils.isAnyMac() && mouseEvent.isControlDown() && (tableModel = this.getModel()) != null && this.isRowSelected(n = this.rowAtPoint(mouseEvent.getPoint()))) {
                n2 = n;
            }
            super.processMouseEvent(mouseEvent);
            if (n2 != -1) {
                this.getSelectionModel().addSelectionInterval(n2, n2);
            }
            if (mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() && (tableModel = this.getModel()) != null && ((n = this.rowAtPoint(mouseEvent.getPoint())) < 0 || n >= tableModel.getRowCount())) {
                this.clearSelection();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = arrayIndexOutOfBoundsException.getMessage();
            if (string != null && string.indexOf("at javax.swing.MenuSelectionManager.processMouseEvent") != -1) {
                return;
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        boolean bl;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        int n3 = this.convertColumnIndexToModel(n2);
        DataLineModel dataLineModel = (DataLineModel)this.dataModel;
        boolean bl2 = n2 > -1 && n > -1 ? dataLineModel.isClippable(n3) : false;
        boolean bl3 = bl = n2 > -1 && n > -1 ? dataLineModel.isTooltipRequired(n, n2) : false;
        if (!this.tableSettings.DISPLAY_TOOLTIPS.getValue() && !bl) {
            if (bl2) {
                return this.clippedToolTip(n, n2, n3);
            }
            return null;
        }
        if (n > -1) {
            this.tips = dataLineModel.getToolTipArray(n, n3);
            if (this.tips == null) {
                if (bl2) {
                    return this.clippedToolTip(n, n2, n3);
                }
                return null;
            }
            return dataLineModel.get(n).toString() + n2;
        }
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return null;
    }

    private String clippedToolTip(int n, int n2, int n3) {
        int n4;
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        int n5 = tableColumn.getWidth();
        if (n5 < (n4 = this.getDataWidth(n, n3))) {
            this.tips = this.CLIPPED_TIP;
            return ((DataLineModel)this.dataModel).get(n).toString() + n2;
        }
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return null;
    }

    private int getDataWidth(int n, int n2) {
        String string;
        DataLineModel dataLineModel = (DataLineModel)this.dataModel;
        Object t = dataLineModel.get(n);
        Object object = t.getValueAt(n2);
        if (object != null && (string = object.toString()) != null) {
            if (object instanceof Icon && string.startsWith("file:")) {
                return -1;
            }
            this.CLIPPED_TIP[0] = string;
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer(dataLineModel.getColumnClass(n2));
            JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(this, object, false, false, n, n2);
            try {
                FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
                return fontMetrics.stringWidth(string) + 3;
            }
            catch (NullPointerException nullPointerException) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public JToolTip createToolTip() {
        JMultilineToolTip jMultilineToolTip = JMultilineToolTip.instance();
        jMultilineToolTip.setToolTipArray(this.tips);
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return jMultilineToolTip;
    }

    @Override
    public void createDefaultColumnsFromModel() {
        DataLineModel dataLineModel = (DataLineModel)this.dataModel;
        if (dataLineModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
                LimeTableColumn limeTableColumn = dataLineModel.getTableColumn(i);
                this.addColumn(limeTableColumn);
            }
        }
    }

    public Color getBackgroundForRow(int n) {
        if (n % 2 == 0 || !this.tableSettings.ROWSTRIPE.getValue()) {
            return this.getBackground();
        }
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (tableCellRenderer == null) {
            throw new IllegalStateException("null renderer, row: " + n + ", column: " + n2 + ", id: " + this.tableSettings.getID() + ", columnId: " + this.getColumnModel().getColumn(n2));
        }
        Object object = this.getValueAt(n, n2);
        boolean bl = this.isCellSelected(n, n2);
        boolean bl2 = this.selectionModel.getAnchorSelectionIndex() == n;
        boolean bl3 = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == n2;
        boolean bl4 = bl2 && bl3 && this.hasFocus();
        Component component = tableCellRenderer.getTableCellRendererComponent(this, object, bl, bl4, n, n2);
        Color color = this.getEvenRowColor(n);
        Color color2 = this.getOddRowColor(n);
        if (!(bl || bl4 && this.isCellEditable(n, n2) || color2.equals(color))) {
            if (!this.tableSettings.ROWSTRIPE.getValue()) {
                if (component != null && !component.equals(color2)) {
                    component.setBackground(color2);
                }
            } else if (n % 2 != 0) {
                component.setBackground(color);
            } else {
                component.setBackground(color2);
            }
        }
        return component;
    }

    public int getNextMatch(String string, int n, Position.Bias bias) {
        DataLineModel dataLineModel = (DataLineModel)this.dataModel;
        int n2 = dataLineModel.getRowCount();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException();
        }
        string = string.toUpperCase();
        int n3 = bias == Position.Bias.Forward ? 1 : -1;
        int n4 = n;
        int n5 = dataLineModel.getTypeAheadColumn();
        if (n5 >= 0 && n5 < dataLineModel.getColumnCount()) {
            do {
                String string2;
                Object object;
                if ((object = dataLineModel.getValueAt(n4, n5)) == null) continue;
                if (object instanceof String) {
                    string2 = ((String)object).toUpperCase();
                } else {
                    string2 = object.toString();
                    if (string2 != null) {
                        string2 = string2.toUpperCase();
                    }
                }
                if (string2 == null || !string2.startsWith(string)) continue;
                return n4;
            } while ((n4 = (n4 + n3 + n2) % n2) != n);
        }
        return -1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            return container.getHeight() > this.getPreferredSize().height;
        }
        return super.getScrollableTracksViewportHeight();
    }

    @Override
    public void paint(Graphics graphics) {
        Border border;
        super.paint(graphics);
        int n = this.getFocusedRow(true);
        if (n != -1 && n < this.getRowCount() && (border = UIManager.getBorder("Table.focusRowHighlightBorder")) != null) {
            Rectangle rectangle = this.getCellRect(n, 0, true);
            rectangle.width = this.getWidth();
            border.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Color getEvenRowColor(int n) {
        return ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
    }

    protected Color getOddRowColor(int n) {
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    private void repaintFocusedRow() {
        int n = this.getFocusedRow(false);
        if (n != -1 && n < this.getRowCount()) {
            Rectangle rectangle = this.getCellRect(n, 0, true);
            rectangle.width = this.getWidth();
            this.repaint(rectangle);
        }
    }

    private int getFocusedRow(boolean bl) {
        if (!bl || this.hasFocus()) {
            return this.selectionModel.getAnchorSelectionIndex();
        }
        return -1;
    }

    private void updateRowHeight() {
        int n = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
        if (n != 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.setRowHeight(Math.max(fontMetrics.getHeight() + 1, 16));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateRowHeight();
    }

    private static class FocusHandler
    implements FocusListener {
        private static final FocusListener INSTANCE = new FocusHandler();

        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            LimeJTable limeJTable = (LimeJTable)focusEvent.getSource();
            limeJTable.repaintFocusedRow();
        }

        public void focusLost(FocusEvent focusEvent) {
            LimeJTable limeJTable = (LimeJTable)focusEvent.getSource();
            limeJTable.repaintFocusedRow();
        }
    }
}

