/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.setting.BooleanSetting;

public class ColumnSelectionMenu {
    protected static final String COLUMN_ID = "columnId";
    protected static final String SETTING = "setting";
    protected static final ActionListener SETTING_LISTENER = new SettingListener();
    private static final String REVERT_DEFAULT = I18n.tr("Revert To Default");
    public static final String MORE_OPTIONS = I18n.tr("More Options");
    public static final String ROWSTRIPE = I18n.tr("Stripe Rows");
    public static final String SORTING = I18n.tr("Sort Automatically");
    public static final String TOOLTIPS = I18n.tr("Extended Tooltips");
    protected final JPopupMenu _menu = new JPopupMenu();
    private final LimeJTable _table;

    public ColumnSelectionMenu(LimeJTable limeJTable) {
        this._table = limeJTable;
        DataLineModel dataLineModel = (DataLineModel)this._table.getModel();
        ReverterListener reverterListener = new ReverterListener();
        JMenuItem jMenuItem = new JMenuItem(REVERT_DEFAULT);
        ColumnPreferenceHandler columnPreferenceHandler = this._table.getColumnPreferenceHandler();
        TableSettings tableSettings = this._table.getTableSettings();
        if ((columnPreferenceHandler == null || columnPreferenceHandler.isDefault()) && (tableSettings == null || tableSettings.isDefault())) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.addActionListener(reverterListener);
        }
        this._menu.add(jMenuItem);
        if (tableSettings != null) {
            JMenu jMenu = ColumnSelectionMenu.createMoreOptions(tableSettings);
            this._menu.add(jMenu);
        }
        this._menu.addSeparator();
        this.addTableColumnChoices(new SelectionActionListener(), dataLineModel, limeJTable);
    }

    protected void addTableColumnChoices(ActionListener actionListener, DataLineModel dataLineModel, LimeJTable limeJTable) {
        for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
            JMenuItem jMenuItem = this.createColumnMenuItem(actionListener, dataLineModel, limeJTable, i);
            this._menu.add(jMenuItem);
        }
    }

    protected JMenuItem createColumnMenuItem(ActionListener actionListener, DataLineModel dataLineModel, LimeJTable limeJTable, int n) {
        Object object = dataLineModel.getColumnId(n);
        String string = dataLineModel.getColumnName(n);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, limeJTable.isColumnVisible(object));
        jCheckBoxMenuItem.putClientProperty(COLUMN_ID, object);
        jCheckBoxMenuItem.addActionListener(actionListener);
        return jCheckBoxMenuItem;
    }

    public static JMenu createMoreOptions(TableSettings tableSettings) {
        JMenu jMenu = new JMenu(MORE_OPTIONS);
        ColumnSelectionMenu.addSetting(jMenu, ROWSTRIPE, tableSettings.ROWSTRIPE);
        ColumnSelectionMenu.addSetting(jMenu, SORTING, tableSettings.REAL_TIME_SORT);
        ColumnSelectionMenu.addSetting(jMenu, TOOLTIPS, tableSettings.DISPLAY_TOOLTIPS);
        return jMenu;
    }

    public static JMenuItem addSetting(JMenu jMenu, String string, BooleanSetting booleanSetting) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, booleanSetting.getValue());
        jCheckBoxMenuItem.putClientProperty(SETTING, booleanSetting);
        jCheckBoxMenuItem.addActionListener(SETTING_LISTENER);
        jMenu.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    public JPopupMenu getComponent() {
        return this._menu;
    }

    protected static class SettingListener
    implements ActionListener {
        protected SettingListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            BooleanSetting booleanSetting = (BooleanSetting)jCheckBoxMenuItem.getClientProperty(ColumnSelectionMenu.SETTING);
            booleanSetting.setValue(jCheckBoxMenuItem.getState());
        }
    }

    protected class ReverterListener
    implements ActionListener {
        protected ReverterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColumnSelectionMenu.this._table.getColumnPreferenceHandler().revertToDefault();
            ColumnSelectionMenu.this._table.getTableSettings().revertToDefault();
        }
    }

    protected class SelectionActionListener
    implements ActionListener {
        protected SelectionActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            try {
                ColumnSelectionMenu.this._table.setColumnVisible(jCheckBoxMenuItem.getClientProperty(ColumnSelectionMenu.COLUMN_ID), jCheckBoxMenuItem.getState());
                ColumnSelectionMenu.this._table.getTableHeader().setDraggedColumn(null);
            }
            catch (LastColumnException lastColumnException) {
                GUIMediator.showError(I18n.tr("You cannot turn off all columns."), QuestionsHandler.REMOVE_LAST_COLUMN);
            }
        }
    }
}

