/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.mininova.MininovaVuzeItem;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JPopupMenu;

public class MininovaVuzeSearchResult
extends AbstractSearchResult {
    public static String redirectUrl = null;
    private boolean _isDownloading;
    private MininovaVuzeItem _item;
    private SearchInformation _info;

    public MininovaVuzeSearchResult(MininovaVuzeItem mininovaVuzeItem, SearchInformation searchInformation) {
        this._item = mininovaVuzeItem;
        this._info = searchInformation;
        this._isDownloading = false;
    }

    public long getCreationTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        long l = System.currentTimeMillis();
        try {
            l = simpleDateFormat.parse(this._item.date).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return l;
    }

    public Color getEvenRowColor() {
        return ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
    }

    public String getExtension() {
        return "torrent";
    }

    public String getFileName() {
        String string = this._item.title.replace("<b>", "").replace("</b>", "");
        return string + ".torrent";
    }

    public String getFilenameNoExtension() {
        return "<html>" + this._item.title + "</html>";
    }

    public String getHost() {
        return "http://www.mininova.org";
    }

    public Color getOddRowColor() {
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    public int getQuality() {
        return 3;
    }

    public URN getSHA1Urn() {
        return null;
    }

    public int getSecureStatus() {
        return 0;
    }

    public long getSize() {
        return this._item.size;
    }

    public float getSpamRating() {
        return 0.0f;
    }

    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    public String getVendor() {
        return "Mininova";
    }

    public LimeXMLDocument getXMLDocument() {
        return null;
    }

    public void initialize(TableLine tableLine) {
        tableLine.setAddedOn(this.getCreationTime());
        int n = Integer.valueOf(this._item.seeds) + Integer.valueOf(this._item.superseeds);
        tableLine.initLocations(n);
    }

    public boolean isDownloading() {
        return this._isDownloading;
    }

    public boolean isMeasuredSpeed() {
        return false;
    }

    public void takeAction(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        this._isDownloading = true;
        try {
            GUIMediator.instance().openTorrentURI(new URI(this._item.download));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.showTorrentDetails();
    }

    private void showTorrentDetails() {
        this.showTorrentDetails(1250L);
    }

    private void showTorrentDetails(long l) {
        if (!BittorrentSettings.TORRENT_DETAIL_PAGE_SHOWN_AFTER_DOWNLOAD.getValue()) {
            return;
        }
        try {
            if (redirectUrl != null) {
                String string = "q=" + HTTPUtils.encode(this._info.getQuery(), "utf-8");
                String string2 = "u=" + HTTPUtils.encode(this._item.cdp, "utf-8");
                String string3 = "t=" + HTTPUtils.encode(this.getFileName(), "utf-8");
                GUIMediator.waitAndOpenURL(redirectUrl + "?" + string + "&" + string2 + "&" + string3, l);
            } else {
                GUIMediator.waitAndOpenURL(this._item.cdp, l);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public JPopupMenu createMenu(JPopupMenu jPopupMenu, TableLine[] tableLineArray, boolean bl, boolean bl2, ResultPanel resultPanel) {
        PopupUtils.addMenuItem(I18n.tr("Buy this item now"), resultPanel.BUY_LISTENER, jPopupMenu, tableLineArray.length == 1, 0);
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MininovaVuzeSearchResult.this.takeAction(null, null, null, null, false, null);
            }
        }, jPopupMenu, tableLineArray.length > 0, 1);
        PopupUtils.addMenuItem(I18n.tr("Torrent Details"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MininovaVuzeSearchResult.this.showTorrentDetails(0L);
            }
        }, jPopupMenu, tableLineArray.length == 1, 2);
        return jPopupMenu;
    }
}

