/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.ListModelMap;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.limewire.collection.Comparators;

final class MetadataModel {
    private final ListModelMap MODEL = new Model();
    private static final String UNKNOWN = "unknown";
    private final ListModelMap PROPERTIES = new Model(Comparators.stringComparator());

    MetadataModel() {
        this.initialize();
    }

    void clear() {
        this.MODEL.clear();
        this.PROPERTIES.clear();
        this.initialize();
    }

    void addNew(TableLine tableLine) {
        NamedMediaType namedMediaType = tableLine.getNamedMediaType();
        this.addProperties(tableLine);
        if (namedMediaType == null) {
            return;
        }
        ListModelMap listModelMap = this.getMap(this.MODEL, namedMediaType);
        LimeXMLDocument limeXMLDocument = tableLine.getXMLDocument();
        if (limeXMLDocument != null) {
            this.addDocument(listModelMap, namedMediaType.getSchema(), limeXMLDocument, tableLine);
        } else {
            this.getCollection(listModelMap, UNKNOWN).add(tableLine);
        }
    }

    void remove(TableLine tableLine) {
        NamedMediaType namedMediaType = tableLine.getNamedMediaType();
        this.removeProperties(tableLine);
        if (namedMediaType == null) {
            return;
        }
        ListModelMap listModelMap = this.getMap(this.MODEL, namedMediaType);
        LimeXMLDocument limeXMLDocument = tableLine.getXMLDocument();
        if (limeXMLDocument != null) {
            this.removeDocument(listModelMap, namedMediaType.getSchema(), limeXMLDocument, tableLine);
        } else {
            this.getCollection(listModelMap, UNKNOWN).remove(tableLine);
        }
    }

    void addNewDocument(LimeXMLDocument limeXMLDocument, TableLine tableLine) {
        NamedMediaType namedMediaType = tableLine.getNamedMediaType();
        ListModelMap listModelMap = this.getMap(this.MODEL, namedMediaType);
        this.addDocument(listModelMap, namedMediaType.getSchema(), limeXMLDocument, tableLine);
    }

    void addField(SchemaFieldInfo schemaFieldInfo, String string, String string2, TableLine tableLine) {
        NamedMediaType namedMediaType = tableLine.getNamedMediaType();
        ListModelMap listModelMap = this.getMap(this.MODEL, namedMediaType);
        ListModelMap listModelMap2 = this.getMapNatural(listModelMap, string);
        this.getCollection(listModelMap2, new XMLValue(string2, schemaFieldInfo)).add(tableLine);
    }

    void updateProperty(String string, Object object, Object object2, TableLine tableLine) {
        ListModelMap listModelMap = this.getMap(this.PROPERTIES, string);
        this.getCollection(listModelMap, object2).remove(tableLine);
        this.getCollection(listModelMap, object).add(tableLine);
    }

    ListModelMap getListModelMap(Selector selector) {
        switch (selector.getSelectorType()) {
            case 1: {
                return this.MODEL;
            }
            case 2: {
                NamedMediaType namedMediaType = NamedMediaType.getFromDescription(selector.getSchema());
                return this.getMapNatural(this.getMap(this.MODEL, namedMediaType), selector.getValue());
            }
            case 3: {
                return this.getMap(this.PROPERTIES, selector.getValue());
            }
        }
        return null;
    }

    List getSelectorOptions() {
        LinkedList<Selector> linkedList = new LinkedList<Selector>();
        linkedList.add(Selector.createSchemaSelector());
        for (Map.Entry entry : this.MODEL.entrySet()) {
            NamedMediaType namedMediaType = (NamedMediaType)entry.getKey();
            String string = namedMediaType.getMediaType().getMimeType();
            for (String string2 : ((Map)entry.getValue()).keySet()) {
                if (UNKNOWN.equals(string2)) continue;
                linkedList.add(Selector.createFieldSelector(string, string2));
            }
        }
        Iterator iterator = this.PROPERTIES.keySet().iterator();
        while (iterator.hasNext()) {
            linkedList.add(Selector.createPropertySelector((String)((Object)iterator.next())));
        }
        return linkedList;
    }

    ListModelMap getIntersection(ListModelMap listModelMap, Object object, ListModelMap listModelMap2) {
        Collection collection;
        Object object2;
        if (object != null && !MetadataModel.isAll(object)) {
            object2 = listModelMap.get(object);
            if (object2 == null) {
                throw new IllegalArgumentException("invalid selection");
            }
            collection = this.getAllValues(object2);
        } else {
            collection = this.getAllValues(listModelMap);
        }
        object2 = listModelMap2.comparator() == null ? new Model() : new Model(listModelMap2.comparator());
        for (Map.Entry entry : listModelMap2.entrySet()) {
            if (!DataUtils.containsAny(collection, this.getAllValues(entry.getValue()))) continue;
            object2.put(entry.getKey(), entry.getValue());
        }
        return object2;
    }

    private void initialize() {
        this.PROPERTIES.put(Selector.PropertyType.TYPE.getKey(), new Model());
        this.PROPERTIES.put(Selector.PropertyType.SPEED.getKey(), new Model());
    }

    private void addDocument(Map map, LimeXMLSchema limeXMLSchema, LimeXMLDocument limeXMLDocument, TableLine tableLine) {
        boolean bl = false;
        for (SchemaFieldInfo schemaFieldInfo : limeXMLSchema.getCanonicalizedFields()) {
            String string = schemaFieldInfo.getCanonicalizedFieldName();
            String string2 = limeXMLDocument.getValue(string);
            if (string2 == null) continue;
            bl = true;
            ListModelMap listModelMap = this.getMapNatural(map, string);
            this.getCollection(listModelMap, new XMLValue(string2, schemaFieldInfo)).add(tableLine);
        }
        if (!bl) {
            this.getCollection(map, UNKNOWN).add(tableLine);
        }
    }

    private void removeDocument(Map map, LimeXMLSchema limeXMLSchema, LimeXMLDocument limeXMLDocument, TableLine tableLine) {
        boolean bl = false;
        for (SchemaFieldInfo schemaFieldInfo : limeXMLSchema.getCanonicalizedFields()) {
            String string = schemaFieldInfo.getCanonicalizedFieldName();
            String string2 = limeXMLDocument.getValue(string);
            if (string2 == null) continue;
            bl = true;
            ListModelMap listModelMap = this.getMapNatural(map, string);
            this.getCollection(listModelMap, new XMLValue(string2, schemaFieldInfo)).remove(tableLine);
        }
        if (!bl) {
            this.getCollection(map, UNKNOWN).remove(tableLine);
        }
    }

    private void addProperties(TableLine tableLine) {
        ListModelMap listModelMap = this.getMap(this.PROPERTIES, Selector.PropertyType.TYPE.getKey());
        this.getCollection(listModelMap, tableLine.getIconAndExtension()).add(tableLine);
        ListModelMap listModelMap2 = this.getMap(this.PROPERTIES, Selector.PropertyType.SPEED.getKey());
        this.getCollection(listModelMap2, tableLine.getSpeed()).add(tableLine);
        ListModelMap listModelMap3 = this.getMap(this.PROPERTIES, Selector.PropertyType.VENDOR.getKey());
        this.getCollection(listModelMap3, tableLine.getVendor()).add(tableLine);
    }

    private void removeProperties(TableLine tableLine) {
        ListModelMap listModelMap = this.getMap(this.PROPERTIES, Selector.PropertyType.TYPE.getKey());
        this.getCollection(listModelMap, tableLine.getIconAndExtension()).remove(tableLine);
        ListModelMap listModelMap2 = this.getMap(this.PROPERTIES, Selector.PropertyType.SPEED.getKey());
        this.getCollection(listModelMap2, tableLine.getSpeed()).remove(tableLine);
        ListModelMap listModelMap3 = this.getMap(this.PROPERTIES, Selector.PropertyType.VENDOR.getKey());
        this.getCollection(listModelMap3, tableLine.getVendor()).remove(tableLine);
    }

    private Collection getAllValues(Object object) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof Map) {
            HashSet hashSet = new HashSet();
            Iterator iterator = ((Map)object).values().iterator();
            while (iterator.hasNext()) {
                hashSet.addAll(this.getAllValues(iterator.next()));
            }
            return hashSet;
        }
        throw new IllegalArgumentException("parent: " + object);
    }

    private ListModelMap getMap(Map map, Object object) {
        ListModelMap listModelMap = (ListModelMap)map.get(object);
        if (listModelMap == null) {
            listModelMap = new Model(Comparators.caseInsensitiveStringComparator());
            map.put(object, listModelMap);
        }
        return listModelMap;
    }

    private ListModelMap getMapNatural(Map map, Object object) {
        ListModelMap listModelMap = (ListModelMap)map.get(object);
        if (listModelMap == null) {
            listModelMap = new Model();
            map.put(object, listModelMap);
        }
        return listModelMap;
    }

    private Collection getCollection(Map map, Object object) {
        HashSet hashSet;
        if (object instanceof String) {
            object = ((String)object).trim();
        }
        if ((hashSet = (HashSet)map.get(object)) == null) {
            hashSet = new HashSet();
            map.put(object, hashSet);
        }
        return hashSet;
    }

    static boolean isAll(Object object) {
        return object instanceof All;
    }

    private static class All {
        private static final String ALL = I18n.tr("All") + " (";
        final int number;

        private All(int n) {
            this.number = n;
        }

        public String toString() {
            return ALL + this.number + ")";
        }
    }

    private static class SimpleListModel
    extends AbstractListModel {
        private SimpleListModel() {
        }

        public int getSize() {
            throw new IllegalStateException();
        }

        public Object getElementAt(int n) {
            throw new IllegalStateException();
        }

        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }

    private static class Model
    extends TreeMap
    implements ListModelMap {
        private final SimpleListModel DELEGATE = new SimpleListModel();

        Model() {
        }

        Model(Comparator comparator) {
            super(comparator);
        }

        public Object put(Object object, Object object2) {
            Object object3 = super.put(object, object2);
            this.DELEGATE.fireContentsChanged(this, 0, this.size());
            return object3;
        }

        public void fireContentsChanged() {
            this.DELEGATE.fireContentsChanged(this, 0, this.size());
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.DELEGATE.addListDataListener(listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.DELEGATE.removeListDataListener(listDataListener);
        }

        public int getSize() {
            return this.size() + 1;
        }

        public Object getElementAt(int n) {
            if (n == 0) {
                return new All(this.size());
            }
            if (n > this.size()) {
                throw new IndexOutOfBoundsException("index: " + n + ", size: " + this.getSize());
            }
            Iterator iterator = this.keySet().iterator();
            for (int i = 1; i < n; ++i) {
                iterator.next();
            }
            return iterator.next();
        }

        public boolean contains(Object object) {
            if (MetadataModel.isAll(object)) {
                return true;
            }
            return this.containsKey(object);
        }

        public int indexOf(Object object) {
            if (MetadataModel.isAll(object)) {
                return 0;
            }
            Iterator iterator = this.keySet().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                if (this.compare(object, iterator.next()) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public Iterator iterator() {
            return this.keySet().iterator();
        }

        private int compare(Object object, Object object2) {
            return this.comparator() == null ? ((Comparable)object).compareTo(object2) : this.comparator().compare(object, object2);
        }
    }
}

