/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GnutellaSearchResult
extends AbstractSearchResult {
    private final RemoteFileDesc RFD;
    private final HostData DATA;
    private Set<IpPort> _alts;

    GnutellaSearchResult(RemoteFileDesc remoteFileDesc, HostData hostData, Set<IpPort> set) {
        this.RFD = remoteFileDesc;
        this.DATA = hostData;
        this._alts = UISettings.UI_ADD_REPLY_ALT_LOCS.getValue() ? set : Collections.emptySet();
    }

    @Override
    public boolean canBeMarkedAsJunk() {
        return true;
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RFD;
    }

    HostData getHostData() {
        return this.DATA;
    }

    Set<IpPort> getAlts() {
        return this._alts;
    }

    void clearAlts() {
        this._alts = null;
    }

    void setAlts(Set<IpPort> set) {
        this._alts = set;
    }

    @Override
    public String getFileName() {
        return this.RFD.getFileName();
    }

    @Override
    public long getSize() {
        return this.RFD.getSize();
    }

    @Override
    public URN getSHA1Urn() {
        return this.RFD.getSHA1Urn();
    }

    @Override
    public LimeXMLDocument getXMLDocument() {
        return this.RFD.getXMLDocument();
    }

    @Override
    public long getCreationTime() {
        return this.RFD.getCreationTime();
    }

    @Override
    public boolean isDownloading() {
        return this.RFD.isDownloading();
    }

    @Override
    public String getVendor() {
        return this.RFD.getVendor();
    }

    @Override
    public int getQuality() {
        return this.RFD.getQuality();
    }

    @Override
    public int getSecureStatus() {
        return this.RFD.getSecureStatus();
    }

    @Override
    public int getSpeed() {
        return this.DATA.getSpeed();
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public float getSpamRating() {
        return this.RFD.getSpamRating();
    }

    @Override
    public String getHost() {
        return this.RFD.getHost();
    }

    @Override
    public Color getEvenRowColor() {
        return ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
    }

    @Override
    public Color getOddRowColor() {
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    @Override
    public void takeAction(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        SearchMediator.downloadGnutellaLine(tableLine, gUID, file, string, bl, searchInformation);
    }

    @Override
    public void initialize(TableLine tableLine) {
        RemoteFileDesc remoteFileDesc = this.getRemoteFileDesc();
        Set<IpPort> set = this.getAlts();
        if (remoteFileDesc.isChatEnabled()) {
            tableLine.setChatHost(remoteFileDesc);
        }
        if (remoteFileDesc.isBrowseHostEnabled()) {
            tableLine.setBrowseHost(remoteFileDesc);
        }
        if (!remoteFileDesc.isFirewalled()) {
            tableLine.setNonFirewalledHost(remoteFileDesc);
        }
        tableLine.createEndpointHolder(remoteFileDesc.getHost(), remoteFileDesc.getPort(), remoteFileDesc.isReplyToMulticast());
        tableLine.setAddedOn(remoteFileDesc.getCreationTime());
        if (set != null && !set.isEmpty()) {
            Set<IpPort> set2 = tableLine.getAltIpPortSet();
            set2.addAll(set);
            this.clearAlts();
            tableLine.getLocation().addHosts(set);
        }
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, TableLine[] tableLineArray, boolean bl, boolean bl2, ResultPanel resultPanel) {
        PopupUtils.addMenuItem(I18n.tr("Buy this item now"), resultPanel.BUY_LISTENER, jPopupMenu, tableLineArray.length == 1, 0);
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, resultPanel.DOWNLOAD_LISTENER, jPopupMenu, tableLineArray.length > 0, 1);
        PopupUtils.addMenuItem(I18n.tr("Download As..."), resultPanel.DOWNLOAD_AS_LISTENER, jPopupMenu, tableLineArray.length == 1, 2);
        PopupUtils.addMenuItem(I18n.tr("View License"), (ActionListener)new LicenseListener(resultPanel), jPopupMenu, tableLineArray.length > 0 && tableLineArray[0].isLicenseAvailable(), 3);
        PopupUtils.addMenuItem(SearchMediator.CHAT_STRING, resultPanel.CHAT_LISTENER, jPopupMenu, tableLineArray.length > 0 && tableLineArray[0].isChatEnabled(), 4);
        PopupUtils.addMenuItem(SearchMediator.BROWSE_HOST_STRING, resultPanel.BROWSE_HOST_LISTENER, jPopupMenu, tableLineArray.length > 0 && tableLineArray[0].isBrowseHostEnabled(), 5);
        PopupUtils.addMenuItem(SearchMediator.BLOCK_STRING, (ActionListener)new BlockListener(resultPanel), jPopupMenu, tableLineArray.length > 0, 6);
        JMenu jMenu = new JMenu(SearchMediator.MARK_AS_STRING);
        jMenu.setEnabled(bl || bl2);
        PopupUtils.addMenuItem(SearchMediator.SPAM_STRING, resultPanel.MARK_AS_SPAM_LISTENER, jMenu, bl);
        PopupUtils.addMenuItem(SearchMediator.NOT_SPAM_STRING, resultPanel.MARK_AS_NOT_SPAM_LISTENER, jMenu, bl2);
        jPopupMenu.add((Component)jMenu, 6);
        jPopupMenu.add((Component)new JPopupMenu.Separator(), 7);
        jPopupMenu.add((Component)this.createAdvancedMenu(tableLineArray.length > 0 ? tableLineArray[0] : null, resultPanel), 8);
        return jPopupMenu;
    }

    private JMenu createAdvancedMenu(TableLine tableLine, ResultPanel resultPanel) {
        JMenu jMenu = new JMenu(I18n.tr("Advanced"));
        if (tableLine == null) {
            jMenu.setEnabled(false);
            return jMenu;
        }
        BitziLookupAction bitziLookupAction = new BitziLookupAction(resultPanel);
        bitziLookupAction.setEnabled(tableLine.getRemoteFileDesc().getSHA1Urn() != null);
        jMenu.add(new JMenuItem(bitziLookupAction));
        CopyMagnetLinkToClipboardAction copyMagnetLinkToClipboardAction = new CopyMagnetLinkToClipboardAction(resultPanel);
        copyMagnetLinkToClipboardAction.setEnabled(tableLine.hasNonFirewalledRFD());
        jMenu.add(new JMenuItem(copyMagnetLinkToClipboardAction));
        if (tableLine.isLaunchable()) {
            jMenu.addSeparator();
            PopupUtils.addMenuItem(SearchMediator.LAUNCH_STRING, resultPanel.DOWNLOAD_LISTENER, jMenu.getPopupMenu(), true);
        }
        return jMenu;
    }

    private static class BlockListener
    implements ActionListener {
        private final ResultPanel p;

        BlockListener(ResultPanel resultPanel) {
            this.p = resultPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.p.blockHost();
        }
    }

    private static class LicenseListener
    implements ActionListener {
        private final ResultPanel p;

        LicenseListener(ResultPanel resultPanel) {
            this.p = resultPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.p.showLicense();
        }
    }
}

