/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;

class CompositeFilter
implements TableLineFilter {
    private TableLineFilter[] delegates;

    CompositeFilter(int n) {
        this.delegates = new TableLineFilter[n];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i] = AllowFilter.instance();
        }
    }

    public boolean allow(TableLine tableLine) {
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i].allow(tableLine)) continue;
            return false;
        }
        return true;
    }

    boolean setFilter(int n, TableLineFilter tableLineFilter) {
        if (tableLineFilter == this) {
            throw new IllegalArgumentException("Filter must not be composed of itself");
        }
        if (this.delegates[n].equals(tableLineFilter)) {
            return false;
        }
        this.delegates[n] = tableLineFilter;
        return true;
    }
}

