/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.NumberCell;
import com.limegroup.gnutella.gui.playlist.NumberTableCellRenderer;
import com.limegroup.gnutella.gui.playlist.PlaylistButtons;
import com.limegroup.gnutella.gui.playlist.PlaylistDataLine;
import com.limegroup.gnutella.gui.playlist.PlaylistItemName;
import com.limegroup.gnutella.gui.playlist.PlaylistItemNameRendererEditor;
import com.limegroup.gnutella.gui.playlist.PlaylistModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaylistMediator
extends AbstractTableMediator<PlaylistModel, PlaylistDataLine, PlayListItem>
implements ThemeObserver {
    private static final Log LOG = LogFactory.getLog(PlaylistMediator.class);
    private static final PlaylistMediator INSTANCE = new PlaylistMediator();
    private PlaylistItemNameRendererEditor STORE_RENDERER;
    private NumberTableCellRenderer TABLE_NUMBER_RENDERER;
    private final Object PLAY_LOCK = new Object();
    private boolean isContinuous = true;
    private File lastOpenedPlaylist;
    private File lastSavedPlaylist;
    ActionListener LOAD_LISTENER;
    ActionListener SAVE_LISTENER;
    ActionListener CLEAR_LISTENER;
    ActionListener CONTINUOUS_LISTENER;
    ActionListener SHUFFLE_LISTENER;
    private PlaylistModel MODEL;

    private PlaylistMediator() {
        super("PLAYLIST_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    public static PlaylistMediator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.LOAD_LISTENER = new LoadListener();
        this.SAVE_LISTENER = new SaveListener();
        this.CLEAR_LISTENER = new ClearListener();
        this.CONTINUOUS_LISTENER = new ContinuousListener();
        this.SHUFFLE_LISTENER = new ShuffleListener();
        this.REMOVE_LISTENER = new RemoveListener();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(I18n.tr("Playlist"));
        this.MODEL = new PlaylistModel();
        this.DATA_MODEL = this.MODEL;
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new PlaylistButtons(this).getComponent();
        this.STORE_RENDERER = new PlaylistItemNameRendererEditor();
        this.TABLE_NUMBER_RENDERER = new NumberTableCellRenderer();
    }

    @Override
    public void updateTheme() {
        super.updateTheme();
        this.STORE_RENDERER.updateTheme();
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Playlist Window..."));
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        return null;
    }

    @Override
    protected void setupMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.getScrolledTablePane(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add(Box.createVerticalStrut(6), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.buildOptionsPanel(), gridBagConstraints);
        this.MAIN_PANEL.add(jPanel);
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        this.setButtonEnabled(3, false);
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(NumberCell.class, this.TABLE_NUMBER_RENDERER);
    }

    @Override
    protected void setDefaultEditors() {
        super.setDefaultEditors();
        this.TABLE.setDefaultRenderer(PlaylistItemName.class, this.STORE_RENDERER);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new PlaylistFileTransferHandler());
    }

    @Override
    public void handleSelection(int n) {
        this.setButtonEnabled(2, true);
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(2, false);
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
    }

    @Override
    public void handleActionKey() {
        this.playSong();
    }

    public void setSelectedIndex(PlayListItem playListItem) {
        if (playListItem == null) {
            throw new NullPointerException();
        }
        this.MODEL.setCurrentSong(playListItem);
    }

    public PlayListItem getNextSong() {
        return this.getSongToPlay();
    }

    public List<PlayListItem> getSongs() {
        return this.MODEL.getSongs();
    }

    public PlayListItem getPrevSong() {
        this.MODEL.setBackwardsMode();
        return this.getSongToPlay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlayListItem getSongToPlay() {
        PlayListItem playListItem = null;
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            playListItem = this.MODEL.getNextSong();
        }
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.refresh();
                    int n = PlaylistMediator.this.MODEL.getCurrentSongIndex();
                    if (n >= 0) {
                        PlaylistMediator.this.TABLE.ensureRowVisible(n);
                    }
                }
                if (PlaylistMediator.this.TABLE.isEditing()) {
                    object = PlaylistMediator.this.TABLE.getCellEditor();
                    object.cancelCellEditing();
                }
            }
        });
        return playListItem;
    }

    public static List<PlayListItem> createItemList(File[] fileArray) {
        ArrayList<PlayListItem> arrayList = new ArrayList<PlayListItem>();
        for (File file : fileArray) {
            if (file == null) continue;
            if (PlaylistMediator.isPlayableFile(file)) {
                arrayList.add(new PlayListItem(file));
                continue;
            }
            if (!file.isDirectory()) continue;
            arrayList.addAll(PlaylistMediator.createItemList(file.listFiles()));
        }
        return arrayList;
    }

    public void addFilesToPlaylist(File[] fileArray) {
        this.addFilesToPlaylist(fileArray, -1);
    }

    public void addFilesToPlaylist(final File[] fileArray, final int n) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                PlaylistMediator.this.addFilesToPlayList(PlaylistMediator.createItemList(fileArray), n);
            }
        });
    }

    private void addFilesToPlayList(final List<PlayListItem> list, final int n) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    for (PlayListItem playListItem : list) {
                        PlaylistMediator.this.add(playListItem, n);
                    }
                }
                PlaylistMediator.this.setButtonEnabled(3, true);
            }
        });
    }

    public void addFileToPlaylist(URL uRL, String string, boolean bl, Map<String, String> map) {
        this.addFileToPlaylist(uRL, string, bl, map, -1);
    }

    public void addFileToPlaylist(final URL uRL, final String string, final boolean bl, final Map<String, String> map, final int n) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                try {
                    PlaylistMediator.this.addFileToPlayList(new PlayListItem(uRL.toURI(), new AudioSource(uRL), string, bl, map), n);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
    }

    public void addFileToPlaylist(File file) {
        this.addFileToPlaylist(file, -1);
    }

    public void addFileToPlaylist(final File file, final int n) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                PlaylistMediator.this.addFileToPlayList(new PlayListItem(file), n);
            }
        });
    }

    private void addFileToPlayList(final PlayListItem playListItem, final int n) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.add(playListItem, n);
                }
                PlaylistMediator.this.setButtonEnabled(3, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFileFromPlaylist(int n) {
        if (n < 0 || n > this.MODEL.getRowCount()) {
            return false;
        }
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            this.removeRow(n);
        }
        if (this.MODEL.getRowCount() <= 0) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    PlaylistMediator.this.setButtonEnabled(3, false);
                }
            });
        }
        return true;
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public boolean isEndOfList() {
        return this.isContinuous() && !this.MODEL.isShuffleSet() && this.MODEL.getCurrentSongIndex() == this.getSize() - 1;
    }

    public void playStarted() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                PlaylistMediator.this.refresh();
            }
        });
    }

    public void playComplete() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                PlaylistMediator.this.refresh();
            }
        });
    }

    private JPanel buildOptionsPanel() {
        JLabel jLabel = new JLabel(I18n.tr("Play Options:"));
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Shuffle"), false);
        jCheckBox.addActionListener(this.SHUFFLE_LISTENER);
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("Continuous"), true);
        jCheckBox2.addActionListener(this.CONTINUOUS_LISTENER);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(jCheckBox2);
        jPanel.add(jCheckBox);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.BUTTON_ROW, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    public static boolean isPlayableFile(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".mp3") || string.endsWith(".ogg") || string.endsWith(".wav");
    }

    private void playSong() {
        PlaylistDataLine playlistDataLine = (PlaylistDataLine)((PlaylistModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (playlistDataLine == null) {
            return;
        }
        PlayListItem playListItem = playlistDataLine.getPlayListItem();
        this.MODEL.setCurrentSong(playListItem);
        MediaPlayerComponent.getInstance().loadSong(playListItem);
    }

    public boolean openIfPlaylist(File file) {
        String string = file.getName().toLowerCase();
        if (!string.endsWith(".m3u")) {
            return false;
        }
        this.loadPlayListFile(file, false);
        return true;
    }

    private void loadPlaylist() {
        Object object;
        File file = null;
        if (this.lastOpenedPlaylist != null && (object = this.lastOpenedPlaylist.getParent()) != null) {
            file = new File((String)object);
        }
        if (file == null) {
            file = CommonUtils.getCurrentDirectory();
        }
        if ((object = FileChooserHandler.getInputFile((Component)this.getComponent(), I18nMarker.marktr("Open Playlist (.m3u)"), file, new PlaylistListFileFilter())) == null || !((File)object).isFile()) {
            return;
        }
        this.loadPlayListFile((File)object, false);
    }

    private void loadPlayListFile(File file, boolean bl) {
        String string = file.getPath();
        try {
            string = FileUtils.getCanonicalPath(file);
        }
        catch (IOException iOException) {
            LOG.warn("unable to get canonical path for file: " + file, iOException);
        }
        this.loadPlaylist(file, string, bl);
    }

    private void loadPlaylist(final File file, final String string, final boolean bl) {
        BackgroundExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final PlayList playList = new PlayList(string);
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.lastOpenedPlaylist = file;
                    if (bl) {
                        PlaylistMediator.this.clearTable();
                    }
                    GUIMediator.safeInvokeLater(new Runnable(){

                        public void run() {
                            PlaylistMediator.this.MODEL.addSongs(playList);
                            if (PlaylistMediator.this.MODEL.getRowCount() > 0) {
                                PlaylistMediator.this.setButtonEnabled(3, true);
                            }
                        }
                    });
                }
            }
        });
    }

    private void savePlaylist() {
        Object object;
        File file = this.lastSavedPlaylist != null ? this.lastSavedPlaylist : (this.lastOpenedPlaylist != null ? this.lastOpenedPlaylist : new File(CommonUtils.getCurrentDirectory(), "frostwire.m3u"));
        File file2 = FileChooserHandler.getSaveAsFile(this.getComponent(), I18nMarker.marktr("Save Playlist As"), file, new PlaylistListFileFilter());
        if (file2 == null) {
            return;
        }
        if (file2.exists() && !file2.equals(this.lastOpenedPlaylist) && (object = GUIMediator.showYesNoMessage(I18n.tr("Warning: a file with the name {0} already exists in the folder. Overwrite this file?", file2.getName()), QuestionsHandler.PLAYLIST_OVERWRITE_OK, DialogOption.NO)) != DialogOption.YES) {
            return;
        }
        object = file2.getPath();
        try {
            object = FileUtils.getCanonicalPath(file2);
        }
        catch (IOException iOException) {
            LOG.warn("unable to get canonical path for file: " + file2, iOException);
        }
        if (!object.toLowerCase().endsWith(".m3u")) {
            object = object + ".m3u";
        }
        this.savePlaylist((String)object);
    }

    private void savePlaylist(final String string) {
        BackgroundExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PlayList playList = new PlayList(string);
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.lastSavedPlaylist = new File(string);
                    playList.setSongs(PlaylistMediator.this.MODEL.getLocalFiles());
                }
                try {
                    playList.save();
                }
                catch (IOException iOException) {
                    LOG.warn("Unable to save playlist", iOException);
                    GUIMediator.safeInvokeLater(new Runnable(){

                        public void run() {
                            GUIMediator.showError("Unable to save playlist");
                        }
                    });
                }
            }
        });
    }

    private void clearPlaylist() {
        this.MODEL.clear();
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PlaylistMediator.this.setButtonEnabled(3, false);
            }
        });
    }

    public static class PlaylistTransferable
    implements Transferable {
        public static final DataFlavor playlistFlavor = new DataFlavor(PlaylistTransferable.class, "FrostWire PlaylistTransfer");

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{playlistFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(playlistFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return null;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    private class PlaylistFileTransferHandler
    extends LimeTransferHandler {
        private static final long serialVersionUID = 8001846286940013099L;
        DataFlavor playlistFlavor;
        int removeIndex;
        int addIndex;

        public PlaylistFileTransferHandler() {
            super(0x40000003);
            this.playlistFlavor = new DataFlavor(PlaylistTransferable.class, "FrostWire PlaylistTransfer");
            this.removeIndex = -1;
            this.addIndex = -1;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
            return this.canImport(jComponent, dataFlavorArray);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return DNDUtils.containsFileFlavors(dataFlavorArray) || DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(jComponent, dataFlavorArray);
        }

        public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
            return this.importData(jComponent, transferable);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return false;
            }
            try {
                int n = ((JTable)jComponent).getSelectedRow();
                if (n < 0 || n > PlaylistMediator.this.MODEL.getRowCount()) {
                    n = PlaylistMediator.this.MODEL.getRowCount();
                }
                this.addIndex = n;
                if (n > this.removeIndex) {
                    ++n;
                }
                File[] fileArray = DNDUtils.getFiles(transferable);
                if (!DNDUtils.contains(transferable.getTransferDataFlavors(), this.playlistFlavor)) {
                    PlaylistMediator.this.addFilesToPlaylist(fileArray, n);
                }
                if (fileArray.length > 0) {
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(jComponent, transferable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Transferable createTransferable(JComponent jComponent) {
            Object object;
            if (PlaylistMediator.this.TABLE.isEditing()) {
                object = PlaylistMediator.this.TABLE.getCellEditor();
                object.cancelCellEditing();
            }
            object = PlaylistMediator.this.TABLE.getSelectedRows();
            ArrayList<File> arrayList = new ArrayList<File>(((Object)object).length);
            Object object2 = PlaylistMediator.this.PLAY_LOCK;
            synchronized (object2) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    arrayList.add(((PlaylistDataLine)PlaylistMediator.this.MODEL.get(object[i])).getFile());
                }
            }
            this.removeIndex = (int)object[0];
            return new CompositeTransferable(new PlaylistTransferable(), new FileTransferable(arrayList));
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                if ((this.removeIndex != -1 || this.addIndex != -1) && this.removeIndex >= 0 && this.addIndex >= 0 && this.removeIndex < PlaylistMediator.this.TABLE.getRowCount() && this.addIndex < PlaylistMediator.this.TABLE.getRowCount()) {
                    this.handleMove(this.removeIndex, this.addIndex);
                }
                this.removeIndex = -1;
                this.addIndex = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMove(int n, int n2) {
            Object object = PlaylistMediator.this.PLAY_LOCK;
            synchronized (object) {
                PlaylistMediator.this.moveRow(n, n2);
                PlaylistMediator.this.TABLE.setSelectedRow(n2);
            }
        }
    }

    private static class PlaylistListFileFilter
    extends FileFilter {
        private PlaylistListFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith("m3u");
        }

        public String getDescription() {
            return I18n.tr("Playlist Files (*.m3u)");
        }
    }

    private class ShuffleListener
    implements ActionListener {
        private ShuffleListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            PlaylistMediator.this.MODEL.setShuffle(abstractButton.isSelected());
        }
    }

    private class ContinuousListener
    implements ActionListener {
        private ContinuousListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            PlaylistMediator.this.isContinuous = abstractButton.isSelected();
        }
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlaylistMediator.this.clearPlaylist();
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlaylistMediator.this.savePlaylist();
        }
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlaylistMediator.this.loadPlaylist();
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlaylistMediator.this.removeSelection();
            if (PlaylistMediator.this.MODEL.getRowCount() <= 0) {
                PlaylistMediator.this.setButtonEnabled(3, false);
            }
        }
    }
}

