/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.NumberCell;
import com.limegroup.gnutella.gui.playlist.PlaylistItemName;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import java.awt.Color;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaylistDataLine
extends AbstractDataLine<PlayListItem>
implements FileTransfer {
    static final int NUMBER_IDX = 0;
    private static final LimeTableColumn NUMBER_COLUMN = new LimeTableColumn(0, "", I18n.tr("#"), 30, true, NumberCell.class);
    static final int NAME_IDX = 1;
    private static final LimeTableColumn NAME_COLUMN = new LimeTableColumn(1, "PLAYLIST_TABLE_NAME", I18n.tr("Name"), 700, true, PlaylistItemName.class);
    static final int ARTIST_IDX = 2;
    private static final LimeTableColumn ARTIST_COLUMN = new LimeTableColumn(2, "PLAYLIST_TABLE_ARTIST", I18n.tr("Artist"), 80, false, ColoredCell.class);
    static final int TITLE_IDX = 3;
    private static final LimeTableColumn TITLE_COLUMN = new LimeTableColumn(3, "PLAYLIST_TABLE_TITLE", I18n.tr("Title"), 80, false, ColoredCell.class);
    static final int LENGTH_IDX = 4;
    private static final LimeTableColumn LENGTH_COLUMN = new LimeTableColumn(4, "PLAYLIST_TABLE_LENGTH", I18n.tr("Length"), 150, true, ColoredCell.class);
    static final int ALBUM_IDX = 5;
    private static final LimeTableColumn ALBUM_COLUMN = new LimeTableColumn(5, "PLAYLIST_TABLE_ALBUM", I18n.tr("Album"), 120, false, ColoredCell.class);
    static final int TRACK_IDX = 6;
    private static final LimeTableColumn TRACK_COLUMN = new LimeTableColumn(6, "PLAYLIST_TABLE_TRACK", I18n.tr("Track"), 20, false, ColoredCell.class);
    static final int BITRATE_IDX = 7;
    private static final LimeTableColumn BITRATE_COLUMN = new LimeTableColumn(7, "PLAYLIST_TABLE_BITRATE", I18n.tr("Bitrate"), 60, true, ColoredCell.class);
    static final int COMMENT_IDX = 8;
    private static final LimeTableColumn COMMENT_COLUMN = new LimeTableColumn(8, "PLAYLIST_TABLE_COMMENT", I18n.tr("Comment"), 20, false, ColoredCell.class);
    static final int GENRE_IDX = 9;
    private static final LimeTableColumn GENRE_COLUMN = new LimeTableColumn(9, "PLAYLIST_TABLE_GENRE", I18n.tr("Genre"), 80, false, ColoredCell.class);
    static final int SIZE_IDX = 10;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(10, "PLAYLIST_TABLE_SIZE", I18n.tr("Size"), 80, false, ColoredCell.class);
    static final int TYPE_IDX = 11;
    private static final LimeTableColumn TYPE_COLUMN = new LimeTableColumn(11, "PLAYLIST_TABLE_TYPE", I18n.tr("Type"), 40, false, ColoredCell.class);
    static final int YEAR_IDX = 12;
    private static final LimeTableColumn YEAR_COLUMN = new LimeTableColumn(12, "PLAYLIST_TABLE_YEAR", I18n.tr("Year"), 30, false, ColoredCell.class);
    static final int NUMBER_OF_COLUMNS = 13;
    private Color _cellColor;
    private Color _othercellColor;
    private PlaylistItemName name;
    private SizeHolder holder;
    private static NumberCell numberCell = new NumberCell();

    @Override
    public int getColumnCount() {
        return 13;
    }

    @Override
    public void initialize(PlayListItem playListItem) {
        super.initialize(playListItem);
        this.name = new PlaylistItemName(this);
        this.holder = playListItem.getProperty("Size") != null ? new SizeHolder(Integer.parseInt(playListItem.getProperty("Size"))) : new SizeHolder(0L);
        this.updateTheme();
    }

    @Override
    public Object getValueAt(int n) {
        Color color = this.getColor(MediaPlayerComponent.getInstance().getCurrentSong() == this.initializer);
        switch (n) {
            case 5: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Album"), color);
            }
            case 2: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Artist"), color);
            }
            case 7: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("BitRate", ""), color);
            }
            case 8: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Comment"), color);
            }
            case 9: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Genre"), color);
            }
            case 4: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Time", ""), color);
            }
            case 1: {
                return this.name;
            }
            case 0: {
                return numberCell;
            }
            case 10: {
                return new ColoredCellImpl(this.holder, color);
            }
            case 3: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Title"), color);
            }
            case 6: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Track", ""), color);
            }
            case 11: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Type"), color);
            }
            case 12: {
                return new ColoredCellImpl(((PlayListItem)this.initializer).getProperty("Year"), color);
            }
        }
        return null;
    }

    protected Color getColor(boolean bl) {
        return bl ? this._othercellColor : this._cellColor;
    }

    public void updateTheme() {
        this._cellColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
        this._othercellColor = ThemeFileHandler.SEARCH_RESULT_SPEED_COLOR.getValue();
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        switch (n) {
            case 5: {
                return ALBUM_COLUMN;
            }
            case 2: {
                return ARTIST_COLUMN;
            }
            case 7: {
                return BITRATE_COLUMN;
            }
            case 8: {
                return COMMENT_COLUMN;
            }
            case 9: {
                return GENRE_COLUMN;
            }
            case 4: {
                return LENGTH_COLUMN;
            }
            case 1: {
                return NAME_COLUMN;
            }
            case 0: {
                return NUMBER_COLUMN;
            }
            case 10: {
                return SIZE_COLUMN;
            }
            case 3: {
                return TITLE_COLUMN;
            }
            case 6: {
                return TRACK_COLUMN;
            }
            case 11: {
                return TYPE_COLUMN;
            }
            case 12: {
                return YEAR_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int n) {
        return false;
    }

    @Override
    public int getTypeAheadColumn() {
        return 1;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public File getFile() {
        if (((PlayListItem)this.initializer).isFile()) {
            return new File(((PlayListItem)this.initializer).getURI());
        }
        return null;
    }

    public PlayListItem getPlayListItem() {
        return (PlayListItem)this.initializer;
    }

    public String getSongName() {
        return ((PlayListItem)this.initializer).getName();
    }

    @Override
    public String[] getToolTipArray(int n) {
        return ((PlayListItem)this.initializer).getToolTips();
    }
}

