/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.i18n.I18nMarker;

public final class UploadBandwidthPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Upload Bandwidth");
    public static final String LABEL = I18n.tr("You can set the percentage of your bandwidth devoted to uploads. To turn off uploads, reduce your upload slots to zero.");
    private final String LABEL_LABEL = I18nMarker.marktr("Upload Speed:");
    private final String SLIDER_MAX_LABEL = I18nMarker.marktr("Unlimited");
    private final JSlider UPLOAD_SLIDER = new JSlider(25, 100);
    private final JLabel SLIDER_LABEL = new JLabel();
    private int _uploadThrottle;

    public UploadBandwidthPaneItem() {
        super(TITLE, LABEL);
        this.UPLOAD_SLIDER.setMajorTickSpacing(10);
        this.UPLOAD_SLIDER.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        JLabel jLabel = new JLabel("10%");
        JLabel jLabel2 = new JLabel("100%");
        Font font = new Font("Helvetica", 1, 10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        hashtable.put(new Integer(10), jLabel);
        hashtable.put(new Integer(100), jLabel2);
        this.UPLOAD_SLIDER.setLabelTable(hashtable);
        this.UPLOAD_SLIDER.setPaintLabels(true);
        this.UPLOAD_SLIDER.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                UploadBandwidthPaneItem.this.handleThrottleLabel();
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent(this.LABEL_LABEL, this.SLIDER_LABEL, 120, 10);
        this.add(this.UPLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent.getComponent());
    }

    private void handleThrottleLabel() {
        float f = this.UPLOAD_SLIDER.getValue();
        String string = "";
        if (f == 100.0f) {
            string = I18n.tr(this.SLIDER_MAX_LABEL);
        } else {
            Float f2 = new Float((double)this.UPLOAD_SLIDER.getValue() / 100.0 * (double)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            string = String.valueOf(numberFormat.format(f2)) + " KB/s";
        }
        this.SLIDER_LABEL.setText(string);
    }

    public void initOptions() {
        this._uploadThrottle = UploadSettings.UPLOAD_SPEED.getValue();
        this.UPLOAD_SLIDER.setValue(this._uploadThrottle);
        this.handleThrottleLabel();
    }

    public boolean applyOptions() throws IOException {
        int n = this.UPLOAD_SLIDER.getValue();
        if (n != this._uploadThrottle) {
            UploadSettings.UPLOAD_SPEED.setValue(n);
            this._uploadThrottle = n;
            GuiCoreMediator.getBandwidthManager().applyRate();
        }
        return false;
    }

    public boolean isDirty() {
        return UploadSettings.UPLOAD_SPEED.getValue() != this.UPLOAD_SLIDER.getValue();
    }
}

