/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComboBox;
import org.limewire.i18n.I18nMarker;

public final class SpeedPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Connection Speed");
    public static final String LABEL = I18n.tr("You can specify your connection speed so that FrostWire can optimize performance.");
    private final String[] SPEED_MENU_ITEMS = new String[]{GUIConstants.MODEM_SPEED, GUIConstants.CABLE_SPEED, GUIConstants.T1_SPEED, GUIConstants.T3_SPEED};
    private final String OPTION_LABEL = I18nMarker.marktr("Speed:");
    private final JComboBox SPEED_BOX = new JComboBox<String>(this.SPEED_MENU_ITEMS);
    private String _speed;

    public SpeedPaneItem() {
        super(TITLE, LABEL);
        this.SPEED_BOX.setMaximumSize(new Dimension(10, 25));
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this.SPEED_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._speed = this.getSpeedString(ConnectionSettings.CONNECTION_SPEED.getValue());
        this.SPEED_BOX.setSelectedItem(this._speed);
    }

    public boolean applyOptions() throws IOException {
        String string = (String)this.SPEED_BOX.getSelectedItem();
        if (string != null && !string.equals(this._speed)) {
            int n = this.getSpeedInt(string);
            if (n < 0 || 20000 < n) {
                throw new IllegalArgumentException();
            }
            ConnectionSettings.CONNECTION_SPEED.setValue(n);
            this._speed = string;
        }
        return false;
    }

    public boolean isDirty() {
        String string = (String)this.SPEED_BOX.getSelectedItem();
        return string != null && ConnectionSettings.CONNECTION_SPEED.getValue() != this.getSpeedInt(string);
    }

    private String getSpeedString(int n) {
        String string = n == 56 ? GUIConstants.MODEM_SPEED : (n == 350 ? GUIConstants.CABLE_SPEED : (n == 1000 ? GUIConstants.T1_SPEED : (n == 3000 ? GUIConstants.T3_SPEED : GUIConstants.CABLE_SPEED)));
        return string;
    }

    private int getSpeedInt(String string) {
        int n = string.equals(GUIConstants.MODEM_SPEED) ? 56 : (string.equals(GUIConstants.CABLE_SPEED) ? 350 : (string.equals(GUIConstants.T1_SPEED) ? 1000 : (string.equals(GUIConstants.T3_SPEED) ? 3000 : 350)));
        return n;
    }
}

