/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.RemoveSharedDirectoryAction;
import com.limegroup.gnutella.gui.actions.SelectSharedDirectoryAction;
import com.limegroup.gnutella.gui.library.RecursiveSharingPanel;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharedDirPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shared Folders");
    public static final String LABEL = I18n.tr("You can choose the folders for sharing files. Files in these folders are displayed in the library.");
    private final RecursiveSharingPanel sharingPanel = new RecursiveSharingPanel(new File[0]);
    private Set<File> initialFoldersToShare;
    private Set<File> initialFoldersToExclude;

    public SharedDirPaneItem() {
        super(TITLE, LABEL);
        this.sharingPanel.setFileFilter(new FileFilter(){
            private final FileManager fileManager = GuiCoreMediator.getFileManager();

            public boolean accept(File file) {
                return this.fileManager.isFolderShareable(file, false);
            }
        });
        this.sharingPanel.getTree().setRootVisible(false);
        this.sharingPanel.getTree().setShowsRootHandles(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JButton(new SelectSharedDirectoryAction(this.sharingPanel, this.sharingPanel)), "North");
        jPanel2.add(Box.createVerticalStrut(4), "Center");
        jPanel2.add((Component)new JButton(new RemoveSharedDirectoryAction(this.sharingPanel)), "South");
        jPanel.add((Component)jPanel2, "North");
        this.sharingPanel.addEastPanel(jPanel);
        this.add(this.sharingPanel);
    }

    void addAndKeepDirtyStatus(Set<File> set, Set<File> set2) {
        for (File file : set) {
            this.sharingPanel.addRoot(file);
        }
        this.sharingPanel.addFoldersToExclude(set2);
    }

    boolean isAlreadyGoingToBeShared(File file) {
        if (this.sharingPanel.getFoldersToExclude().contains(file)) {
            return false;
        }
        for (File file2 : this.sharingPanel.getRootsToShare()) {
            if (!FileUtils.isAncestor(file2, file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initOptions() {
        File[] fileArray = SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray();
        this.initialFoldersToShare = new HashSet<File>(Arrays.asList(fileArray));
        this.initialFoldersToExclude = GuiCoreMediator.getFileManager().getFolderNotToShare();
        this.sharingPanel.setRoots(fileArray);
        this.sharingPanel.setFoldersToExclude(this.initialFoldersToExclude);
    }

    public Set<File> getDirectoriesToShare() {
        return this.sharingPanel.getRootsToShare();
    }

    public Set<File> getDirectorieToExclude() {
        return this.sharingPanel.getFoldersToExclude();
    }

    @Override
    public boolean applyOptions() throws IOException {
        return false;
    }

    @Override
    public boolean isDirty() {
        return !((Object)this.initialFoldersToShare).equals(this.sharingPanel.getRootsToShare()) || !((Object)this.initialFoldersToExclude).equals(this.sharingPanel.getFoldersToExclude());
    }

    public void resetDirtyState() {
        this.initialFoldersToShare = this.sharingPanel.getRootsToShare();
        this.initialFoldersToExclude = this.sharingPanel.getFoldersToExclude();
    }
}

