/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.i18n.I18nMarker;

public class ShareSpeciallyPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Download Sharing");
    public static final String LABEL = I18n.tr("You can share files that you download to unshared folders.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Share Finished Downloads:");
    private final JLabel explanationLabel = new JLabel();
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public ShareSpeciallyPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
        this.explanationLabel.setFont(this.explanationLabel.getFont().deriveFont(Math.max((float)this.explanationLabel.getFont().getSize() - 2.0f, 9.0f)).deriveFont(0));
        this.CHECK_BOX.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ShareSpeciallyPaneItem.this.setExplanationText();
            }
        });
        this.setExplanationText();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.explanationLabel, "East");
        this.add(jPanel);
    }

    private void setExplanationText() {
        if (this.CHECK_BOX.isSelected()) {
            this.explanationLabel.setText(I18n.tr("All downloads will be shared."));
        } else {
            this.explanationLabel.setText(I18n.tr("Only downloads in shared folders will be shared."));
        }
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue());
    }

    public boolean applyOptions() throws IOException {
        SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    public boolean isDirty() {
        return SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue() != this.CHECK_BOX.isSelected();
    }
}

