/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.UploadSettings;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;

public final class PerPersonUploadsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Uploads Per Person");
    public static final String LABEL = I18n.tr("Allow this many uploads per person.");
    private final String OPTION_LABEL = I18nMarker.marktr("Uploads Per Person:");
    private WholeNumberField _maxUploadsField = new SizedWholeNumberField();
    private int _maximumUploads;

    public PerPersonUploadsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this._maxUploadsField, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._maximumUploads = UploadSettings.UPLOADS_PER_PERSON.getValue();
        this._maxUploadsField.setValue(this._maximumUploads);
    }

    public boolean applyOptions() throws IOException {
        int n = this._maxUploadsField.getValue();
        if (n != this._maximumUploads) {
            UploadSettings.UPLOADS_PER_PERSON.setValue(n);
            this._maximumUploads = n;
        }
        return false;
    }

    public boolean isDirty() {
        return UploadSettings.UPLOADS_PER_PERSON.getValue() != this._maxUploadsField.getValue();
    }
}

