/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import java.io.IOException;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public class ImageViewerPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Image Options");
    public static final String LABEL = I18n.tr("You can choose which image viewer to use.");
    private final String OPTION_LABEL = I18nMarker.marktr("Image Viewer");
    private JTextField _viewerField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public ImageViewerPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this._viewerField);
        this.add(labeledComponent.getComponent());
    }

    public boolean applyOptions() throws IOException {
        URLHandlerSettings.IMAGE_VIEWER.setValue(this._viewerField.getText());
        return false;
    }

    public boolean isDirty() {
        return !URLHandlerSettings.IMAGE_VIEWER.getValue().equals(this._viewerField.getText());
    }

    public void initOptions() {
        this._viewerField.setText(URLHandlerSettings.IMAGE_VIEWER.getValue());
    }
}

