/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedPasswordField;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DaapSettings;
import de.kapsi.net.daap.DaapUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class DaapPasswordPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Password Protection");
    public static final String LABEL = I18n.tr("You can limit the access to this service with a password.");
    private final String PASSWORD_CHECK_BOX_LABEL = I18nMarker.marktr("Require Password:");
    private final String PASSWORD_BOX_LABEL = I18nMarker.marktr("Password:");
    private final JCheckBox REQUIRE_USERNAME_CHECK_BOX = new JCheckBox();
    private final JCheckBox REQUIRE_PASSWORD_CHECK_BOX = new JCheckBox();
    private final JTextField USERNAME = new SizedTextField(16, new Dimension(32, 20));
    private final JTextField PASSWORD = new SizedPasswordField(16, new Dimension(32, 20));

    public DaapPasswordPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.PASSWORD_CHECK_BOX_LABEL, this.REQUIRE_PASSWORD_CHECK_BOX, 120, 10);
        LabeledComponent labeledComponent2 = new LabeledComponent(this.PASSWORD_BOX_LABEL, this.PASSWORD, 120, 10);
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent2.getComponent());
        this.REQUIRE_USERNAME_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DaapPasswordPaneItem.this.enable();
            }
        });
        this.REQUIRE_PASSWORD_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DaapPasswordPaneItem.this.enable();
            }
        });
    }

    private void enable() {
        this.PASSWORD.setEnabled(this.REQUIRE_PASSWORD_CHECK_BOX.isSelected());
        this.REQUIRE_USERNAME_CHECK_BOX.setEnabled(this.REQUIRE_PASSWORD_CHECK_BOX.isSelected());
        if (!this.REQUIRE_PASSWORD_CHECK_BOX.isSelected()) {
            this.REQUIRE_USERNAME_CHECK_BOX.setSelected(false);
        }
        this.USERNAME.setEnabled(this.REQUIRE_USERNAME_CHECK_BOX.isSelected() && this.REQUIRE_PASSWORD_CHECK_BOX.isSelected());
    }

    public void initOptions() {
        this.REQUIRE_USERNAME_CHECK_BOX.setSelected(DaapSettings.DAAP_REQUIRES_USERNAME.getValue());
        this.REQUIRE_PASSWORD_CHECK_BOX.setSelected(DaapSettings.DAAP_REQUIRES_PASSWORD.getValue());
        if (this.REQUIRE_USERNAME_CHECK_BOX.isSelected()) {
            this.USERNAME.setText(DaapSettings.DAAP_USERNAME.getValue());
        }
        if (this.REQUIRE_PASSWORD_CHECK_BOX.isSelected()) {
            this.PASSWORD.setText(DaapSettings.DAAP_PASSWORD.getValue());
        }
        this.enable();
    }

    public boolean applyOptions() throws IOException {
        boolean bl = DaapSettings.DAAP_REQUIRES_USERNAME.getValue();
        String string = DaapSettings.DAAP_USERNAME.getValue();
        boolean bl2 = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
        String string2 = DaapSettings.DAAP_PASSWORD.getValue();
        boolean bl3 = this.REQUIRE_USERNAME_CHECK_BOX.isSelected();
        String string3 = this.USERNAME.getText().trim();
        boolean bl4 = this.REQUIRE_PASSWORD_CHECK_BOX.isSelected();
        String string4 = this.PASSWORD.getText().trim();
        if (string3.equals("") && bl3) {
            throw new IOException();
        }
        if (string4.equals("") && bl4) {
            throw new IOException();
        }
        if (!DaapSettings.DAAP_USERNAME.getValue().equals(string3)) {
            DaapSettings.DAAP_USERNAME.setValue(string3);
        }
        if (!DaapSettings.DAAP_PASSWORD.equals(string4)) {
            DaapSettings.DAAP_PASSWORD.setValue(string4);
        }
        if (bl3) {
            string4 = DaapUtil.calculateHA1(string3, string4);
        }
        if (bl4 != bl2 || bl4 && !string4.equals(string2)) {
            DaapSettings.DAAP_REQUIRES_USERNAME.setValue(bl3);
            DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(bl4);
            try {
                if (bl4) {
                    DaapManager.instance().disconnectAll();
                }
                DaapManager.instance().updateService();
            }
            catch (IOException iOException) {
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(bl);
                DaapSettings.DAAP_USERNAME.setValue(string);
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(bl2);
                DaapSettings.DAAP_PASSWORD.setValue(string2);
                DaapManager.instance().stop();
                this.initOptions();
                throw iOException;
            }
        }
        return false;
    }

    public boolean isDirty() {
        return DaapSettings.DAAP_REQUIRES_PASSWORD.getValue() != this.REQUIRE_PASSWORD_CHECK_BOX.isSelected() || DaapSettings.DAAP_REQUIRES_USERNAME.getValue() != this.REQUIRE_USERNAME_CHECK_BOX.isSelected() || !DaapSettings.DAAP_PASSWORD.equals(this.PASSWORD.getText().trim()) || !DaapSettings.DAAP_USERNAME.getValue().equals(this.USERNAME.getText().trim());
    }
}

