/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ChatSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class ChatActivePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Host Communication");
    public static final String TITLE_CHAT_CONFIGURATION = I18n.tr("Chat Configuration");
    public static final String LABEL = I18n.tr("You can turn chat on or off.");
    public static final String LABEL_CHAT_CONFIGURATION = I18n.tr("Please enter any name to continue, it will be used in the Chatrooms");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Enable Chat:");
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private JTextField _ircNickField;

    public ChatActivePaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(ChatSettings.CHAT_ENABLED.getValue());
    }

    public boolean applyOptions() throws IOException {
        ChatSettings.CHAT_ENABLED.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    public boolean isDirty() {
        return ChatSettings.CHAT_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

