/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.options.OptionsTreeModel;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.OptionsTreeSelectionListener;
import com.limegroup.gnutella.gui.trees.FilteredTreeModel;
import com.limegroup.gnutella.gui.trees.LimeTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

final class OptionsTreeManager {
    private final JScrollPane SCROLL_PANE;
    private final JTree TREE;
    private final OptionsTreeModel TREE_MODEL = new OptionsTreeModel();
    private final FilteredTreeModel FILTERED_TREE_MODEL = new FilteredTreeModel(this.TREE_MODEL, true);

    OptionsTreeManager() {
        this.TREE = new JTree();
        this.TREE.setEditable(false);
        this.TREE.setShowsRootHandles(true);
        this.TREE.setRootVisible(false);
        this.TREE.putClientProperty("JTree.lineStyle", "None");
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.addTreeSelectionListener(new OptionsTreeSelectionListener(this.TREE));
        this.TREE.setCellRenderer(new LimeTreeCellRenderer());
        this.TREE.setModel(this.FILTERED_TREE_MODEL);
        this.SCROLL_PANE = new JScrollPane(this.TREE);
        this.SCROLL_PANE.getViewport().setBackground(Color.white);
        this.SCROLL_PANE.setPreferredSize(new Dimension(125, 2000));
        this.SCROLL_PANE.setMinimumSize(new Dimension(125, 300));
    }

    final OptionsTreeNode addNode(String string, String string2, String string3, String string4) {
        OptionsTreeNode optionsTreeNode = this.TREE_MODEL.addNode(string, string2, string3);
        assert (optionsTreeNode != null);
        if (string4 != null) {
            String[] stringArray;
            for (String string5 : stringArray = StringUtils.split(I18NConvert.instance().getNorm(string4), " \".,';:()[]")) {
                this.FILTERED_TREE_MODEL.addSearchKey(optionsTreeNode, string5);
            }
        }
        return optionsTreeNode;
    }

    final Component getComponent() {
        return this.SCROLL_PANE;
    }

    void setSelection(String string) {
        if (string == null) {
            return;
        }
        OptionsTreeNode optionsTreeNode = (OptionsTreeNode)this.TREE_MODEL.getRoot();
        OptionsTreeNode optionsTreeNode2 = null;
        Enumeration<TreeNode> enumeration = optionsTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            optionsTreeNode2 = (OptionsTreeNode)enumeration.nextElement();
            if (!string.equals(optionsTreeNode2.getTitleKey())) continue;
            TreePath treePath = new TreePath(optionsTreeNode2.getPath());
            this.TREE.expandPath(treePath);
            this.TREE.scrollPathToVisible(treePath);
            this.TREE.setSelectionPath(treePath);
            return;
        }
    }

    void setDefaultSelection() {
        OptionsTreeNode optionsTreeNode = (OptionsTreeNode)this.TREE_MODEL.getRoot();
        if (optionsTreeNode == null) {
            return;
        }
        OptionsTreeNode optionsTreeNode2 = null;
        Enumeration<TreeNode> enumeration = optionsTreeNode.children();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        optionsTreeNode2 = (OptionsTreeNode)enumeration.nextElement();
        if (optionsTreeNode2 == null) {
            return;
        }
        TreePath treePath = new TreePath(optionsTreeNode2.getPath());
        this.TREE.scrollPathToVisible(treePath);
        this.TREE.setSelectionPath(treePath);
        this.TREE.collapsePath(treePath);
    }

    void setFilterText(String string) {
        TreePath treePath = this.TREE.getSelectionPath();
        boolean bl = this.TREE.isCollapsed(treePath);
        this.FILTERED_TREE_MODEL.filterByText(string);
        if (string.length() > 0) {
            this.expandAllNodes();
        } else {
            this.collapseAllNodes();
        }
        if (treePath != null) {
            this.TREE.setSelectionPath(treePath);
            if (string.length() == 0) {
                if (bl) {
                    this.TREE.collapsePath(treePath);
                } else {
                    this.TREE.expandPath(treePath);
                }
            }
            this.TREE.scrollPathToVisible(treePath);
        }
    }

    private void expandAllNodes() {
        for (int i = this.TREE_MODEL.getChildCount(this.TREE_MODEL.getRoot()) - 1; i >= 0; --i) {
            Object[] objectArray = new Object[]{this.TREE_MODEL.getRoot(), this.TREE_MODEL.getChild(this.TREE_MODEL.getRoot(), i)};
            this.TREE.expandPath(new TreePath(objectArray));
        }
    }

    private void collapseAllNodes() {
        for (int i = this.TREE_MODEL.getChildCount(this.TREE_MODEL.getRoot()) - 1; i >= 0; --i) {
            Object[] objectArray = new Object[]{this.TREE_MODEL.getRoot(), this.TREE_MODEL.getChild(this.TREE_MODEL.getRoot(), i)};
            this.TREE.collapsePath(new TreePath(objectArray));
        }
    }
}

