/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.MediaSlider;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerEvent;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.LimeWirePlayer;
import com.limegroup.gnutella.gui.mp3.MediaPlayerPanel;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.mp3.PlayerState;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.Tagged;
import com.limegroup.gnutella.util.URLDecoder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.service.ErrorService;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaPlayerComponent
implements AudioPlayerListener,
RefreshListener,
ThemeObserver {
    private static final Log LOG = LogFactory.getLog(MediaPlayerComponent.class);
    private static final String MP3 = "mp3";
    private static final String WAVE = "wave";
    public static final String STREAMING_AUDIO = "Streaming Audio";
    private static MediaPlayerComponent INSTANCE = null;
    private static final long SCROLL_RATE = 200L;
    private static final int STRING_SIZE_TO_SHOW = 20;
    public final int fullSizeWidth = 351;
    public final int minWidth = 240;
    private static final MediaButton PLAY_BUTTON = new MediaButton(I18n.tr("Play"), "play_up", "play_dn");
    private static final MediaButton PAUSE_BUTTON = new MediaButton(I18n.tr("Pause"), "pause_up", "pause_dn");
    private static final MediaButton STOP_BUTTON = new MediaButton(I18n.tr("Stop"), "stop_up", "stop_dn");
    private static final MediaButton NEXT_BUTTON = new MediaButton(I18n.tr("Next"), "forward_up", "forward_dn");
    private static final MediaButton PREV_BUTTON = new MediaButton(I18n.tr("Previous"), "rewind_up", "rewind_dn");
    private static final MediaSlider VOLUME = new MediaSlider("volume_track_left", "volume_track_center", "volume_track_right", "volume_thumb_up", "volume_thumb_dn");
    private static final SongProgressBar PROGRESS = new SongProgressBar("progress_track_left", "progress_track_center", "progress_track_right", "progress_thumb_up", "progress_thumb_dn", "progress_bar");
    private static final ExecutorService SONG_QUEUE = ExecutorsHelper.newProcessingQueue("SongProcessor");
    private final AudioPlayer PLAYER;
    private final Dimension progressBarDimension = new Dimension(129, 19);
    private final Dimension volumeSliderDimension = new Dimension(63, 19);
    private volatile int currBeginIndex = -1;
    private Map<String, Object> audioProperties;
    private long lastScroll = System.currentTimeMillis();
    private PlayListItem currentPlayListItem;
    private JPanel myMediaPanel = null;
    private String currentFileName;
    private boolean playOneTime = false;
    private final Object cfnLock = new Object();

    private MediaPlayerComponent() {
        this.PLAYER = new LimeWirePlayer();
        this.PLAYER.addAudioPlayerListener(this);
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
    }

    public static MediaPlayerComponent getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MediaPlayerComponent();
        }
        return INSTANCE;
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    private JPanel constructMediaPanel() {
        int n = 0;
        int n2 = 0;
        n2 += PLAY_BUTTON.getIcon().getIconHeight() + 2;
        n += PLAY_BUTTON.getIcon().getIconWidth() + 2 + PAUSE_BUTTON.getIcon().getIconWidth() + 2 + STOP_BUTTON.getIcon().getIconWidth() + 2 + NEXT_BUTTON.getIcon().getIconWidth() + 2 + PREV_BUTTON.getIcon().getIconWidth() + 2;
        PROGRESS.setMaximumSize(this.progressBarDimension);
        PROGRESS.setPreferredSize(this.progressBarDimension);
        PROGRESS.setString(I18n.tr("FrostWire Media Player"));
        PROGRESS.setMaximum(3600);
        PROGRESS.setEnabled(false);
        VOLUME.setMaximumSize(this.volumeSliderDimension);
        VOLUME.setPreferredSize(this.volumeSliderDimension);
        VOLUME.setMinimum(0);
        VOLUME.setValue(50);
        VOLUME.setMaximum(100);
        VOLUME.setEnabled(true);
        this.registerListeners();
        MediaPlayerPanel mediaPlayerPanel = new MediaPlayerPanel(0);
        mediaPlayerPanel.setMaximumSize(new Dimension(n + PROGRESS.getWidth() + VOLUME.getWidth(), n2));
        mediaPlayerPanel.setMinimumSize(new Dimension(n, n2));
        mediaPlayerPanel.add(Box.createHorizontalGlue());
        mediaPlayerPanel.add(VOLUME);
        mediaPlayerPanel.add(Box.createHorizontalStrut(2));
        mediaPlayerPanel.add(PREV_BUTTON);
        mediaPlayerPanel.add(PLAY_BUTTON);
        mediaPlayerPanel.add(PAUSE_BUTTON);
        mediaPlayerPanel.add(STOP_BUTTON);
        mediaPlayerPanel.add(NEXT_BUTTON);
        mediaPlayerPanel.add(Box.createHorizontalStrut(2));
        mediaPlayerPanel.add(PROGRESS);
        if (OSUtils.isMacOSX()) {
            mediaPlayerPanel.add(Box.createHorizontalStrut(16));
        }
        mediaPlayerPanel.add(Box.createHorizontalGlue());
        return mediaPlayerPanel;
    }

    public void registerListeners() {
        PLAY_BUTTON.addActionListener(new PlayListener());
        PAUSE_BUTTON.addActionListener(new PauseListener());
        STOP_BUTTON.addActionListener(new StopListener());
        NEXT_BUTTON.addActionListener(new NextListener());
        PREV_BUTTON.addActionListener(new BackListener());
        VOLUME.addChangeListener(new VolumeSliderListener());
        PROGRESS.addChangeListener(new ProgressBarListener());
    }

    public void unregisterListeners() {
        PLAY_BUTTON.removeActionListener(new PlayListener());
        PAUSE_BUTTON.removeActionListener(new PauseListener());
        STOP_BUTTON.removeActionListener(new StopListener());
        NEXT_BUTTON.removeActionListener(new NextListener());
        PREV_BUTTON.removeActionListener(new BackListener());
        VOLUME.removeChangeListener(new VolumeSliderListener());
        PROGRESS.removeChangeListener(new ProgressBarListener());
    }

    @Override
    public void refresh() {
        this.PLAYER.refresh();
        if (this.getMediaPanel().getSize().width < 351) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    PROGRESS.setVisible(false);
                    VOLUME.setVisible(false);
                }
            });
        } else {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    PROGRESS.setVisible(true);
                    VOLUME.setVisible(true);
                }
            });
        }
    }

    @Override
    public void updateTheme() {
        ((MediaPlayerPanel)this.getMediaPanel()).updateTheme();
        PLAY_BUTTON.updateTheme();
        PAUSE_BUTTON.updateTheme();
        STOP_BUTTON.updateTheme();
        NEXT_BUTTON.updateTheme();
        PREV_BUTTON.updateTheme();
        PROGRESS.updateTheme();
        PROGRESS.setString(I18n.tr("FrostWire Media Player"));
        VOLUME.updateTheme();
    }

    private void setProgressString(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PROGRESS.setString(string);
            }
        });
    }

    private void setProgressValue(final int n) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PROGRESS.setValue(n);
            }
        });
    }

    private void setProgressEnabled(final boolean bl) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PROGRESS.setEnabled(bl);
            }
        });
    }

    private void setVolumeValue() {
        VOLUME.repaint();
        this.PLAYER.setVolume((float)VOLUME.getValue() / (float)VOLUME.getMaximum());
    }

    public void loadSong(PlayListItem playListItem) {
        this.loadSong(playListItem, false);
    }

    public void loadSong(PlayListItem playListItem, boolean bl) {
        if (playListItem == null || playListItem.getAudioSource() == null) {
            return;
        }
        this.currentPlayListItem = playListItem;
        this.playOneTime = bl;
        this.loadSong(this.currentPlayListItem.getAudioSource(), playListItem.getName());
    }

    private void loadSong(AudioSource audioSource, String string) {
        if (audioSource == null) {
            return;
        }
        SONG_QUEUE.execute(new SongLoader(audioSource));
        this.currentFileName = string != null && string.length() > 0 ? this.generateNameDisplay(string) : this.generateNameDisplay(STREAMING_AUDIO);
    }

    public void play() {
        if (this.PLAYER.getStatus() == PlayerState.PAUSED || this.PLAYER.getStatus() == PlayerState.PLAYING) {
            this.PLAYER.unpause();
        } else {
            this.loadSong(this.currentPlayListItem, this.playOneTime);
        }
    }

    public void pauseSong() {
        if (this.PLAYER.getStatus() == PlayerState.PAUSED) {
            this.PLAYER.unpause();
        } else {
            this.PLAYER.pause();
        }
    }

    public void stopSong() {
        this.PLAYER.stop();
    }

    public void skip(double d) {
        String string;
        if (this.audioProperties != null && this.audioProperties.containsKey("audio.type") && this.isSeekable(string = (String)this.audioProperties.get("audio.type")) && this.audioProperties.containsKey("audio.length.bytes")) {
            long l = Math.round((double)((Integer)this.audioProperties.get("audio.length.bytes")).intValue() * d);
            this.PLAYER.seekLocation(l);
        }
    }

    private boolean isSeekable(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(MP3) || string.equalsIgnoreCase(WAVE);
    }

    public PlayListItem getCurrentSong() {
        return this.currentPlayListItem;
    }

    private String generateNameDisplay(String string) {
        if (string.length() > 20) {
            string = string + " *** " + string + " *** ";
        }
        this.currBeginIndex = -1;
        return string;
    }

    @Override
    public void songOpened(Map<String, Object> map) {
        this.audioProperties = map;
        this.setVolumeValue();
        if (this.audioProperties.containsKey("audio.length.bytes") && this.isSeekable((String)this.audioProperties.get("audio.type"))) {
            this.setProgressEnabled(true);
        } else {
            this.setProgressEnabled(false);
        }
        GUIMediator.getPlayList().playStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progressChange(int n) {
        if (this.audioProperties.containsKey("audio.length.bytes")) {
            int n2 = (Integer)this.audioProperties.get("audio.length.bytes");
            float f = (float)n * 1.0f / (float)n2 * 1.0f;
            if (!PROGRESS.getValueIsAdjusting() && this.PLAYER.getStatus() != PlayerState.SEEKING) {
                this.setProgressValue((int)((float)PROGRESS.getMaximum() * f));
            }
        }
        if (this.currentFileName.length() <= 20) {
            this.setProgressString(this.currentFileName);
        } else if (System.currentTimeMillis() - this.lastScroll > 200L) {
            Object object = this.cfnLock;
            synchronized (object) {
                this.lastScroll = System.currentTimeMillis();
                if (this.currentFileName == null) {
                    return;
                }
                ++this.currBeginIndex;
                if (this.currBeginIndex > this.currentFileName.length() / 2) {
                    this.currBeginIndex = 0;
                }
                this.setProgressString(this.currentFileName.substring(this.currBeginIndex, this.currBeginIndex + 20));
            }
        }
    }

    @Override
    public void stateChange(AudioPlayerEvent audioPlayerEvent) {
        if (audioPlayerEvent.getState() == PlayerState.UNKNOWN) {
            this.setProgressEnabled(false);
        } else if (audioPlayerEvent.getState() == PlayerState.OPENED || audioPlayerEvent.getState() == PlayerState.SEEKED) {
            this.setVolumeValue();
        } else if (audioPlayerEvent.getState() == PlayerState.STOPPED) {
            this.setProgressValue(PROGRESS.getMinimum());
        } else if (audioPlayerEvent.getState() == PlayerState.EOM) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("play completed for: " + this.currentFileName);
            }
            this.setProgressValue(PROGRESS.getMinimum());
            PlaylistMediator playlistMediator = GUIMediator.getPlayList();
            if (playlistMediator == null) {
                return;
            }
            if (this.playOneTime || !playlistMediator.isContinuous() || playlistMediator.getSize() <= 0 || playlistMediator.isEndOfList() && !playlistMediator.isContinuous()) {
                playlistMediator.playComplete();
                this.PLAYER.stop();
                System.out.println("FTA DEBUG: Reached end of playlist *stopped*");
            } else {
                playlistMediator.playComplete();
                this.loadSong(playlistMediator.getNextSong());
            }
        }
    }

    String getSongs() {
        PlaylistMediator playlistMediator = GUIMediator.getPlayList();
        List<PlayListItem> list = playlistMediator.getSongs();
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null) {
            for (PlayListItem playListItem : list) {
                stringBuffer.append(playListItem.getName()).append('\t').append(playListItem.getURI()).append('\t').append(playListItem.getProperty("Length")).append('\t').append(playListItem.isStorePreview()).append('|');
            }
        }
        System.out.println("songs:" + stringBuffer);
        return stringBuffer.toString();
    }

    String playSong(Map<String, String> map) {
        Tagged<String> tagged = LimeWireUtils.getArg(map, "url", "AddToPlaylist");
        if (!tagged.isValid()) {
            return tagged.getValue();
        }
        String string = tagged.getValue();
        PlaylistMediator playlistMediator = GUIMediator.getPlayList();
        List<PlayListItem> list = playlistMediator.getSongs();
        PlayListItem playListItem = null;
        for (PlayListItem playListItem2 : list) {
            try {
                String string2;
                String string3 = URLDecoder.decode(playListItem2.getURI().toString());
                if (!string3.equals(string2 = URLDecoder.decode(string))) continue;
                playListItem = playListItem2;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (playListItem != null) {
            this.loadSong(playListItem);
            return "ok";
        }
        if (this.PLAYER.getStatus() == PlayerState.PAUSED || this.PLAYER.getStatus() == PlayerState.PLAYING) {
            this.PLAYER.unpause();
        } else {
            this.loadSong(this.currentPlayListItem);
        }
        return "ok";
    }

    String removeFromPlaylist(int n) {
        PlaylistMediator playlistMediator = GUIMediator.getPlayList();
        if (playlistMediator.removeFileFromPlaylist(n)) {
            return "ok";
        }
        return "invalid.index: " + n;
    }

    String playIndexInPlaylist(int n) {
        PlaylistMediator playlistMediator = GUIMediator.getPlayList();
        if (playlistMediator.removeFileFromPlaylist(n)) {
            return "ok";
        }
        return "invalid.index: " + n;
    }

    String getProgress() {
        String string;
        if (this.isPlaying()) {
            int n = PROGRESS.getValue();
            int n2 = PROGRESS.getMaximum();
            System.out.println(n + ":" + n2);
            string = n + "\t" + n2;
        } else {
            string = "stopped";
        }
        return string.toString();
    }

    String addToPlaylist(Map<String, String> map) {
        Tagged<String> tagged = LimeWireUtils.getArg(map, "url", "AddToPlaylist");
        if (!tagged.isValid()) {
            return tagged.getValue();
        }
        Tagged<String> tagged2 = LimeWireUtils.getArg(map, "name", "AddtoPlaylist");
        if (!tagged2.isValid()) {
            return tagged2.getValue();
        }
        Tagged<String> tagged3 = LimeWireUtils.getArg(map, "length", "AddtoPlaylist");
        if (!tagged3.isValid()) {
            return tagged3.getValue();
        }
        Tagged<String> tagged4 = LimeWireUtils.getArg(map, "artist", "AddtoPlaylist");
        if (!tagged4.isValid()) {
            return tagged4.getValue();
        }
        Tagged<String> tagged5 = LimeWireUtils.getArg(map, "album", "AddtoPlaylist");
        if (!tagged5.isValid()) {
            return tagged5.getValue();
        }
        String string = "http://riaa.com";
        int n = 0;
        if (n > 0) {
            string = string + ":" + n;
        }
        String string2 = string + tagged.getValue();
        try {
            String string3 = URLDecoder.decode(string2);
            URL uRL = new URL(string3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("audio.length.bytes", tagged3.getValue());
            hashMap.put("audio.type", "MP3");
            hashMap.put("Artist", tagged4.getValue());
            if (tagged5.isValid()) {
                hashMap.put("Album", tagged5.getValue());
            }
            PlayListItem playListItem = new PlayListItem(uRL.toURI(), new AudioSource(uRL), tagged2.getValue(), false, hashMap);
            GUIMediator.instance().launchAudio(playListItem);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException, "invalid URL:" + string2);
            return "ERROR:invalid.url:" + string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorService.error(uRISyntaxException, "invalid URL:" + string2);
            return "ERROR:invalid.url:" + string2;
        }
        return "ok";
    }

    String playURL(Map<String, String> map) {
        Tagged<String> tagged = LimeWireUtils.getArg(map, "url", "PlayURL");
        if (!tagged.isValid()) {
            return tagged.getValue();
        }
        String string = "http://riaa.com";
        int n = 0;
        if (n > 0) {
            string = string + ":" + n;
        }
        String string2 = string + tagged.getValue();
        String string3 = this.getName(string2);
        try {
            String string4 = URLDecoder.decode(string2);
            URL uRL = new URL(string4);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            PlayListItem playListItem = new PlayListItem(uRL.toURI(), new AudioSource(uRL), string3, false, hashMap);
            GUIMediator.instance().launchAudio(playListItem);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException, "invalid URL:" + string2);
            return "ERROR:invalid.url:" + string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorService.error(uRISyntaxException, "invalid URL:" + string2);
            return "ERRORinvalid.url:" + string2;
        }
        return "ok";
    }

    private String getName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private boolean isPlaying() {
        return this.PLAYER.getStatus() != PlayerState.STOPPED && this.PLAYER.getStatus() != PlayerState.UNKNOWN && this.PLAYER.getStatus() != PlayerState.PAUSED;
    }

    public boolean attemptStop() {
        if (this.PLAYER.getStatus() != PlayerState.STOPPED) {
            this.PLAYER.stop();
            return true;
        }
        return false;
    }

    public void disableControls() {
        VOLUME.setEnabled(false);
        PAUSE_BUTTON.setEnabled(false);
    }

    public void enableControls() {
        VOLUME.setEnabled(true);
        PAUSE_BUTTON.setEnabled(true);
    }

    private void next() {
        this.stopSong();
        this.loadSong(GUIMediator.getPlayList().getNextSong());
        this.play();
    }

    private void back() {
        this.loadSong(GUIMediator.getPlayList().getPrevSong());
    }

    private class SongLoader
    implements Runnable {
        private final AudioSource audio;

        public SongLoader(AudioSource audioSource) {
            this.audio = audioSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (MediaPlayerComponent.this.PLAYER == null) {
                System.err.println("SongLoader.run(): There's no PLAYER to load the Song to");
                return;
            }
            if (this.audio != null) {
                MediaPlayerComponent.this.PLAYER.loadSong(this.audio);
            }
            if (MediaPlayerComponent.this.PLAYER.getStatus() != PlayerState.PLAYING) {
                MediaPlayerComponent.this.PLAYER.stop();
            }
            try {
                MediaPlayerComponent.this.PLAYER.playSong();
            }
            catch (Exception exception) {
                MediaPlayerComponent.this.PLAYER.stop();
                exception.printStackTrace();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    AudioPlayer audioPlayer = MediaPlayerComponent.this.PLAYER;
                    synchronized (audioPlayer) {
                        MediaPlayerComponent.this.PLAYER.notifyAll();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
    }

    private class VolumeSliderListener
    implements ChangeListener {
        private VolumeSliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MediaPlayerComponent.this.setVolumeValue();
        }
    }

    private class ProgressBarListener
    implements ChangeListener {
        boolean dragging = false;

        private ProgressBarListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (PROGRESS.getValueIsAdjusting()) {
                this.dragging = true;
            } else if (this.dragging) {
                this.dragging = false;
                if (MediaPlayerComponent.this.PLAYER.getStatus() != PlayerState.SEEKING) {
                    MediaPlayerComponent.this.skip((double)PROGRESS.getValue() * 1.0 / (double)PROGRESS.getMaximum());
                    MediaPlayerComponent.this.setProgressValue(PROGRESS.getValue());
                }
            }
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaPlayerComponent.this.pauseSong();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaPlayerComponent.this.back();
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaPlayerComponent.this.next();
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaPlayerComponent.this.stopSong();
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaPlayerComponent.this.play();
        }
    }
}

