/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.actions.ActionUtils;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.LibraryTableTransferHandler;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.gui.xml.editor.CCPublishWizard;
import com.limegroup.gnutella.gui.xml.editor.MetaEditor;
import com.limegroup.gnutella.gui.xml.editor.XmlTypeEditor;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Tuple;
import org.limewire.io.NetworkUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LibraryTableMediator
extends AbstractTableMediator<LibraryTableModel, LibraryTableDataLine, File>
implements VerificationListener,
FileDetailsProvider {
    private static final Log LOG = LogFactory.getLog(LibraryTableMediator.class);
    public static Action LAUNCH_ACTION;
    public static Action ENQUEUE_ACTION;
    public static Action DELETE_ACTION;
    public static Action ANNOTATE_ACTION;
    public static Action RESUME_ACTION;
    public static Action RENAME_ACTION;
    public static Action SHARE_ACTION;
    public static Action UNSHARE_ACTION;
    public static Action SHARE_FOLDER_ACTION;
    public static Action UNSHARE_FOLDER_ACTION;
    private Action PUBLISH_ACTION;
    private Action EDIT_LICENSE_ACTION;
    private Action VIEW_LICENSE_ACTION;
    private Action BITZI_LOOKUP_ACTION;
    private Action MAGNET_LOOKUP_ACTION;
    private Action COPY_MAGNET_TO_CLIPBOARD_ACTION;
    private boolean _isIncomplete;
    private boolean _annotateEnabled = false;
    private static LibraryTableMediator _instance;

    public static LibraryTableMediator instance() {
        return _instance;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        ENQUEUE_ACTION = new EnqueueAction();
        DELETE_ACTION = new RemoveAction();
        ANNOTATE_ACTION = new AnnotateAction();
        RESUME_ACTION = new ResumeAction();
        RENAME_ACTION = new RenameAction();
        SHARE_ACTION = new ShareFileAction();
        UNSHARE_ACTION = new UnshareFileAction();
        this.PUBLISH_ACTION = new PublishAction();
        this.EDIT_LICENSE_ACTION = new EditLicenseAction();
        this.VIEW_LICENSE_ACTION = new ViewLicenseAction();
        this.BITZI_LOOKUP_ACTION = new BitziLookupAction(this);
        this.MAGNET_LOOKUP_ACTION = new MagnetLookupAction();
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION = new CopyMagnetLinkToClipboardAction(this);
        SHARE_FOLDER_ACTION = new ShareFolderAction();
        UNSHARE_FOLDER_ACTION = new UnshareFolderAction();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = null;
        this.DATA_MODEL = new LibraryTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryTableModel)this.DATA_MODEL).setTable(this.TABLE);
        Action[] actionArray = new Action[]{LAUNCH_ACTION, ENQUEUE_ACTION, DELETE_ACTION, ANNOTATE_ACTION, this.PUBLISH_ACTION, RESUME_ACTION};
        this.BUTTON_ROW = new ButtonRow(actionArray, 0, 14);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(LAUNCH_ACTION));
        jPopupMenu.add(new JMenuItem(ENQUEUE_ACTION));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(RESUME_ACTION));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(DELETE_ACTION));
        jPopupMenu.add(new JMenuItem(RENAME_ACTION));
        jPopupMenu.addSeparator();
        int[] nArray = this.TABLE.getSelectedRows();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < nArray.length; ++i) {
            File file = ((LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(nArray[i])).getFile();
            if (file.isDirectory()) {
                bl = true;
                if (IncompleteFileManager.isTorrentFolder(file)) {
                    bl3 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl && bl2) break;
        }
        if (bl) {
            if (GUIMediator.isPlaylistVisible()) {
                ENQUEUE_ACTION.setEnabled(false);
            }
            DELETE_ACTION.setEnabled(bl3);
            RENAME_ACTION.setEnabled(false);
            if (bl2) {
                JMenu jMenu = new JMenu(I18n.tr("Sharing"));
                jMenu.add(new JMenuItem(SHARE_ACTION));
                jMenu.add(new JMenuItem(UNSHARE_ACTION));
                jMenu.add(new JMenuItem(ANNOTATE_ACTION));
                jMenu.addSeparator();
                jMenu.add(new JMenuItem(SHARE_FOLDER_ACTION));
                jMenu.add(new JMenuItem(UNSHARE_FOLDER_ACTION));
                jPopupMenu.add(jMenu);
            } else {
                jPopupMenu.add(new JMenuItem(SHARE_FOLDER_ACTION));
                jPopupMenu.add(new JMenuItem(UNSHARE_FOLDER_ACTION));
            }
        } else {
            if (GUIMediator.isPlaylistVisible() && PlaylistMediator.isPlayableFile(((LibraryTableModel)this.DATA_MODEL).getFile(nArray[0]))) {
                ENQUEUE_ACTION.setEnabled(true);
            }
            DELETE_ACTION.setEnabled(true);
            RENAME_ACTION.setEnabled(LibraryMediator.isRenameEnabled() && nArray.length == 1);
            jPopupMenu.add(new JMenuItem(SHARE_ACTION));
            jPopupMenu.add(new JMenuItem(UNSHARE_ACTION));
            jPopupMenu.add(new JMenuItem(ANNOTATE_ACTION));
        }
        jPopupMenu.addSeparator();
        LibraryTableDataLine libraryTableDataLine = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(nArray[0]);
        jPopupMenu.add(this.createLicenseMenu(libraryTableDataLine));
        jPopupMenu.add(this.createSearchSubMenu(libraryTableDataLine));
        jPopupMenu.add(this.createAdvancedMenu(libraryTableDataLine));
        return jPopupMenu;
    }

    private JMenu createLicenseMenu(LibraryTableDataLine libraryTableDataLine) {
        JMenu jMenu = new JMenu(I18n.tr("License"));
        if (libraryTableDataLine != null) {
            jMenu.add(new JMenuItem(this.PUBLISH_ACTION));
            jMenu.add(new JMenuItem(this.EDIT_LICENSE_ACTION));
            jMenu.add(new JMenuItem(this.VIEW_LICENSE_ACTION));
            jMenu.setEnabled(this.PUBLISH_ACTION.isEnabled() || this.EDIT_LICENSE_ACTION.isEnabled() || this.VIEW_LICENSE_ACTION.isEnabled());
        } else {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    private JMenu createAdvancedMenu(LibraryTableDataLine libraryTableDataLine) {
        JMenu jMenu = new JMenu(I18n.tr("Advanced"));
        if (libraryTableDataLine != null) {
            jMenu.add(new JMenuItem(this.BITZI_LOOKUP_ACTION));
            jMenu.add(new JMenuItem(this.MAGNET_LOOKUP_ACTION));
            jMenu.add(new JMenuItem(this.COPY_MAGNET_TO_CLIPBOARD_ACTION));
            File file = this.getFile(this.TABLE.getSelectedRow());
            jMenu.setEnabled(GuiCoreMediator.getFileManager().isFileShared(file));
        }
        if (jMenu.getItemCount() == 0) {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    private JMenu createSearchSubMenu(LibraryTableDataLine libraryTableDataLine) {
        JMenu jMenu = new JMenu(I18n.tr("Search"));
        if (libraryTableDataLine != null) {
            LimeXMLDocument limeXMLDocument;
            File file = (File)libraryTableDataLine.getInitializeObject();
            String string = QueryUtils.createQueryString(file.getName());
            if (string.length() > 2) {
                jMenu.add(new JMenuItem(new SearchAction(string)));
            }
            if ((limeXMLDocument = libraryTableDataLine.getXMLDocument()) != null) {
                Action[] actionArray = ActionUtils.createSearchActions(limeXMLDocument);
                for (int i = 0; i < actionArray.length; ++i) {
                    jMenu.add(new JMenuItem(actionArray[i]));
                }
            }
        }
        if (jMenu.getItemCount() == 0) {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryTableMediator() {
        super("LIBRARY_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new LibraryTableTransferHandler());
    }

    @Override
    public JComponent getComponent() {
        return null;
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new LibraryTableCellEditor(this));
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.TABLE.addMouseListener(mouseInputListener);
        this.TABLE.addMouseMotionListener(mouseInputListener);
    }

    public void setAnnotateEnabled(boolean bl) {
        this._annotateEnabled = bl;
        LibraryTableDataLine.setXMLEnabled(bl);
        ((LibraryTableModel)this.DATA_MODEL).refresh();
        this.handleSelection(-1);
    }

    void setIncompleteSelected(boolean bl) {
        if (bl == this._isIncomplete) {
            return;
        }
        this._isIncomplete = bl;
        if (!bl) {
            RESUME_ACTION.setEnabled(false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            RESUME_ACTION.setEnabled(true);
        }
    }

    void updateTableFiles(DirectoryHolder directoryHolder) {
        if (directoryHolder == null) {
            return;
        }
        this.clearTable();
        this.setIncompleteSelected(LibraryMediator.incompleteDirectoryIsSelected());
        File[] fileArray = directoryHolder.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.addUnsorted(fileArray[i]);
        }
        this.forceResort();
    }

    void handleFileManagerEvent(FileManagerEvent fileManagerEvent, DirectoryHolder directoryHolder) {
        if (fileManagerEvent == null || directoryHolder == null) {
            return;
        }
        File[] fileArray = fileManagerEvent.getFiles();
        FileDesc[] fileDescArray = fileManagerEvent.getFileDescs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling event: " + fileManagerEvent);
        }
        switch (fileManagerEvent.getType()) {
            case REMOVE_STORE_FILE: 
            case REMOVE_FILE: {
                File file = fileDescArray[0].getFile();
                if (directoryHolder.accept(file)) {
                    ((LibraryTableModel)this.DATA_MODEL).reinitialize(file);
                    this.handleSelection(-1);
                    break;
                }
                if (!((LibraryTableModel)this.DATA_MODEL).contains(file)) break;
                ((LibraryTableModel)this.DATA_MODEL).remove(file);
                this.handleSelection(-1);
                break;
            }
            case ADD_STORE_FILE: 
            case ADD_FILE: {
                if (!directoryHolder.accept(fileDescArray[0].getFile())) break;
                this.add(fileDescArray[0].getFile());
                this.handleSelection(-1);
                break;
            }
            case CHANGE_FILE: {
                File file = fileDescArray[0].getFile();
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(file);
                this.handleSelection(-1);
                break;
            }
            case RENAME_FILE: {
                File file = fileDescArray[0].getFile();
                File file2 = fileDescArray[1].getFile();
                if (directoryHolder.accept(file2)) {
                    if (((LibraryTableModel)this.DATA_MODEL).contains(file)) {
                        ((LibraryTableModel)this.DATA_MODEL).reinitialize(file, file2);
                        this.handleSelection(-1);
                        break;
                    }
                    ((LibraryTableModel)this.DATA_MODEL).add(file2);
                    break;
                }
                ((LibraryTableModel)this.DATA_MODEL).remove(file);
                break;
            }
            case ADD_STORE_FOLDER: 
            case ADD_FOLDER: {
                if (!directoryHolder.accept(fileArray[0])) break;
                this.add(fileArray[0]);
                this.handleSelection(-1);
                break;
            }
            case REMOVE_STORE_FOLDER: 
            case REMOVE_FOLDER: {
                File file = fileArray[0];
                if (directoryHolder.accept(file)) {
                    ((LibraryTableModel)this.DATA_MODEL).reinitialize(file);
                    this.handleSelection(-1);
                    break;
                }
                if (!((LibraryTableModel)this.DATA_MODEL).contains(file)) break;
                ((LibraryTableModel)this.DATA_MODEL).remove(file);
                this.handleSelection(-1);
            }
        }
    }

    File getFile(int n) {
        return ((LibraryTableModel)this.DATA_MODEL).getFile(n);
    }

    private FileDesc getFileDesc(int n) {
        return ((LibraryTableModel)this.DATA_MODEL).getFileDesc(n);
    }

    @Override
    public FileDetails[] getFileDetails() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList<FileDetails> arrayList = new ArrayList<FileDetails>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            FileDesc fileDesc = this.getFileDesc(nArray[i]);
            if (fileDesc == null) continue;
            arrayList.add(GuiCoreMediator.getLocalFileDetailsFactory().create(fileDesc));
        }
        if (arrayList.isEmpty()) {
            return new FileDetails[0];
        }
        return arrayList.toArray(new FileDetails[0]);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    LibraryTableDataLine[] getSelectedLibraryLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        LibraryTableDataLine[] libraryTableDataLineArray = new LibraryTableDataLine[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            libraryTableDataLineArray[i] = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(nArray[i]);
        }
        return libraryTableDataLineArray;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    private boolean isSupportedFormat(FileDesc[] fileDescArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < fileDescArray.length; ++i) {
            String string = fileDescArray[i].getFileName();
            if (!(!MediaType.getAudioMediaType().matches(string) || bl2 || bl3 || bl4 || bl5)) {
                bl = true;
                continue;
            }
            if (!(!MediaType.getVideoMediaType().matches(string) || bl || bl3 || bl4 || bl5)) {
                bl2 = true;
                continue;
            }
            if (!(!MediaType.getProgramMediaType().matches(string) || bl || bl2 || bl4 || bl5)) {
                bl3 = true;
                continue;
            }
            if (!(!MediaType.getDocumentMediaType().matches(string) || bl || bl2 || bl3 || bl5)) {
                bl4 = true;
                continue;
            }
            if (!(!MediaType.getImageMediaType().matches(string) || bl || bl2 || bl3 || bl4)) {
                bl5 = true;
                continue;
            }
            return false;
        }
        return true;
    }

    void editMeta(boolean bl) {
        Object object;
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList<FileDesc> arrayList = new ArrayList<FileDesc>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            object = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(nArray[i]);
            if (object == null) continue;
            arrayList.add((FileDesc)object);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        FileDesc[] fileDescArray = arrayList.toArray(new FileDesc[0]);
        object = fileDescArray[0].getFile().getName();
        JFrame jFrame = GUIMediator.getAppFrame();
        if (this.isSupportedFormat(fileDescArray)) {
            try {
                if (bl) {
                    FileDesc fileDesc = fileDescArray[0];
                    LimeXMLDocument limeXMLDocument = fileDesc.getXMLDocument("http://www.limewire.com/schemas/audio.xsd");
                    LimeXMLSchemaRepository limeXMLSchemaRepository = GuiCoreMediator.getLimeXMLSchemaRepository();
                    LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema("http://www.limewire.com/schemas/audio.xsd");
                    if (limeXMLSchema == null) {
                        throw new IllegalStateException("no audio schema!");
                    }
                    CCPublishWizard cCPublishWizard = new CCPublishWizard(fileDesc, limeXMLDocument, limeXMLSchema);
                    cCPublishWizard.showDialog(jFrame);
                } else {
                    MetaEditor metaEditor = new MetaEditor((Frame)jFrame, fileDescArray, (String)object);
                    metaEditor.setLocationRelativeTo(jFrame);
                    metaEditor.setVisible(true);
                }
                return;
            }
            catch (IllegalStateException illegalStateException) {
                if (bl) {
                    GUIMediator.showError(I18n.tr("FrostWire cannot publish this file because it was unable to find a schema for audio files."));
                    return;
                }
            }
        } else {
            XmlTypeEditor xmlTypeEditor = new XmlTypeEditor((Frame)jFrame, fileDescArray, (String)object);
            xmlTypeEditor.setLocationRelativeTo(jFrame);
            xmlTypeEditor.setVisible(true);
        }
    }

    void startRename() {
        int n = this.TABLE.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = this.TABLE.convertColumnIndexToView(1);
        this.TABLE.editCellAt(n, n2, LibraryTableCellEditor.EVENT);
    }

    void showLicenseWindow() {
        LibraryTableDataLine libraryTableDataLine = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (libraryTableDataLine == null) {
            return;
        }
        FileDesc fileDesc = libraryTableDataLine.getFileDesc();
        License license = fileDesc.getLicense();
        URN uRN = fileDesc.getSHA1Urn();
        LimeXMLDocument limeXMLDocument = libraryTableDataLine.getXMLDocument();
        LicenseWindow licenseWindow = LicenseWindow.create(license, uRN, limeXMLDocument, this);
        GUIUtils.centerOnScreen(licenseWindow);
        licenseWindow.setVisible(true);
    }

    @Override
    public void licenseVerified(License license) {
        ((LibraryTableModel)this.DATA_MODEL).refresh();
    }

    void doMagnetLookup() {
        this.doMagnetCommand("/magcmd/detail?");
    }

    void doMagnetCommand(String string) {
        int[] nArray = this.TABLE.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = GuiCoreMediator.getLocalAcceptor().getPort();
        int n4 = GuiCoreMediator.getAcceptor().getPort(true);
        byte[] byArray = GuiCoreMediator.getAcceptor().getAddress(true);
        String string2 = "http://localhost:" + n3 + string + "addr=" + NetworkUtils.ip2string(byArray) + ":" + n4;
        for (int i = 0; i < n; ++i) {
            URN uRN;
            FileDesc fileDesc = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(nArray[i]);
            if (fileDesc == null || (uRN = fileDesc.getSHA1Urn()) == null) continue;
            String string3 = uRN.toString();
            int n5 = 1 + string3.indexOf(":", 4);
            String string4 = string3.substring(n5);
            string2 = string2 + "&n" + n2 + "=" + EncodingUtils.encode(fileDesc.getFileName()) + "&u" + n2 + "=" + string4;
            ++n2;
            bl = true;
        }
        if (bl) {
            GUIMediator.openURL(string2);
        }
    }

    private static Object[] createRemoveOptions() {
        if (OSUtils.supportsTrash()) {
            String string = OSUtils.isWindows() ? I18n.tr("Move to Recycle Bin") : I18n.tr("Move to Trash");
            return new Object[]{string, I18n.tr("Delete"), I18n.tr("Cancel")};
        }
        return new Object[]{I18n.tr("Delete"), I18n.tr("Cancel")};
    }

    @Override
    public void removeSelection() {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        if (this.TABLE.isEditing()) {
            object = this.TABLE.getCellEditor();
            object.cancelCellEditing();
        }
        object = new ArrayList(nArray.length);
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray2 = ((LibraryTableModel)this.DATA_MODEL).getFile(nArray[i]);
            objectArray = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(nArray[i]);
            object.add(new Tuple<File, FileDesc>((File)objectArray2, (FileDesc)objectArray));
        }
        CheckBoxListPanel<Tuple<File, FileDesc>> checkBoxListPanel = new CheckBoxListPanel<Tuple<File, FileDesc>>((Collection<Tuple<File, FileDesc>>)object, new TupleTextProvider(), true);
        checkBoxListPanel.getList().setVisibleRowCount(4);
        objectArray2 = new Object[]{new MultiLineLabel(I18n.tr("Are you sure you want to delete the selected file(s), thus removing it from your computer?"), 400), Box.createVerticalStrut(6), checkBoxListPanel, Box.createVerticalStrut(6)};
        objectArray = LibraryTableMediator.createRemoveOptions();
        int n = JOptionPane.showOptionDialog(MessageService.getParentComponent(), objectArray2, I18n.tr("Message"), 0, 3, null, objectArray, objectArray[0]);
        if (n == objectArray.length - 1 || n == -1) {
            return;
        }
        List<Tuple<File, FileDesc>> list = checkBoxListPanel.getSelectedElements();
        ArrayList<String> arrayList = new ArrayList<String>();
        FileManager fileManager = GuiCoreMediator.getFileManager();
        IncompleteFileManager incompleteFileManager = GuiCoreMediator.getDownloadManager().getIncompleteFileManager();
        for (Tuple<File, FileDesc> tuple : list) {
            File file = tuple.getFirst();
            FileDesc fileDesc = tuple.getSecond();
            if (this._isIncomplete && this.hasActiveDownloader(file)) {
                arrayList.add(this.getCompleteFileName(file));
                continue;
            }
            if (fileDesc instanceof IncompleteFileDesc || fileDesc == null) {
                incompleteFileManager.removeEntry(file);
            } else {
                fileManager.removeFileIfShared(file);
            }
            if (fileDesc != null) {
                GuiCoreMediator.getUploadManager().killUploadsForFileDesc(fileDesc);
            }
            GuiCoreMediator.getTorrentManager().killTorrentForFile(file);
            boolean bl = FileUtils.delete(file, objectArray.length > 2 && n == 0);
            if (bl) {
                ((LibraryTableModel)this.DATA_MODEL).remove(((LibraryTableModel)this.DATA_MODEL).getRow(file));
                continue;
            }
            arrayList.add(this.getCompleteFileName(file));
        }
        this.clearSelection();
        if (arrayList.isEmpty()) {
            return;
        }
        objectArray2 = new Object[]{new MultiLineLabel(I18n.tr("The following files could not be deleted. They may be in use by another application or are currently being downloaded to."), 400), Box.createVerticalStrut(6), new JScrollPane(LibraryTableMediator.createFileList(arrayList))};
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), objectArray2, I18n.tr("Error"), 0);
    }

    private static JList createFileList(List<String> list) {
        JList<Object> jList = new JList<Object>(list.toArray());
        jList.setVisibleRowCount(5);
        jList.setCellRenderer(new FileNameListCellRenderer());
        jList.setSelectionForeground(jList.getForeground());
        jList.setSelectionBackground(jList.getBackground());
        jList.setFocusable(false);
        return jList;
    }

    private String getCompleteFileName(File file) {
        if (this._isIncomplete) {
            try {
                return IncompleteFileManager.getCompletedName(file);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return file.getName();
    }

    private boolean hasActiveDownloader(File file) {
        return GuiCoreMediator.getDownloadManager().getDownloaderForIncompleteFile(file) != null;
    }

    String handleNameChange(String string) {
        int n = this.TABLE.getEditingRow();
        LibraryTableModel libraryTableModel = (LibraryTableModel)this.DATA_MODEL;
        File file = libraryTableModel.getFile(n);
        String string2 = file.getParent();
        String string3 = string + "." + libraryTableModel.getType(n);
        File file2 = new File(string2, string3);
        if (!libraryTableModel.getName(n).equals(string)) {
            if (file.renameTo(file2)) {
                GuiCoreMediator.getFileManager().renameFileIfSharedOrStore(file, file2);
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(file);
                return string;
            }
            GUIMediator.showError(I18n.tr("Unable to rename the file '{0}'. It may be in use by another application.", libraryTableModel.getName(n)));
            return libraryTableModel.getName(n);
        }
        return string;
    }

    @Override
    public void handleActionKey() {
        int[] nArray = this.TABLE.getSelectedRows();
        LibraryTableModel libraryTableModel = (LibraryTableModel)this.DATA_MODEL;
        for (int i = 0; i < nArray.length; ++i) {
            File file = libraryTableModel.getFile(nArray[i]);
            if (!file.isDirectory() || !LibraryMediator.setSelectedDirectory(file)) continue;
            return;
        }
        this.launch();
    }

    void resumeIncomplete() {
        Serializable serializable;
        int n;
        int[] nArray = this.TABLE.getSelectedRows();
        boolean bl = false;
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (n = 0; n < nArray.length; ++n) {
            serializable = ((LibraryTableModel)this.DATA_MODEL).getFile(nArray[n]);
            try {
                GuiCoreMediator.getDownloadServices().download((File)serializable);
                bl = true;
                continue;
            }
            catch (SaveLocationException saveLocationException) {
                arrayList.add(saveLocationException);
                continue;
            }
            catch (CantResumeException cantResumeException) {
                arrayList.add(cantResumeException);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            serializable = (Exception)arrayList.get(n);
            if (serializable instanceof SaveLocationException) {
                SaveLocationException saveLocationException = (SaveLocationException)serializable;
                if (saveLocationException.getErrorCode() == 10) {
                    GUIMediator.showError(I18n.tr("You are already downloading this file to \"{0}\".", saveLocationException.getFile()), QuestionsHandler.ALREADY_DOWNLOADING);
                    continue;
                }
                String string = CoreExceptionHandler.getSaveLocationErrorString(saveLocationException);
                GUIMediator.showError(string);
                continue;
            }
            if (!(serializable instanceof CantResumeException)) continue;
            GUIMediator.showError(I18n.tr("The file \"{0}\" is not a valid incomplete file and cannot be resumed.", ((CantResumeException)serializable).getFilename()), QuestionsHandler.CANT_RESUME);
        }
        if (bl) {
            this.switchToDownloadTab();
        }
    }

    private void switchToDownloadTab() {
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }

    void launch() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        GUILauncher.LaunchableProvider[] launchableProviderArray = new GUILauncher.LaunchableProvider[nArray.length];
        if (this._isIncomplete) {
            for (int i = 0; i < nArray.length; ++i) {
                launchableProviderArray[i] = new IncompleteProvider(((LibraryTableModel)this.DATA_MODEL).getFile(nArray[i]));
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                launchableProviderArray[i] = new CompleteProvider(((LibraryTableModel)this.DATA_MODEL).getFile(nArray[i]));
            }
        }
        GUILauncher.launch(launchableProviderArray);
    }

    @Override
    public void handleSelection(int n) {
        boolean bl;
        boolean bl2;
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            this.handleNoSelection();
            return;
        }
        LibraryTableDataLine libraryTableDataLine = (LibraryTableDataLine)((LibraryTableModel)this.DATA_MODEL).get(nArray[0]);
        File file = this.getFile(nArray[0]);
        boolean bl3 = GuiCoreMediator.getFileManager().isFileShared(file);
        LAUNCH_ACTION.setEnabled(true);
        DELETE_ACTION.setEnabled(true);
        if (GUIMediator.isPlaylistVisible()) {
            bl2 = false;
            for (bl = false; bl < nArray.length; bl += 1) {
                if (!PlaylistMediator.isPlayableFile(((LibraryTableModel)this.DATA_MODEL).getFile(nArray[bl]))) continue;
                bl2 = true;
                break;
            }
            ENQUEUE_ACTION.setEnabled(bl2);
        } else {
            ENQUEUE_ACTION.setEnabled(false);
        }
        if (!this._isIncomplete && this._annotateEnabled) {
            ANNOTATE_ACTION.setEnabled(bl3);
            bl2 = nArray.length == 1 && bl3 && LimeXMLUtils.isFilePublishable(file.getName());
            this.PUBLISH_ACTION.setEnabled(bl2 && !libraryTableDataLine.isLicensed());
            this.EDIT_LICENSE_ACTION.setEnabled(bl2 && libraryTableDataLine.isLicensed());
        } else {
            ANNOTATE_ACTION.setEnabled(false);
            this.PUBLISH_ACTION.setEnabled(false);
            this.EDIT_LICENSE_ACTION.setEnabled(false);
        }
        ANNOTATE_ACTION.setEnabled(nArray.length == 1);
        this.VIEW_LICENSE_ACTION.setEnabled(nArray.length == 1 && libraryTableDataLine.isLicensed());
        RESUME_ACTION.setEnabled(this._isIncomplete);
        RENAME_ACTION.setEnabled(LibraryMediator.isRenameEnabled() && nArray.length == 1);
        bl2 = false;
        bl = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < nArray.length; ++i) {
            File file2 = this.getFile(nArray[i]);
            if (file2.isDirectory()) {
                ANNOTATE_ACTION.setEnabled(false);
                boolean bl7 = false;
                if (this._isIncomplete && (bl7 = IncompleteFileManager.isTorrentFolder(file2))) {
                    LAUNCH_ACTION.setEnabled(false);
                }
                if (!bl6 && !bl7) {
                    DELETE_ACTION.setEnabled(false);
                    bl6 = true;
                }
                if (!GuiCoreMediator.getFileManager().isFolderShared(file2)) {
                    bl4 = true;
                    continue;
                }
                bl5 = true;
                continue;
            }
            if (!GuiCoreMediator.getFileManager().isFileShared(file2)) {
                if (!SharingUtils.isFilePhysicallyShareable(file2) || this._isIncomplete) continue;
                bl2 = true;
            } else {
                bl = true;
            }
            if (bl2 && bl && bl4 && bl5) break;
        }
        SHARE_ACTION.setEnabled(bl2);
        UNSHARE_ACTION.setEnabled(bl);
        SHARE_FOLDER_ACTION.setEnabled(bl4);
        UNSHARE_FOLDER_ACTION.setEnabled(bl5);
        this.MAGNET_LOOKUP_ACTION.setEnabled(bl3);
        this.BITZI_LOOKUP_ACTION.setEnabled(bl3);
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION.setEnabled(!this._isIncomplete && this.getFileDesc(nArray[0]) != null);
    }

    @Override
    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        ENQUEUE_ACTION.setEnabled(false);
        DELETE_ACTION.setEnabled(false);
        ANNOTATE_ACTION.setEnabled(false);
        RESUME_ACTION.setEnabled(false);
        RENAME_ACTION.setEnabled(false);
        SHARE_ACTION.setEnabled(false);
        UNSHARE_ACTION.setEnabled(false);
        SHARE_FOLDER_ACTION.setEnabled(false);
        UNSHARE_FOLDER_ACTION.setEnabled(false);
        this.PUBLISH_ACTION.setEnabled(false);
        this.EDIT_LICENSE_ACTION.setEnabled(false);
        this.VIEW_LICENSE_ACTION.setEnabled(false);
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION.setEnabled(false);
        this.MAGNET_LOOKUP_ACTION.setEnabled(false);
        this.BITZI_LOOKUP_ACTION.setEnabled(false);
    }

    public void setPlayerEnabled(boolean bl) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    public boolean setFileSelected(File file) {
        int n = ((LibraryTableModel)this.DATA_MODEL).getRow(file);
        if (n != -1) {
            this.TABLE.setSelectedRow(n);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    static {
        _instance = new LibraryTableMediator();
    }

    private static class CompleteProvider
    extends IncompleteProvider {
        public CompleteProvider(File file) {
            super(file);
        }

        public Downloader getDownloader() {
            return null;
        }
    }

    private static class IncompleteProvider
    implements GUILauncher.LaunchableProvider {
        private final File incompleteFile;

        public IncompleteProvider(File file) {
            this.incompleteFile = file;
        }

        public Downloader getDownloader() {
            return GuiCoreMediator.getDownloadManager().getDownloaderForIncompleteFile(this.incompleteFile);
        }

        public File getFile() {
            return this.incompleteFile;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TupleTextProvider
    implements CheckBoxList.TextProvider<Tuple<File, FileDesc>> {
        private TupleTextProvider() {
        }

        @Override
        public Icon getIcon(Tuple<File, FileDesc> tuple) {
            String string = FileUtils.getFileExtension(tuple.getFirst());
            if (string != null) {
                return IconManager.instance().getIconForExtension(string);
            }
            return null;
        }

        @Override
        public String getText(Tuple<File, FileDesc> tuple) {
            return LibraryTableMediator.this.getCompleteFileName(tuple.getFirst());
        }

        @Override
        public String getToolTipText(Tuple<File, FileDesc> tuple) {
            return tuple.getFirst().getAbsolutePath();
        }
    }

    private static class FileNameListCellRenderer
    extends DefaultListCellRenderer {
        private FileNameListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = FileUtils.getFileExtension(object.toString());
            if (string != null) {
                this.setIcon(IconManager.instance().getIconForExtension(string));
            }
            return this;
        }
    }

    private class ViewLicenseAction
    extends AbstractAction {
        public ViewLicenseAction() {
            this.putValue("Name", I18n.tr("View License"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.showLicenseWindow();
        }
    }

    private final class MagnetLookupAction
    extends AbstractAction {
        public MagnetLookupAction() {
            this.putValue("Name", I18n.tr("Show Magnet Details"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.doMagnetLookup();
        }
    }

    private class UnshareFolderAction
    extends AbstractAction {
        public UnshareFolderAction() {
            this.putValue("Name", I18n.tr("Stop Sharing Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryTableMediator.this.TABLE.getSelectedRows();
            final File[] fileArray = new File[nArray.length];
            for (int i = nArray.length - 1; i >= 0; --i) {
                fileArray[i] = LibraryTableMediator.this.getFile(nArray[i]);
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        if (file == null || !file.isDirectory()) continue;
                        GuiCoreMediator.getFileManager().removeFolderIfShared(file);
                    }
                }
            });
        }
    }

    private class ShareFolderAction
    extends AbstractAction {
        public ShareFolderAction() {
            this.putValue("Name", I18n.tr("Share Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> arrayList = new ArrayList<File>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                File file = LibraryTableMediator.this.getFile(nArray[i]);
                if (file == null || !file.isDirectory()) continue;
                arrayList.add(file);
            }
            final RecursiveSharingDialog recursiveSharingDialog = new RecursiveSharingDialog((Frame)GUIMediator.getAppFrame(), arrayList.toArray(new File[0]));
            if (recursiveSharingDialog.showChooseDialog(MessageService.getParentComponent()) == RecursiveSharingDialog.State.OK) {
                BackgroundExecutorService.schedule(new Runnable(){

                    public void run() {
                        GuiCoreMediator.getFileManager().addSharedFolders(recursiveSharingDialog.getRootsToShare(), recursiveSharingDialog.getFoldersToExclude());
                    }
                });
            }
        }
    }

    private class UnshareFileAction
    extends AbstractAction {
        public UnshareFileAction() {
            this.putValue("Name", I18n.tr("Stop Sharing File"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryTableMediator.this.TABLE.getSelectedRows();
            final File[] fileArray = new File[nArray.length];
            for (int i = nArray.length - 1; i >= 0; --i) {
                fileArray[i] = LibraryTableMediator.this.getFile(nArray[i]);
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        if (file == null || file.isDirectory()) continue;
                        GuiCoreMediator.getFileManager().stopSharingFile(file);
                    }
                }
            });
        }
    }

    private class ShareFileAction
    extends AbstractAction {
        public ShareFileAction() {
            this.putValue("Name", I18n.tr("Share File"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryTableMediator.this.TABLE.getSelectedRows();
            final File[] fileArray = new File[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fileArray[i] = LibraryTableMediator.this.getFile(nArray[i]);
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        if (file == null || file.isDirectory()) continue;
                        GuiCoreMediator.getFileManager().addFileAlways(file);
                    }
                }
            });
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", I18n.tr("Rename"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.startRename();
        }
    }

    private final class ResumeAction
    extends AbstractAction {
        public ResumeAction() {
            this.putValue("Name", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Continue Downloading Selected Incomplete File"));
            this.putValue("LimeIconName", "LIBRARY_RESUME");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.resumeIncomplete();
        }
    }

    private final class EditLicenseAction
    extends AbstractAction {
        public EditLicenseAction() {
            this.putValue("Name", I18n.tr("Edit License..."));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.editMeta(true);
        }
    }

    private final class PublishAction
    extends AbstractAction {
        public PublishAction() {
            this.putValue("Name", I18n.tr("Publish..."));
            this.putValue("ShortDescription", I18n.tr("Publish under Creative Commons License"));
            this.putValue("LimeIconName", "LIBRARY_PUBLISH");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.editMeta(true);
        }
    }

    private final class AnnotateAction
    extends AbstractAction {
        public AnnotateAction() {
            this.putValue("Name", I18n.tr("Describe..."));
            this.putValue("ShortDescription", I18n.tr("Add Description to Selected File"));
            this.putValue("LimeIconName", "LIBRARY_ANNOTATE");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.editMeta(false);
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.REMOVE_LISTENER.actionPerformed(actionEvent);
        }
    }

    private final class EnqueueAction
    extends AbstractAction {
        public EnqueueAction() {
            this.putValue("Name", I18n.tr("Enqueue"));
            this.putValue("ShortDescription", I18n.tr("Add Selected Files to the Playlist"));
            this.putValue("LimeIconName", "LIBRARY_TO_PLAYLIST");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                File file = ((LibraryTableModel)LibraryTableMediator.this.DATA_MODEL).getFile(n);
                if (!GUIMediator.isPlaylistVisible() || !PlaylistMediator.isPlayableFile(file)) continue;
                arrayList.add(file);
            }
            LibraryMediator.instance().addFilesToPlayList(arrayList);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        public LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.launch();
        }
    }
}

