/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.UploadCountHolder;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.MetaFileManager;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryTableDataLine
extends AbstractDataLine<File>
implements ThemeObserver,
FileTransfer {
    private static final Integer ZERO_INTEGER = new Integer(0);
    private static final UploadCountHolder ZERO_UPLOAD_COUNT_HOLDER = new UploadCountHolder(0, 0);
    private static boolean _allowXML;
    private static String[] _schemas;
    private static MetaFileManager _mfm;
    static final int ICON_IDX = 0;
    static final int NAME_IDX = 1;
    static final int SIZE_IDX = 2;
    static final int TYPE_IDX = 3;
    static final int PATH_IDX = 4;
    static final int UPLOADS_IDX = 5;
    static final int HITS_IDX = 6;
    static final int ALT_LOC_IDX = 7;
    static final int LICENSE_IDX = 8;
    static final int MODIFICATION_TIME_IDX = 9;
    static final int SHARED_IDX = 10;
    private static final LimeTableColumn[] ltColumns;
    private boolean _isDirectory;
    private String _name;
    private String _type;
    private long _size;
    private SizeHolder _sizeHolder;
    private FileDesc _fileDesc;
    private String _path;
    private Color _sharedCellColor;
    private Color _unsharedCellColor;
    private final LibraryTableModel _model;
    private boolean _iconLoaded = false;
    private boolean _iconScheduledForLoad = false;

    public LibraryTableDataLine(LibraryTableModel libraryTableModel) {
        this._model = libraryTableModel;
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    public void cleanup() {
        ThemeMediator.removeThemeObserver(this);
    }

    @Override
    public void updateTheme() {
        this._sharedCellColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
        this._unsharedCellColor = ThemeFileHandler.NOT_SHARING_LABEL_COLOR.getValue();
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    @Override
    public int getColumnCount() {
        return ltColumns.length;
    }

    @Override
    public void initialize(File file) {
        super.initialize(file);
        this._fileDesc = GuiCoreMediator.getFileManager().getFileDescForFile(file);
        String string = file.getPath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._name = ((File)this.initializer).getName();
        this._type = "";
        if (!file.isDirectory()) {
            this._isDirectory = false;
            int n = this._name.lastIndexOf(".");
            int n2 = string.lastIndexOf(File.separator);
            this._path = string.substring(0, n2);
            if (n != -1 && n != 0) {
                this._type = this._name.substring(n + 1);
                this._name = this._name.substring(0, n);
            }
        } else {
            this._path = string;
            this._isDirectory = true;
        }
        if (((File)this.initializer).isFile()) {
            long l = this._size;
            this._size = ((File)this.initializer).length();
            if (l != this._size) {
                this._sizeHolder = new SizeHolder(this._size);
            }
        }
    }

    void setFileDesc(FileDesc fileDesc) {
        this.initialize(fileDesc.getFile());
        this._fileDesc = fileDesc;
    }

    @Override
    public File getFile() {
        return (File)this.initializer;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                if (this.isIncompleteTorrent()) {
                    return GUIMediator.getThemeImage("bittorrent_incomplete");
                }
                boolean bl = IconManager.instance().isIconForFileAvailable((File)this.initializer);
                if (!bl && !this._iconScheduledForLoad) {
                    this._iconScheduledForLoad = true;
                    BackgroundExecutorService.schedule(new Runnable(){

                        public void run() {
                            GUIMediator.safeInvokeAndWait(new Runnable(){

                                public void run() {
                                    IconManager.instance().getIconForFile((File)LibraryTableDataLine.this.initializer);
                                    LibraryTableDataLine.this._iconLoaded = true;
                                    LibraryTableDataLine.this._model.refresh();
                                }
                            });
                        }
                    });
                    return null;
                }
                if (this._iconLoaded || bl) {
                    return IconManager.instance().getIconForFile((File)this.initializer);
                }
                return null;
            }
            case 1: {
                String string = this._name;
                if (LibraryMediator.incompleteDirectoryIsSelected()) {
                    try {
                        string = IncompleteFileManager.getCompletedName((File)this.initializer);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return new ColoredCellImpl(string, this.getColor());
            }
            case 2: {
                return new ColoredCellImpl(this._sizeHolder, this.getColor());
            }
            case 3: {
                return new ColoredCellImpl(this.isIncompleteTorrent() ? "torrent" : this._type, this.getColor());
            }
            case 6: {
                if (this._fileDesc == null) {
                    return null;
                }
                int n2 = this._fileDesc.getHitCount();
                return n2 == 0 ? ZERO_INTEGER : new Integer(n2);
            }
            case 7: {
                if (this._fileDesc == null) {
                    return null;
                }
                int n3 = GuiCoreMediator.getAltLocManager().getNumLocs(this._fileDesc.getSHA1Urn()) - 1;
                return n3 <= 0 ? ZERO_INTEGER : new Integer(n3);
            }
            case 5: {
                if (this._fileDesc == null) {
                    return null;
                }
                int n4 = this._fileDesc.getAttemptedUploads();
                int n5 = this._fileDesc.getCompletedUploads();
                return n4 == 0 && n5 == 0 ? ZERO_UPLOAD_COUNT_HOLDER : new UploadCountHolder(n4, n5);
            }
            case 4: {
                return new ColoredCellImpl(this._path, this.getColor());
            }
            case 8: {
                License license = this.getLicense();
                if (license != null) {
                    if (license.isValid(this._fileDesc.getSHA1Urn())) {
                        return new NameValue<Integer>(license.getLicenseName(), new Integer(2));
                    }
                    return new NameValue<Integer>(license.getLicenseName(), new Integer(0));
                }
                return null;
            }
            case 9: {
                if (this._fileDesc != null) {
                    return new Date(this._fileDesc.lastModified());
                }
                return new Date(((File)this.initializer).lastModified());
            }
            case 10: {
                if (GuiCoreMediator.getFileManager().isFileShared((File)this.initializer) || GuiCoreMediator.getFileManager().isFolderShared((File)this.initializer)) {
                    return GUIMediator.getThemeImage("sharing_on");
                }
                return GUIMediator.getThemeImage("sharing_off");
            }
        }
        return null;
    }

    private boolean isIncompleteTorrent() {
        return this._isDirectory && LibraryMediator.incompleteDirectoryIsSelected();
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        return ltColumns[n];
    }

    @Override
    public boolean isClippable(int n) {
        switch (n) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 1;
    }

    @Override
    public boolean isDynamic(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    static void setXMLEnabled(boolean bl) {
        _allowXML = bl;
        if (_allowXML) {
            _schemas = GuiCoreMediator.getLimeXMLSchemaRepository().getAvailableSchemaURIs();
            FileManager fileManager = GuiCoreMediator.getFileManager();
            if (fileManager instanceof MetaFileManager) {
                _mfm = (MetaFileManager)fileManager;
            }
        } else {
            _schemas = null;
            _mfm = null;
        }
    }

    boolean isLicensed() {
        return this._fileDesc != null && this._fileDesc.isLicensed();
    }

    License getLicense() {
        return this._fileDesc != null ? this._fileDesc.getLicense() : null;
    }

    LimeXMLDocument getXMLDocument() {
        List<LimeXMLDocument> list;
        if (this._fileDesc != null && !(list = this._fileDesc.getLimeXMLDocuments()).isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String[] getToolTipArray(int n) {
        if (10 == n) {
            boolean bl = false;
            boolean bl2 = this.getFile().isFile();
            if (GuiCoreMediator.getFileManager().isFileShared((File)this.initializer) || GuiCoreMediator.getFileManager().isFolderShared((File)this.initializer)) {
                bl = true;
            }
            if (bl2 && bl) {
                return new String[]{I18n.tr("This file is shared.")};
            }
            if (bl2 && !bl) {
                return new String[]{I18n.tr("This file is not shared.")};
            }
            if (!bl2 && bl) {
                return new String[]{I18n.tr("This folder is shared.")};
            }
            if (!bl2 && !bl) {
                return new String[]{I18n.tr("This folder is not shared.")};
            }
        }
        if (!_allowXML || _schemas == null || _schemas.length == 0 || _mfm == null || this._fileDesc == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (LimeXMLDocument limeXMLDocument : this._fileDesc.getLimeXMLDocuments()) {
            linkedList.addAll(XMLUtils.getDisplayList(limeXMLDocument));
        }
        if (!linkedList.isEmpty()) {
            linkedList.add(0, this._name);
            return linkedList.toArray(new String[linkedList.size()]);
        }
        return null;
    }

    private Color getColor() {
        if (this._fileDesc != null) {
            return this._sharedCellColor;
        }
        if (GuiCoreMediator.getFileManager().isFolderShared((File)this.initializer)) {
            return this._sharedCellColor;
        }
        return this._unsharedCellColor;
    }

    static {
        ltColumns = new LimeTableColumn[]{new LimeTableColumn(0, "LIBRARY_TABLE_ICON", I18n.tr("Icon"), GUIMediator.getThemeImage("question_mark"), 18, true, Icon.class), new LimeTableColumn(1, "LIBRARY_TABLE_NAME", I18n.tr("Name"), 239, true, ColoredCell.class), new LimeTableColumn(2, "LIBRARY_TABLE_SIZE", I18n.tr("Size"), 62, true, ColoredCell.class), new LimeTableColumn(3, "LIBRARY_TABLE_TYPE", I18n.tr("Type"), 48, true, ColoredCell.class), new LimeTableColumn(4, "LIBRARY_TABLE_PATH", I18n.tr("Path"), 108, true, ColoredCell.class), new LimeTableColumn(5, "LIBRARY_TABLE_UPLOAD_COUNT", I18n.tr("Uploads"), 62, true, UploadCountHolder.class), new LimeTableColumn(6, "LIBRARY_TABLE_HITCOUNT", I18n.tr("Hits"), 39, true, Integer.class), new LimeTableColumn(7, "LIBRARY_TABLE_NUMALTLOC", I18n.tr("Locations"), 72, true, Integer.class), new LimeTableColumn(8, "LIBRARY_TABLE_LICENSE", I18n.tr("License"), 20, true, License.class), new LimeTableColumn(9, "LIBRARY_TABLE_MODIFICATION_TIME", I18n.tr("Last Modified"), 20, false, Date.class), new LimeTableColumn(10, "LIBRARY_TABLE_SHARED", I18n.tr("Shared"), 20, true, Icon.class)};
    }
}

