/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public class LibrarySearchPanel
extends JPanel {
    private AutoCompleteSearchField queryField = new AutoCompleteSearchField(40);
    private final QueryRequestFactory queryRequestFactory;

    LibrarySearchPanel(QueryRequestFactory queryRequestFactory) {
        super(new GridBagLayout());
        this.queryRequestFactory = queryRequestFactory;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(I18n.tr("Search In Shared Files:") + " ");
        jLabel.setLabelFor(this.queryField);
        jLabel.setDisplayedMnemonic('S');
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.queryField, gridBagConstraints);
        SearchLibraryAction searchLibraryAction = new SearchLibraryAction();
        GUIUtils.bindKeyToAction(this.queryField, KeyStroke.getKeyStroke(10, 0), searchLibraryAction);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JButton(searchLibraryAction), gridBagConstraints);
    }

    private class AutoCompleteSearchField
    extends AutoCompleteTextField {
        public AutoCompleteSearchField(int n) {
            super(n);
        }

        protected Document createDefaultModel() {
            return new SearchField.SearchFieldDocument();
        }
    }

    private class SearchLibraryAction
    extends AbstractAction {
        public SearchLibraryAction() {
            this.putValue("Name", I18n.tr("Search"));
        }

        public boolean validate(SearchInformation searchInformation) {
            switch (SearchMediator.validateInfo(searchInformation)) {
                case 1: {
                    return false;
                }
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = LibrarySearchPanel.this.queryField.getText().trim();
            if (string.length() == 0) {
                LibrarySearchPanel.this.queryField.getToolkit().beep();
                return;
            }
            final SearchInformation searchInformation = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
            if (!this.validate(searchInformation)) {
                return;
            }
            LibrarySearchPanel.this.queryField.addToDictionary();
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    QueryRequest queryRequest = LibrarySearchPanel.this.queryRequestFactory.createQuery(searchInformation.getQuery());
                    FileManager fileManager = GuiCoreMediator.getFileManager();
                    Response[] responseArray = fileManager.query(queryRequest);
                    ArrayList<File> arrayList = new ArrayList<File>(responseArray.length);
                    for (Response response : responseArray) {
                        FileDesc fileDesc = fileManager.get((int)response.getIndex());
                        if (fileDesc == null) continue;
                        arrayList.add(fileDesc.getFile());
                    }
                    Object[] objectArray = arrayList.toArray(new File[arrayList.size()]);
                    Runnable runnable = new Runnable((File[])objectArray){
                        final /* synthetic */ File[] val$filesArray;
                        {
                            this.val$filesArray = fileArray;
                        }

                        public void run() {
                            LibraryTree.instance().getSearchResultsHolder().setResults(this.val$filesArray);
                            LibraryTree.instance().setSearchResultsNodeSelected();
                        }
                    };
                    GUIMediator.safeInvokeLater(runnable);
                }
            });
        }
    }
}

