/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

abstract class SetupWindow
extends JPanel {
    public static final int SETUP_WIDTH = 700;
    public static final int SETUP_HEIGHT = 540;
    private String _key;
    private String _labelKey;
    private String _moreInfoURL;
    private SetupWindow _next;
    private SetupWindow _previous;
    protected final SetupManager _manager;

    SetupWindow(SetupManager setupManager, String string, String string2) {
        this(setupManager, string, string2, null);
    }

    SetupWindow(SetupManager setupManager, String string, String string2, String string3) {
        this._manager = setupManager;
        this._key = string;
        this._labelKey = string2;
        this._moreInfoURL = string3;
    }

    protected void createWindow() {
        JLabel jLabel;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel2 = new JLabel(I18n.tr(this._key));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 5));
        jLabel2.setFont(new Font("Dialog", 1, 16));
        jLabel2.setForeground(Color.black);
        jLabel2.setOpaque(false);
        jPanel2.add((Component)jLabel2, "North");
        MultiLineLabel multiLineLabel = new MultiLineLabel(I18n.tr(this._labelKey));
        multiLineLabel.setOpaque(false);
        multiLineLabel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        multiLineLabel.setForeground(Color.black);
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(0));
        jPanel2.add((Component)multiLineLabel, "Center");
        if (this._moreInfoURL != null) {
            jLabel = new URLLabel(this._moreInfoURL, I18n.tr("Learn more about this option..."));
            jLabel.setOpaque(false);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
            jLabel.setForeground(Color.black);
            jLabel.setOpaque(false);
            jPanel2.add((Component)jLabel, "South");
        }
        jLabel = new JLabel();
        jLabel.setOpaque(false);
        jLabel.setIcon(this.getIcon());
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 8));
        jPanel.add((Component)jLabel, "East");
    }

    public String getName() {
        if (this._key == null) {
            return null;
        }
        return I18n.tr(this._key);
    }

    public String getKey() {
        return this._key;
    }

    protected void setLabelKey(String string) {
        this._labelKey = string;
    }

    public Icon getIcon() {
        return null;
    }

    public SetupWindow getNext() {
        return this._next;
    }

    public SetupWindow getPrevious() {
        return this._previous;
    }

    public void setNext(SetupWindow setupWindow) {
        this._next = setupWindow;
    }

    public void setPrevious(SetupWindow setupWindow) {
        this._previous = setupWindow;
    }

    public void handleWindowOpeningEvent() {
        this.createWindow();
        this._manager.enableActions(this.getAppropriateActions());
    }

    protected int getAppropriateActions() {
        int n = 8;
        if (this._next == this) {
            n |= 4;
        } else if (this._next != null) {
            n |= 2;
        }
        if (this._previous != this) {
            n |= 1;
        }
        return n;
    }

    public void applySettings(boolean bl) throws ApplySettingsException {
    }

    protected void setSetupComponent(JComponent jComponent) {
        jComponent.setBorder(new EmptyBorder(20, 10, 10, 10));
        this.add((Component)jComponent, "Center");
        this.revalidate();
    }

    protected static class MultiLineLabel
    extends JTextArea {
        public MultiLineLabel(String string) {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setHighlighter(null);
            LookAndFeel.installBorder(this, "Label.border");
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
            this.setSelectedTextColor(UIManager.getColor("Label.foreground"));
            this.setText(string);
        }

        public MultiLineLabel() {
            this(" ");
        }
    }
}

